### 1006 - Cmd Parameter Added

**Description**: Checks whether a new parameter is added to a cmd from the previous cli version. 

**Analysis**: This is considered an additive change in new cli version. 
* If the added parameter is a `required` argument, then, it is a breaking change
* If the added parameter is just optional, it's not a breaking change.

**Example**: A new parameter `--marketplace-partner-id` is being added to cmd `az monitor diagnostic-setting create` in new cli version.

#### Before
> az monitor diagnostic-settings create -h 
> 
> Command
>   
> az monitor diagnostic-settings create : Create diagnostic settings for the specified resource.
>
> Arguments
> 
> --name -n [Required] : The name of the diagnostic setting. Required.
> 
> --event-hub : Name or ID an event hub. 
> 
> --event-hub-rule : Name or ID of the event hub authorization rule.
> 
> ...
> 
> ...
> 

#### After 
> az monitor diagnostic-settings create -h 
> 
> Command
>   
> az monitor diagnostic-settings create : Create diagnostic settings for the specified resource.
>
> Arguments
> 
> --name -n [Required] : The name of the diagnostic setting. Required.
> 
> --marketplace-partner-id : The full ARM resource ID of the Marketplace resource to which you would like to send Diagnostic Logs.
> 
> --event-hub : Name or ID an event hub. 
> 
> --event-hub-rule : Name or ID of the event hub authorization rule.
> 
> ...
> 
> ...
> 