
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_seq_mv.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


/*--------------------------------------------------------------------------*/

HYPRE_CSRMatrix
HYPRE_CSRMatrixCreate( HYPRE_Int num_rows, HYPRE_Int num_cols, HYPRE_Int *row_sizes )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_CSRMatrixCreate_pre( precision, num_rows, num_cols, row_sizes );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CSRMatrixDestroy( HYPRE_CSRMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_CSRMatrixDestroy_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CSRMatrixGetNumRows( HYPRE_CSRMatrix matrix, HYPRE_Int *num_rows )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_CSRMatrixGetNumRows_pre( precision, matrix, num_rows );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CSRMatrixInitialize( HYPRE_CSRMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_CSRMatrixInitialize_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

void
HYPRE_CSRMatrixPrint( HYPRE_CSRMatrix matrix, char *file_name )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_CSRMatrixPrint_pre( precision, matrix, file_name );
}

/*--------------------------------------------------------------------------*/

HYPRE_CSRMatrix
HYPRE_CSRMatrixRead( char *file_name )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_CSRMatrixRead_pre( precision, file_name );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MappedMatrixAssemble( HYPRE_MappedMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MappedMatrixAssemble_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_MappedMatrix
HYPRE_MappedMatrixCreate( void )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MappedMatrixCreate_pre( precision );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MappedMatrixDestroy( HYPRE_MappedMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MappedMatrixDestroy_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MappedMatrixGetColIndex( HYPRE_MappedMatrix matrix, HYPRE_Int j )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MappedMatrixGetColIndex_pre( precision, matrix, j );
}

/*--------------------------------------------------------------------------*/

void *
HYPRE_MappedMatrixGetMatrix( HYPRE_MappedMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MappedMatrixGetMatrix_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MappedMatrixInitialize( HYPRE_MappedMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MappedMatrixInitialize_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MappedMatrixLimitedDestroy( HYPRE_MappedMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MappedMatrixLimitedDestroy_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

void
HYPRE_MappedMatrixPrint( HYPRE_MappedMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MappedMatrixPrint_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MappedMatrixSetMapData( HYPRE_MappedMatrix matrix, void *MapData )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MappedMatrixSetMapData_pre( precision, matrix, MapData );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MappedMatrixSetMatrix( HYPRE_MappedMatrix matrix, void *matrix_data )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MappedMatrixSetMatrix_pre( precision, matrix, matrix_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MultiblockMatrixAssemble( HYPRE_MultiblockMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MultiblockMatrixAssemble_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_MultiblockMatrix
HYPRE_MultiblockMatrixCreate( void )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MultiblockMatrixCreate_pre( precision );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MultiblockMatrixDestroy( HYPRE_MultiblockMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MultiblockMatrixDestroy_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MultiblockMatrixInitialize( HYPRE_MultiblockMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MultiblockMatrixInitialize_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MultiblockMatrixLimitedDestroy( HYPRE_MultiblockMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MultiblockMatrixLimitedDestroy_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

void
HYPRE_MultiblockMatrixPrint( HYPRE_MultiblockMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MultiblockMatrixPrint_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MultiblockMatrixSetNumSubmatrices( HYPRE_MultiblockMatrix matrix, HYPRE_Int n )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MultiblockMatrixSetNumSubmatrices_pre( precision, matrix, n );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MultiblockMatrixSetSubmatrixType( HYPRE_MultiblockMatrix matrix, HYPRE_Int j, HYPRE_Int type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_MultiblockMatrixSetSubmatrixType_pre( precision, matrix, j, type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_VectorCopy( HYPRE_Vector xvec, HYPRE_Vector yvec )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_VectorCopy_pre( precision, xvec, yvec );
}

/*--------------------------------------------------------------------------*/

HYPRE_Vector
HYPRE_VectorCreate( HYPRE_Int size )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_VectorCreate_pre( precision, size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_VectorDestroy( HYPRE_Vector vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_VectorDestroy_pre( precision, vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_VectorInitialize( HYPRE_Vector vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_VectorInitialize_pre( precision, vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_VectorPrint( HYPRE_Vector vector, char *file_name )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_VectorPrint_pre( precision, vector, file_name );
}

/*--------------------------------------------------------------------------*/

HYPRE_Vector
HYPRE_VectorRead( char *file_name )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_VectorRead_pre( precision, file_name );
}



#endif

