# The cpoco Multi-Platform Dynamic-Loading Library 

## Description

The primary goal of the cpoco project is to provide a C language
version of the poco multi-platform dynamic loading library. The
poco libraries are written in C++.

The secondary goal of cpoco is to support dynamic loading of
HDF5 filters by the [netCDF C library](https://www.unidata.ucar.edu/netcdf/).

# Mutual Exclusion Support

Internally, cpoco (like poco) supports serialized access to the dynamic
loading functions using mutual exclusion locks. For *nix* systems, this usually requires pthreads support.

In any case, it is possible to disable the use of mutual exclusion if you know
you are operating in a single threaded environment: see the [installation](#installation) section below.

# Implementation Restrictions

Currently support is provided for the following systems.

* libdl supporting operating systems: e.g. linux, os-x, cygwin.
* Windows-32 api

# Installation

## Automake

Automake-based configuration is provided using ./configure is provided for systems supporting autoconf/automake.

Use this command to see the available options.
```bash
./configure --help
```
The most important options are these.

* --disable-mutex -- disable using mutual exclusion (default is enabled)
* --disable-pthread -- disable using pthreads (default is enabled if operating system provides it)
* --enable-shared  -- build a shared library (default is enabled)
* --enable-static -- build a static library (default is enabled)
* --prefix=<installation directory> -- defaults to /usr/local

Note that is --enable-shared is disabled, then the test program
will not run because the test shared library (libcpt) cannot be built.

Use these commands to build, test, and install using autoconf.
```bash
# Invoke configure
./configure <options>
make all
# If testing is desired
make check
# Optional
make install
```
The <options> are those shown by `./configure --help`.

## CMake
Cmake-based configuration is provided provided for systems supporting it. If building for windows, then this is the only option provided.

Use these commands to build using cmake.
```bash
# Create a build directory
rm -fr build
mkdir build
cd build
# Invoke cmake
cmake <flags> ..
cmake --build .
# If testing is desired
CTEST_OUTPUT_ON_FAILURE=1 cmake --build . --target test
# Optional
cmake --build . --target install
```

The <flags> are these:

* -DENABLE_MUTEX -- use mutual exclusion (default is true)
* -DENABLE_PTHREAD -- use pthreads (if available) (default is true)
* -DCMAKE_INSTALL_PREFIX=<path> -- installation directory (defaults to /usr/local or c:/Program Files)

# Support

__Author__: Dennis Heimbigner  
__Organization__: University Corporation for Atmospheric Research  
__Initial Release__: 2015-9-28
__Last Modified__: 2018-03-27

__Copyright__: Copyright 2018, UCAR/Unidata; see COPYRIGHT file for copying and redistribution conditions. This code is Derived from the poco library (See [Poco Information](#poco-information) below).

# Change Log

1. (2016-09-28) Initial release.
2. (2018-03-27) Updated to make fix some automake problems.

# Poco Information

* Base poco version: 1.7.5 (2016-08-29)
* Poco web page: http://pocoproject.org


## Poco License

> Boost Software License - Version 1.0 - August 17th, 2003
> 
> Permission is hereby granted, free of charge, to any person or organization
> obtaining a copy of the software and accompanying documentation covered by
> this license (the "Software") to use, reproduce, display, distribute,
> execute, and transmit the Software, and to prepare derivative works of the
> Software, and to permit third-parties to whom the Software is furnished to
> do so, all subject to the following:
> 
> The copyright notices in the Software and this entire statement, including
> the above license grant, this restriction and the following disclaimer,
> must be included in all copies of the Software, in whole or in part, and
> all derivative works of the Software, unless such copies or derivative
> works are solely in the form of machine-executable object code generated by
> a source language processor.
> 
> THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
> IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
> FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
> SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
> FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
> ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
> DEALINGS IN THE SOFTWARE.
