# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.apimanagement import ApiManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApiManagementApiOperationOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApiManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_api_operation_list_by_api(self, resource_group):
        response = self.client.api_operation.list_by_api(
            resource_group_name=resource_group.name,
            service_name="str",
            api_id="str",
            api_version="2024-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_api_operation_get_entity_tag(self, resource_group):
        response = self.client.api_operation.get_entity_tag(
            resource_group_name=resource_group.name,
            service_name="str",
            api_id="str",
            operation_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_api_operation_get(self, resource_group):
        response = self.client.api_operation.get(
            resource_group_name=resource_group.name,
            service_name="str",
            api_id="str",
            operation_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_api_operation_create_or_update(self, resource_group):
        response = self.client.api_operation.create_or_update(
            resource_group_name=resource_group.name,
            service_name="str",
            api_id="str",
            operation_id="str",
            parameters={
                "description": "str",
                "displayName": "str",
                "id": "str",
                "method": "str",
                "name": "str",
                "policies": "str",
                "request": {
                    "description": "str",
                    "headers": [
                        {
                            "name": "str",
                            "type": "str",
                            "defaultValue": "str",
                            "description": "str",
                            "examples": {
                                "str": {"description": "str", "externalValue": "str", "summary": "str", "value": {}}
                            },
                            "required": bool,
                            "schemaId": "str",
                            "typeName": "str",
                            "values": ["str"],
                        }
                    ],
                    "queryParameters": [
                        {
                            "name": "str",
                            "type": "str",
                            "defaultValue": "str",
                            "description": "str",
                            "examples": {
                                "str": {"description": "str", "externalValue": "str", "summary": "str", "value": {}}
                            },
                            "required": bool,
                            "schemaId": "str",
                            "typeName": "str",
                            "values": ["str"],
                        }
                    ],
                    "representations": [
                        {
                            "contentType": "str",
                            "examples": {
                                "str": {"description": "str", "externalValue": "str", "summary": "str", "value": {}}
                            },
                            "formParameters": [
                                {
                                    "name": "str",
                                    "type": "str",
                                    "defaultValue": "str",
                                    "description": "str",
                                    "examples": {
                                        "str": {
                                            "description": "str",
                                            "externalValue": "str",
                                            "summary": "str",
                                            "value": {},
                                        }
                                    },
                                    "required": bool,
                                    "schemaId": "str",
                                    "typeName": "str",
                                    "values": ["str"],
                                }
                            ],
                            "schemaId": "str",
                            "typeName": "str",
                        }
                    ],
                },
                "responses": [
                    {
                        "statusCode": 0,
                        "description": "str",
                        "headers": [
                            {
                                "name": "str",
                                "type": "str",
                                "defaultValue": "str",
                                "description": "str",
                                "examples": {
                                    "str": {"description": "str", "externalValue": "str", "summary": "str", "value": {}}
                                },
                                "required": bool,
                                "schemaId": "str",
                                "typeName": "str",
                                "values": ["str"],
                            }
                        ],
                        "representations": [
                            {
                                "contentType": "str",
                                "examples": {
                                    "str": {"description": "str", "externalValue": "str", "summary": "str", "value": {}}
                                },
                                "formParameters": [
                                    {
                                        "name": "str",
                                        "type": "str",
                                        "defaultValue": "str",
                                        "description": "str",
                                        "examples": {
                                            "str": {
                                                "description": "str",
                                                "externalValue": "str",
                                                "summary": "str",
                                                "value": {},
                                            }
                                        },
                                        "required": bool,
                                        "schemaId": "str",
                                        "typeName": "str",
                                        "values": ["str"],
                                    }
                                ],
                                "schemaId": "str",
                                "typeName": "str",
                            }
                        ],
                    }
                ],
                "templateParameters": [
                    {
                        "name": "str",
                        "type": "str",
                        "defaultValue": "str",
                        "description": "str",
                        "examples": {
                            "str": {"description": "str", "externalValue": "str", "summary": "str", "value": {}}
                        },
                        "required": bool,
                        "schemaId": "str",
                        "typeName": "str",
                        "values": ["str"],
                    }
                ],
                "type": "str",
                "urlTemplate": "str",
            },
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_api_operation_update(self, resource_group):
        response = self.client.api_operation.update(
            resource_group_name=resource_group.name,
            service_name="str",
            api_id="str",
            operation_id="str",
            if_match="str",
            parameters={
                "description": "str",
                "displayName": "str",
                "method": "str",
                "policies": "str",
                "request": {
                    "description": "str",
                    "headers": [
                        {
                            "name": "str",
                            "type": "str",
                            "defaultValue": "str",
                            "description": "str",
                            "examples": {
                                "str": {"description": "str", "externalValue": "str", "summary": "str", "value": {}}
                            },
                            "required": bool,
                            "schemaId": "str",
                            "typeName": "str",
                            "values": ["str"],
                        }
                    ],
                    "queryParameters": [
                        {
                            "name": "str",
                            "type": "str",
                            "defaultValue": "str",
                            "description": "str",
                            "examples": {
                                "str": {"description": "str", "externalValue": "str", "summary": "str", "value": {}}
                            },
                            "required": bool,
                            "schemaId": "str",
                            "typeName": "str",
                            "values": ["str"],
                        }
                    ],
                    "representations": [
                        {
                            "contentType": "str",
                            "examples": {
                                "str": {"description": "str", "externalValue": "str", "summary": "str", "value": {}}
                            },
                            "formParameters": [
                                {
                                    "name": "str",
                                    "type": "str",
                                    "defaultValue": "str",
                                    "description": "str",
                                    "examples": {
                                        "str": {
                                            "description": "str",
                                            "externalValue": "str",
                                            "summary": "str",
                                            "value": {},
                                        }
                                    },
                                    "required": bool,
                                    "schemaId": "str",
                                    "typeName": "str",
                                    "values": ["str"],
                                }
                            ],
                            "schemaId": "str",
                            "typeName": "str",
                        }
                    ],
                },
                "responses": [
                    {
                        "statusCode": 0,
                        "description": "str",
                        "headers": [
                            {
                                "name": "str",
                                "type": "str",
                                "defaultValue": "str",
                                "description": "str",
                                "examples": {
                                    "str": {"description": "str", "externalValue": "str", "summary": "str", "value": {}}
                                },
                                "required": bool,
                                "schemaId": "str",
                                "typeName": "str",
                                "values": ["str"],
                            }
                        ],
                        "representations": [
                            {
                                "contentType": "str",
                                "examples": {
                                    "str": {"description": "str", "externalValue": "str", "summary": "str", "value": {}}
                                },
                                "formParameters": [
                                    {
                                        "name": "str",
                                        "type": "str",
                                        "defaultValue": "str",
                                        "description": "str",
                                        "examples": {
                                            "str": {
                                                "description": "str",
                                                "externalValue": "str",
                                                "summary": "str",
                                                "value": {},
                                            }
                                        },
                                        "required": bool,
                                        "schemaId": "str",
                                        "typeName": "str",
                                        "values": ["str"],
                                    }
                                ],
                                "schemaId": "str",
                                "typeName": "str",
                            }
                        ],
                    }
                ],
                "templateParameters": [
                    {
                        "name": "str",
                        "type": "str",
                        "defaultValue": "str",
                        "description": "str",
                        "examples": {
                            "str": {"description": "str", "externalValue": "str", "summary": "str", "value": {}}
                        },
                        "required": bool,
                        "schemaId": "str",
                        "typeName": "str",
                        "values": ["str"],
                    }
                ],
                "urlTemplate": "str",
            },
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_api_operation_delete(self, resource_group):
        response = self.client.api_operation.delete(
            resource_group_name=resource_group.name,
            service_name="str",
            api_id="str",
            operation_id="str",
            if_match="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...
