# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class AlertSeverity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Severity of an alert."""

    SEV0 = "Sev0"
    """Critical"""
    SEV1 = "Sev1"
    """Error"""
    SEV2 = "Sev2"
    """Warning"""
    SEV3 = "Sev3"
    """Informational"""
    SEV4 = "Sev4"
    """Verbose"""


class AuthenticationKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Supported kinds of authentication settings as discriminator."""

    MANAGED_IDENTITY = "ManagedIdentity"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class DependenciesAggregationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Aggregation type for child dependencies."""

    WORST_OF = "WorstOf"
    """Default behavior: Worst child health state is propagated."""
    THRESHOLDS = "Thresholds"
    """Based on configurable thresholds."""


class DiscoveryRuleRecommendedSignalsBehavior(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Discovery rule recommended signal behavior."""

    ENABLED = "Enabled"
    """Automatically add recommended signals"""
    DISABLED = "Disabled"
    """Do not automatically add recommended signals"""


class DiscoveryRuleRelationshipDiscoveryBehavior(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Discovery rule relationship discovery behavior."""

    ENABLED = "Enabled"
    """Automatically attempt to discover relationships"""
    DISABLED = "Disabled"
    """Do not automatically attempt to discover relationships"""


class DynamicThresholdDirection(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Threshold direction for dynamic thresholds."""

    LOWER_THAN = "LowerThan"
    """Lower than"""
    GREATER_THAN = "GreaterThan"
    """Greater than"""
    GREATER_OR_LOWER_THAN = "GreaterOrLowerThan"
    """Greater or Lower Than"""


class DynamicThresholdModel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ML-based model variants."""

    ANOMALY_DETECTION = "AnomalyDetection"
    """Anomaly detection model"""


class EntityImpact(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of impact an entity has on health state propagation."""

    STANDARD = "Standard"
    """Standard impact"""
    LIMITED = "Limited"
    """Limited impact"""
    SUPPRESSED = "Suppressed"
    """Suppressed impact"""


class HealthModelProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Health Model provisioning states."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    CREATING = "Creating"
    DELETING = "Deleting"


class HealthState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Health state of an entity."""

    HEALTHY = "Healthy"
    """Healthy status"""
    DEGRADED = "Degraded"
    """Degraded status"""
    ERROR = "Error"
    """Error status (Unhealthy)"""
    UNKNOWN = "Unknown"
    """Unknown status"""
    DELETED = "Deleted"
    """Deleted status"""


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    """No managed identity."""
    SYSTEM_ASSIGNED = "SystemAssigned"
    """System assigned managed identity."""
    USER_ASSIGNED = "UserAssigned"
    """User assigned managed identity."""
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"
    """System and user assigned managed identity."""


class MetricAggregationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Metric aggregation type."""

    NONE = "None"
    AVERAGE = "Average"
    COUNT = "Count"
    MINIMUM = "Minimum"
    MAXIMUM = "Maximum"
    TOTAL = "Total"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class RefreshInterval(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Refresh interval in ISO duration format."""

    PT1M = "PT1M"
    """One Minute"""
    PT5M = "PT5M"
    """Five Minutes"""
    PT10M = "PT10M"
    """Ten Minutes"""
    PT30M = "PT30M"
    """Thirty Minutes"""
    PT1H = "PT1H"
    """One Hour"""
    PT2H = "PT2H"
    """Two Hours"""


class SignalKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Supported signal kinds as discriminator."""

    AZURE_RESOURCE_METRIC = "AzureResourceMetric"
    LOG_ANALYTICS_QUERY = "LogAnalyticsQuery"
    PROMETHEUS_METRICS_QUERY = "PrometheusMetricsQuery"


class SignalOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Signal operator."""

    LOWER_THAN = "LowerThan"
    """Lower than"""
    LOWER_OR_EQUALS = "LowerOrEquals"
    """Lower than or equal to"""
    GREATER_THAN = "GreaterThan"
    """Greater than"""
    GREATER_OR_EQUALS = "GreaterOrEquals"
    """Greater than or equal to"""
    EQUALS = "Equals"
    """Equal to"""
