# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.servicefabric import ServiceFabricManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-servicefabric
# USAGE
    python cluster_put_operation_example_max.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ServiceFabricManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="00000000-0000-0000-0000-000000000000",
    )

    response = client.clusters.begin_create_or_update(
        resource_group_name="resRg",
        cluster_name="myCluster",
        parameters={
            "location": "eastus",
            "properties": {
                "addOnFeatures": ["RepairManager", "DnsService", "BackupRestoreService", "ResourceMonitorService"],
                "applicationTypeVersionsCleanupPolicy": {"maxUnusedVersionsToKeep": 2},
                "azureActiveDirectory": {
                    "clientApplication": "d151ad89-4bce-4ae8-b3d1-1dc79679fa75",
                    "clusterApplication": "5886372e-7bf4-4878-a497-8098aba608ae",
                    "tenantId": "6abcc6a0-8666-43f1-87b8-172cf86a9f9c",
                },
                "certificateCommonNames": {
                    "commonNames": [
                        {
                            "certificateCommonName": "abc.com",
                            "certificateIssuerThumbprint": "12599211F8F14C90AFA9532AD79A6F2CA1C00622",
                        }
                    ],
                    "x509StoreName": "My",
                },
                "clientCertificateCommonNames": [
                    {
                        "certificateCommonName": "abc.com",
                        "certificateIssuerThumbprint": "5F3660C715EBBDA31DB1FFDCF508302348DE8E7A",
                        "isAdmin": True,
                    }
                ],
                "clientCertificateThumbprints": [
                    {"certificateThumbprint": "5F3660C715EBBDA31DB1FFDCF508302348DE8E7A", "isAdmin": True}
                ],
                "clusterCodeVersion": "7.0.470.9590",
                "diagnosticsStorageAccountConfig": {
                    "blobEndpoint": "https://diag.blob.core.windows.net/",
                    "protectedAccountKeyName": "StorageAccountKey1",
                    "queueEndpoint": "https://diag.queue.core.windows.net/",
                    "storageAccountName": "diag",
                    "tableEndpoint": "https://diag.table.core.windows.net/",
                },
                "enableHttpGatewayExclusiveAuthMode": True,
                "eventStoreServiceEnabled": True,
                "fabricSettings": [
                    {"name": "UpgradeService", "parameters": [{"name": "AppPollIntervalInSeconds", "value": "60"}]}
                ],
                "infrastructureServiceManager": True,
                "managementEndpoint": "https://myCluster.eastus.cloudapp.azure.com:19080",
                "nodeTypes": [
                    {
                        "applicationPorts": {"endPort": 30000, "startPort": 20000},
                        "clientConnectionEndpointPort": 19000,
                        "durabilityLevel": "Silver",
                        "ephemeralPorts": {"endPort": 64000, "startPort": 49000},
                        "httpGatewayEndpointPort": 19007,
                        "httpGatewayTokenAuthEndpointPort": 19081,
                        "isPrimary": True,
                        "isStateless": False,
                        "multipleAvailabilityZones": True,
                        "name": "nt1vm",
                        "vmInstanceCount": 5,
                    }
                ],
                "notifications": [
                    {
                        "isEnabled": True,
                        "notificationCategory": "WaveProgress",
                        "notificationLevel": "Critical",
                        "notificationTargets": [
                            {
                                "notificationChannel": "EmailUser",
                                "receivers": ["****@microsoft.com", "****@microsoft.com"],
                            },
                            {"notificationChannel": "EmailSubscription", "receivers": ["Owner", "AccountAdmin"]},
                        ],
                    },
                    {
                        "isEnabled": True,
                        "notificationCategory": "WaveProgress",
                        "notificationLevel": "All",
                        "notificationTargets": [
                            {
                                "notificationChannel": "EmailUser",
                                "receivers": ["****@microsoft.com", "****@microsoft.com"],
                            },
                            {"notificationChannel": "EmailSubscription", "receivers": ["Owner", "AccountAdmin"]},
                        ],
                    },
                ],
                "reliabilityLevel": "Platinum",
                "reverseProxyCertificateCommonNames": {
                    "commonNames": [
                        {
                            "certificateCommonName": "abc.com",
                            "certificateIssuerThumbprint": "12599211F8F14C90AFA9532AD79A6F2CA1C00622",
                        }
                    ],
                    "x509StoreName": "My",
                },
                "sfZonalUpgradeMode": "Hierarchical",
                "upgradeDescription": {
                    "deltaHealthPolicy": {
                        "applicationDeltaHealthPolicies": {
                            "fabric:/myApp1": {
                                "defaultServiceTypeDeltaHealthPolicy": {"maxPercentDeltaUnhealthyServices": 0},
                                "serviceTypeDeltaHealthPolicies": {
                                    "myServiceType1": {"maxPercentDeltaUnhealthyServices": 0}
                                },
                            }
                        },
                        "maxPercentDeltaUnhealthyApplications": 0,
                        "maxPercentDeltaUnhealthyNodes": 0,
                        "maxPercentUpgradeDomainDeltaUnhealthyNodes": 0,
                    },
                    "forceRestart": False,
                    "healthCheckRetryTimeout": "00:05:00",
                    "healthCheckStableDuration": "00:00:30",
                    "healthCheckWaitDuration": "00:00:30",
                    "healthPolicy": {
                        "applicationHealthPolicies": {
                            "fabric:/myApp1": {
                                "defaultServiceTypeHealthPolicy": {"maxPercentUnhealthyServices": 0},
                                "serviceTypeHealthPolicies": {"myServiceType1": {"maxPercentUnhealthyServices": 100}},
                            }
                        },
                        "maxPercentUnhealthyApplications": 0,
                        "maxPercentUnhealthyNodes": 0,
                    },
                    "upgradeDomainTimeout": "00:15:00",
                    "upgradeReplicaSetCheckTimeout": "00:10:00",
                    "upgradeTimeout": "01:00:00",
                },
                "upgradeMode": "Manual",
                "upgradePauseEndTimestampUtc": "2021-06-25T22:00:00Z",
                "upgradePauseStartTimestampUtc": "2021-06-21T22:00:00Z",
                "upgradeWave": "Wave1",
                "vmImage": "Windows",
                "vmssZonalUpgradeMode": "Parallel",
            },
            "tags": {},
        },
    ).result()
    print(response)


# x-ms-original-file: specification/servicefabric/resource-manager/Microsoft.ServiceFabric/preview/2023-11-01-preview/examples/ClusterPutOperation_example_max.json
if __name__ == "__main__":
    main()
