# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_discriminator, rest_field
from ._enums import SCType

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Resource(_model_base.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerorchestratorruntime.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long"""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ExtensionResource(Resource):
    """The base extension resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerorchestratorruntime.models.SystemData
    """


class BgpPeer(ExtensionResource):
    """A BgpPeer resource for an Arc connected cluster (Microsoft.Kubernetes/connectedClusters).

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerorchestratorruntime.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.containerorchestratorruntime.models.BgpPeerProperties
    """

    properties: Optional["_models.BgpPeerProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.BgpPeerProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class BgpPeerProperties(_model_base.Model):
    """Details of the BgpPeer.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar my_asn: My ASN. Required.
    :vartype my_asn: int
    :ivar peer_asn: Peer ASN. Required.
    :vartype peer_asn: int
    :ivar peer_address: Peer Address. Required.
    :vartype peer_address: str
    :ivar provisioning_state: Resource provision state. Known values are: "Succeeded", "Failed",
     "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerorchestratorruntime.models.ProvisioningState
    """

    my_asn: int = rest_field(name="myAsn")
    """My ASN. Required."""
    peer_asn: int = rest_field(name="peerAsn")
    """Peer ASN. Required."""
    peer_address: str = rest_field(name="peerAddress")
    """Peer Address. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Resource provision state. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Provisioning\", \"Updating\", \"Deleting\", and \"Accepted\"."""

    @overload
    def __init__(
        self,
        *,
        my_asn: int,
        peer_asn: int,
        peer_address: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class StorageClassTypeProperties(_model_base.Model):
    """The properties of storage class of the StorageClass.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    BlobStorageClassTypeProperties, NfsStorageClassTypeProperties,
    NativeStorageClassTypeProperties, RwxStorageClassTypeProperties, SmbStorageClassTypeProperties


    :ivar type: Type of the storage class. Required. Known values are: "Native", "RWX", "Blob",
     "NFS", and "SMB".
    :vartype type: str or ~azure.mgmt.containerorchestratorruntime.models.SCType
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    type: str = rest_discriminator(name="type")
    """Type of the storage class. Required. Known values are: \"Native\", \"RWX\", \"Blob\", \"NFS\",
     and \"SMB\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class BlobStorageClassTypeProperties(StorageClassTypeProperties, discriminator="Blob"):
    """The properties of Blob StorageClass.


    :ivar type: Blob StorageClass. Required. Blob storage class
    :vartype type: str or ~azure.mgmt.containerorchestratorruntime.models.BLOB
    :ivar azure_storage_account_name: Azure Storage Account Name. Required.
    :vartype azure_storage_account_name: str
    :ivar azure_storage_account_key: Azure Storage Account Key. Required.
    :vartype azure_storage_account_key: str
    """

    type: Literal[SCType.BLOB] = rest_discriminator(name="type")  # type: ignore
    """Blob StorageClass. Required. Blob storage class"""
    azure_storage_account_name: str = rest_field(name="azureStorageAccountName")
    """Azure Storage Account Name. Required."""
    azure_storage_account_key: str = rest_field(name="azureStorageAccountKey")
    """Azure Storage Account Key. Required."""

    @overload
    def __init__(
        self,
        *,
        azure_storage_account_name: str,
        azure_storage_account_key: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, type=SCType.BLOB, **kwargs)


class ErrorAdditionalInfo(_model_base.Model):
    """The resource management error additional info.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_model_base.Model):
    """The error detail.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.containerorchestratorruntime.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.containerorchestratorruntime.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_model_base.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.containerorchestratorruntime.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field()
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class LoadBalancer(ExtensionResource):
    """A LoadBalancer resource for an Arc connected cluster (Microsoft.Kubernetes/connectedClusters).

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerorchestratorruntime.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.containerorchestratorruntime.models.LoadBalancerProperties
    """

    properties: Optional["_models.LoadBalancerProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.LoadBalancerProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class LoadBalancerProperties(_model_base.Model):
    """Details of the LoadBalancer.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar addresses: IP Range. Required.
    :vartype addresses: list[str]
    :ivar service_selector: A dynamic label mapping to select related services. For instance, if
     you want to create a load balancer only for services with label "a=b", then please specify
     {"a": "b"} in the field.
    :vartype service_selector: dict[str, str]
    :ivar advertise_mode: Advertise Mode. Required. Known values are: "ARP", "BGP", and "Both".
    :vartype advertise_mode: str or ~azure.mgmt.containerorchestratorruntime.models.AdvertiseMode
    :ivar bgp_peers: The list of BGP peers it should advertise to. Null or empty means to advertise
     to all peers.
    :vartype bgp_peers: list[str]
    :ivar provisioning_state: Resource provision state. Known values are: "Succeeded", "Failed",
     "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerorchestratorruntime.models.ProvisioningState
    """

    addresses: List[str] = rest_field()
    """IP Range. Required."""
    service_selector: Optional[Dict[str, str]] = rest_field(name="serviceSelector")
    """A dynamic label mapping to select related services. For instance, if you want to create a load
     balancer only for services with label \"a=b\", then please specify {\"a\": \"b\"} in the field."""
    advertise_mode: Union[str, "_models.AdvertiseMode"] = rest_field(name="advertiseMode")
    """Advertise Mode. Required. Known values are: \"ARP\", \"BGP\", and \"Both\"."""
    bgp_peers: Optional[List[str]] = rest_field(name="bgpPeers")
    """The list of BGP peers it should advertise to. Null or empty means to advertise to all peers."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Resource provision state. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Provisioning\", \"Updating\", \"Deleting\", and \"Accepted\"."""

    @overload
    def __init__(
        self,
        *,
        addresses: List[str],
        advertise_mode: Union[str, "_models.AdvertiseMode"],
        service_selector: Optional[Dict[str, str]] = None,
        bgp_peers: Optional[List[str]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class NativeStorageClassTypeProperties(StorageClassTypeProperties, discriminator="Native"):
    """The properties of Native StorageClass.


    :ivar type: Native StorageClass. Required. Native storage class
    :vartype type: str or ~azure.mgmt.containerorchestratorruntime.models.NATIVE
    """

    type: Literal[SCType.NATIVE] = rest_discriminator(name="type")  # type: ignore
    """Native StorageClass. Required. Native storage class"""

    @overload
    def __init__(
        self,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, type=SCType.NATIVE, **kwargs)


class NfsStorageClassTypeProperties(StorageClassTypeProperties, discriminator="NFS"):
    """The properties of NFS StorageClass.


    :ivar type: NFS StorageClass. Required. NFS storage class
    :vartype type: str or ~azure.mgmt.containerorchestratorruntime.models.NFS
    :ivar server: NFS Server. Required.
    :vartype server: str
    :ivar share: NFS share. Required.
    :vartype share: str
    :ivar sub_dir: Sub directory under share. If the sub directory doesn't exist, driver will
     create it.
    :vartype sub_dir: str
    :ivar mount_permissions: Mounted folder permissions. Default is 0. If set as non-zero, driver
     will perform ``chmod`` after mount.
    :vartype mount_permissions: str
    :ivar on_delete: The action to take when a NFS volume is deleted. Default is Delete. Known
     values are: "Delete" and "Retain".
    :vartype on_delete: str or
     ~azure.mgmt.containerorchestratorruntime.models.NfsDirectoryActionOnVolumeDeletion
    """

    type: Literal[SCType.NFS] = rest_discriminator(name="type")  # type: ignore
    """NFS StorageClass. Required. NFS storage class"""
    server: str = rest_field()
    """NFS Server. Required."""
    share: str = rest_field()
    """NFS share. Required."""
    sub_dir: Optional[str] = rest_field(name="subDir")
    """Sub directory under share. If the sub directory doesn't exist, driver will create it."""
    mount_permissions: Optional[str] = rest_field(name="mountPermissions")
    """Mounted folder permissions. Default is 0. If set as non-zero, driver will perform ``chmod``
     after mount."""
    on_delete: Optional[Union[str, "_models.NfsDirectoryActionOnVolumeDeletion"]] = rest_field(name="onDelete")
    """The action to take when a NFS volume is deleted. Default is Delete. Known values are:
     \"Delete\" and \"Retain\"."""

    @overload
    def __init__(
        self,
        *,
        server: str,
        share: str,
        sub_dir: Optional[str] = None,
        mount_permissions: Optional[str] = None,
        on_delete: Optional[Union[str, "_models.NfsDirectoryActionOnVolumeDeletion"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, type=SCType.NFS, **kwargs)


class Operation(_model_base.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.containerorchestratorruntime.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.containerorchestratorruntime.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.containerorchestratorruntime.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(visibility=["read"])
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType")
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        action_type: Optional[Union[str, "_models.ActionType"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class OperationDisplay(_model_base.Model):
    """Localized display information for and operation.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class RwxStorageClassTypeProperties(StorageClassTypeProperties, discriminator="RWX"):
    """The properties of RWX StorageClass.


    :ivar type: RWX StorageClass. Required. RWX storage class
    :vartype type: str or ~azure.mgmt.containerorchestratorruntime.models.RWX
    :ivar backing_storage_class_name: The backing storageclass used to create new storageclass.
     Required.
    :vartype backing_storage_class_name: str
    """

    type: Literal[SCType.RWX] = rest_discriminator(name="type")  # type: ignore
    """RWX StorageClass. Required. RWX storage class"""
    backing_storage_class_name: str = rest_field(name="backingStorageClassName")
    """The backing storageclass used to create new storageclass. Required."""

    @overload
    def __init__(
        self,
        *,
        backing_storage_class_name: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, type=SCType.RWX, **kwargs)


class ServiceProperties(_model_base.Model):
    """Properties for the service resource.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar rp_object_id: The object id of the service principal of the RP provisioned in the tenant.
    :vartype rp_object_id: str
    :ivar provisioning_state: Resource provision state. Known values are: "Succeeded", "Failed",
     "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerorchestratorruntime.models.ProvisioningState
    """

    rp_object_id: Optional[str] = rest_field(name="rpObjectId", visibility=["read"])
    """The object id of the service principal of the RP provisioned in the tenant."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Resource provision state. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Provisioning\", \"Updating\", \"Deleting\", and \"Accepted\"."""


class ServiceResource(ExtensionResource):
    """A Service resource for an Arc connected cluster (Microsoft.Kubernetes/connectedClusters).

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerorchestratorruntime.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.containerorchestratorruntime.models.ServiceProperties
    """

    properties: Optional["_models.ServiceProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ServiceProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SmbStorageClassTypeProperties(StorageClassTypeProperties, discriminator="SMB"):
    """The properties of SMB StorageClass.


    :ivar type: SMB StorageClass. Required. SMB storage class
    :vartype type: str or ~azure.mgmt.containerorchestratorruntime.models.SMB
    :ivar source: SMB Source. Required.
    :vartype source: str
    :ivar sub_dir: Sub directory under share. If the sub directory doesn't exist, driver will
     create it.
    :vartype sub_dir: str
    :ivar username: Server username.
    :vartype username: str
    :ivar password: Server password.
    :vartype password: str
    :ivar domain: Server domain.
    :vartype domain: str
    """

    type: Literal[SCType.SMB] = rest_discriminator(name="type")  # type: ignore
    """SMB StorageClass. Required. SMB storage class"""
    source: str = rest_field()
    """SMB Source. Required."""
    sub_dir: Optional[str] = rest_field(name="subDir")
    """Sub directory under share. If the sub directory doesn't exist, driver will create it."""
    username: Optional[str] = rest_field()
    """Server username."""
    password: Optional[str] = rest_field()
    """Server password."""
    domain: Optional[str] = rest_field()
    """Server domain."""

    @overload
    def __init__(
        self,
        *,
        source: str,
        sub_dir: Optional[str] = None,
        username: Optional[str] = None,
        password: Optional[str] = None,
        domain: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, type=SCType.SMB, **kwargs)


class StorageClassProperties(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """Details of the StorageClass StorageClass.

    Readonly variables are only populated by the server, and will be ignored when sending a request.


    :ivar allow_volume_expansion: Volume can be expanded or not. Known values are: "Allow" and
     "Disallow".
    :vartype allow_volume_expansion: str or
     ~azure.mgmt.containerorchestratorruntime.models.VolumeExpansion
    :ivar mount_options: Additional mount options.
    :vartype mount_options: list[str]
    :ivar provisioner: Provisioner name.
    :vartype provisioner: str
    :ivar volume_binding_mode: Binding mode of volumes: Immediate, WaitForFirstConsumer. Known
     values are: "Immediate" and "WaitForFirstConsumer".
    :vartype volume_binding_mode: str or
     ~azure.mgmt.containerorchestratorruntime.models.VolumeBindingMode
    :ivar access_modes: The access mode: [ReadWriteOnce, ReadWriteMany] or [ReadWriteOnce].
    :vartype access_modes: list[str or ~azure.mgmt.containerorchestratorruntime.models.AccessMode]
    :ivar data_resilience: Allow single data node failure. Known values are: "NotDataResilient" and
     "DataResilient".
    :vartype data_resilience: str or
     ~azure.mgmt.containerorchestratorruntime.models.DataResilienceTier
    :ivar failover_speed: Failover speed: NA, Slow, Fast. Known values are: "NotAvailable", "Slow",
     "Fast", and "Super".
    :vartype failover_speed: str or ~azure.mgmt.containerorchestratorruntime.models.FailoverTier
    :ivar limitations: Limitations of the storage class.
    :vartype limitations: list[str]
    :ivar performance: Performance tier. Known values are: "Undefined", "Basic", "Standard",
     "Premium", and "Ultra".
    :vartype performance: str or ~azure.mgmt.containerorchestratorruntime.models.PerformanceTier
    :ivar priority: Selection priority when multiple storage classes meet the criteria. 0: Highest,
     -1: Never use.
    :vartype priority: int
    :ivar type_properties: Properties of the StorageClass. Required.
    :vartype type_properties:
     ~azure.mgmt.containerorchestratorruntime.models.StorageClassTypeProperties
    :ivar provisioning_state: Resource provision state. Known values are: "Succeeded", "Failed",
     "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerorchestratorruntime.models.ProvisioningState
    """

    allow_volume_expansion: Optional[Union[str, "_models.VolumeExpansion"]] = rest_field(name="allowVolumeExpansion")
    """Volume can be expanded or not. Known values are: \"Allow\" and \"Disallow\"."""
    mount_options: Optional[List[str]] = rest_field(name="mountOptions")
    """Additional mount options."""
    provisioner: Optional[str] = rest_field(visibility=["read", "create"])
    """Provisioner name."""
    volume_binding_mode: Optional[Union[str, "_models.VolumeBindingMode"]] = rest_field(
        name="volumeBindingMode", visibility=["read", "create"]
    )
    """Binding mode of volumes: Immediate, WaitForFirstConsumer. Known values are: \"Immediate\" and
     \"WaitForFirstConsumer\"."""
    access_modes: Optional[List[Union[str, "_models.AccessMode"]]] = rest_field(name="accessModes")
    """The access mode: [ReadWriteOnce, ReadWriteMany] or [ReadWriteOnce]."""
    data_resilience: Optional[Union[str, "_models.DataResilienceTier"]] = rest_field(name="dataResilience")
    """Allow single data node failure. Known values are: \"NotDataResilient\" and \"DataResilient\"."""
    failover_speed: Optional[Union[str, "_models.FailoverTier"]] = rest_field(name="failoverSpeed")
    """Failover speed: NA, Slow, Fast. Known values are: \"NotAvailable\", \"Slow\", \"Fast\", and
     \"Super\"."""
    limitations: Optional[List[str]] = rest_field()
    """Limitations of the storage class."""
    performance: Optional[Union[str, "_models.PerformanceTier"]] = rest_field()
    """Performance tier. Known values are: \"Undefined\", \"Basic\", \"Standard\", \"Premium\", and
     \"Ultra\"."""
    priority: Optional[int] = rest_field()
    """Selection priority when multiple storage classes meet the criteria. 0: Highest, -1: Never use."""
    type_properties: "_models.StorageClassTypeProperties" = rest_field(
        name="typeProperties", visibility=["read", "create"]
    )
    """Properties of the StorageClass. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Resource provision state. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Provisioning\", \"Updating\", \"Deleting\", and \"Accepted\"."""

    @overload
    def __init__(
        self,
        *,
        type_properties: "_models.StorageClassTypeProperties",
        allow_volume_expansion: Optional[Union[str, "_models.VolumeExpansion"]] = None,
        mount_options: Optional[List[str]] = None,
        provisioner: Optional[str] = None,
        volume_binding_mode: Optional[Union[str, "_models.VolumeBindingMode"]] = None,
        access_modes: Optional[List[Union[str, "_models.AccessMode"]]] = None,
        data_resilience: Optional[Union[str, "_models.DataResilienceTier"]] = None,
        failover_speed: Optional[Union[str, "_models.FailoverTier"]] = None,
        limitations: Optional[List[str]] = None,
        performance: Optional[Union[str, "_models.PerformanceTier"]] = None,
        priority: Optional[int] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class StorageClassPropertiesUpdate(_model_base.Model):
    """The model for updating storageClass properties.

    :ivar allow_volume_expansion: Volume can be expanded or not. Known values are: "Allow" and
     "Disallow".
    :vartype allow_volume_expansion: str or
     ~azure.mgmt.containerorchestratorruntime.models.VolumeExpansion
    :ivar mount_options: Additional mount options.
    :vartype mount_options: list[str]
    :ivar access_modes: The access mode: [ReadWriteOnce, ReadWriteMany] or [ReadWriteOnce].
    :vartype access_modes: list[str or ~azure.mgmt.containerorchestratorruntime.models.AccessMode]
    :ivar data_resilience: Allow single data node failure. Known values are: "NotDataResilient" and
     "DataResilient".
    :vartype data_resilience: str or
     ~azure.mgmt.containerorchestratorruntime.models.DataResilienceTier
    :ivar failover_speed: Failover speed: NA, Slow, Fast. Known values are: "NotAvailable", "Slow",
     "Fast", and "Super".
    :vartype failover_speed: str or ~azure.mgmt.containerorchestratorruntime.models.FailoverTier
    :ivar limitations: Limitations of the storage class.
    :vartype limitations: list[str]
    :ivar performance: Performance tier. Known values are: "Undefined", "Basic", "Standard",
     "Premium", and "Ultra".
    :vartype performance: str or ~azure.mgmt.containerorchestratorruntime.models.PerformanceTier
    :ivar priority: Selection priority when multiple storage classes meet the criteria. 0: Highest,
     -1: Never use.
    :vartype priority: int
    :ivar type_properties: New storage class type of storageClass.
    :vartype type_properties:
     ~azure.mgmt.containerorchestratorruntime.models.StorageClassTypePropertiesUpdate
    """

    allow_volume_expansion: Optional[Union[str, "_models.VolumeExpansion"]] = rest_field(name="allowVolumeExpansion")
    """Volume can be expanded or not. Known values are: \"Allow\" and \"Disallow\"."""
    mount_options: Optional[List[str]] = rest_field(name="mountOptions")
    """Additional mount options."""
    access_modes: Optional[List[Union[str, "_models.AccessMode"]]] = rest_field(name="accessModes")
    """The access mode: [ReadWriteOnce, ReadWriteMany] or [ReadWriteOnce]."""
    data_resilience: Optional[Union[str, "_models.DataResilienceTier"]] = rest_field(name="dataResilience")
    """Allow single data node failure. Known values are: \"NotDataResilient\" and \"DataResilient\"."""
    failover_speed: Optional[Union[str, "_models.FailoverTier"]] = rest_field(name="failoverSpeed")
    """Failover speed: NA, Slow, Fast. Known values are: \"NotAvailable\", \"Slow\", \"Fast\", and
     \"Super\"."""
    limitations: Optional[List[str]] = rest_field()
    """Limitations of the storage class."""
    performance: Optional[Union[str, "_models.PerformanceTier"]] = rest_field()
    """Performance tier. Known values are: \"Undefined\", \"Basic\", \"Standard\", \"Premium\", and
     \"Ultra\"."""
    priority: Optional[int] = rest_field()
    """Selection priority when multiple storage classes meet the criteria. 0: Highest, -1: Never use."""
    type_properties: Optional["_models.StorageClassTypePropertiesUpdate"] = rest_field(name="typeProperties")
    """New storage class type of storageClass."""

    @overload
    def __init__(
        self,
        *,
        allow_volume_expansion: Optional[Union[str, "_models.VolumeExpansion"]] = None,
        mount_options: Optional[List[str]] = None,
        access_modes: Optional[List[Union[str, "_models.AccessMode"]]] = None,
        data_resilience: Optional[Union[str, "_models.DataResilienceTier"]] = None,
        failover_speed: Optional[Union[str, "_models.FailoverTier"]] = None,
        limitations: Optional[List[str]] = None,
        performance: Optional[Union[str, "_models.PerformanceTier"]] = None,
        priority: Optional[int] = None,
        type_properties: Optional["_models.StorageClassTypePropertiesUpdate"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class StorageClassResource(ExtensionResource):
    """A StorageClass resource for an Arc connected cluster (Microsoft.Kubernetes/connectedClusters).

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerorchestratorruntime.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.containerorchestratorruntime.models.StorageClassProperties
    """

    properties: Optional["_models.StorageClassProperties"] = rest_field()
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.StorageClassProperties"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class StorageClassResourceUpdate(_model_base.Model):
    """The model for updating a storageClass.

    :ivar properties: The properties of StorageClass.
    :vartype properties:
     ~azure.mgmt.containerorchestratorruntime.models.StorageClassPropertiesUpdate
    """

    properties: Optional["_models.StorageClassPropertiesUpdate"] = rest_field()
    """The properties of StorageClass."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.StorageClassPropertiesUpdate"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class StorageClassTypePropertiesUpdate(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """The model for update a storageClass.

    :ivar backing_storage_class_name: The backing storageclass used to create new storageclass.
    :vartype backing_storage_class_name: str
    :ivar azure_storage_account_name: Azure Storage Account Name.
    :vartype azure_storage_account_name: str
    :ivar azure_storage_account_key: Azure Storage Account Key.
    :vartype azure_storage_account_key: str
    :ivar server: NFS Server.
    :vartype server: str
    :ivar share: NFS share.
    :vartype share: str
    :ivar sub_dir: Sub directory under share. If the sub directory doesn't exist, driver will
     create it.
    :vartype sub_dir: str
    :ivar mount_permissions: Mounted folder permissions. Default is 0. If set as non-zero, driver
     will perform ``chmod`` after mount.
    :vartype mount_permissions: str
    :ivar on_delete: The action to take when a NFS volume is deleted. Default is Delete. Known
     values are: "Delete" and "Retain".
    :vartype on_delete: str or
     ~azure.mgmt.containerorchestratorruntime.models.NfsDirectoryActionOnVolumeDeletion
    :ivar source: SMB Source.
    :vartype source: str
    :ivar username: Server username.
    :vartype username: str
    :ivar password: Server password.
    :vartype password: str
    :ivar domain: Server domain.
    :vartype domain: str
    """

    backing_storage_class_name: Optional[str] = rest_field(name="backingStorageClassName")
    """The backing storageclass used to create new storageclass."""
    azure_storage_account_name: Optional[str] = rest_field(name="azureStorageAccountName")
    """Azure Storage Account Name."""
    azure_storage_account_key: Optional[str] = rest_field(name="azureStorageAccountKey")
    """Azure Storage Account Key."""
    server: Optional[str] = rest_field()
    """NFS Server."""
    share: Optional[str] = rest_field()
    """NFS share."""
    sub_dir: Optional[str] = rest_field(name="subDir")
    """Sub directory under share. If the sub directory doesn't exist, driver will create it."""
    mount_permissions: Optional[str] = rest_field(name="mountPermissions")
    """Mounted folder permissions. Default is 0. If set as non-zero, driver will perform ``chmod``
     after mount."""
    on_delete: Optional[Union[str, "_models.NfsDirectoryActionOnVolumeDeletion"]] = rest_field(name="onDelete")
    """The action to take when a NFS volume is deleted. Default is Delete. Known values are:
     \"Delete\" and \"Retain\"."""
    source: Optional[str] = rest_field()
    """SMB Source."""
    username: Optional[str] = rest_field()
    """Server username."""
    password: Optional[str] = rest_field()
    """Server password."""
    domain: Optional[str] = rest_field()
    """Server domain."""

    @overload
    def __init__(
        self,
        *,
        backing_storage_class_name: Optional[str] = None,
        azure_storage_account_name: Optional[str] = None,
        azure_storage_account_key: Optional[str] = None,
        server: Optional[str] = None,
        share: Optional[str] = None,
        sub_dir: Optional[str] = None,
        mount_permissions: Optional[str] = None,
        on_delete: Optional[Union[str, "_models.NfsDirectoryActionOnVolumeDeletion"]] = None,
        source: Optional[str] = None,
        username: Optional[str] = None,
        password: Optional[str] = None,
        domain: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class SystemData(_model_base.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.containerorchestratorruntime.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.containerorchestratorruntime.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy")
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(name="createdByType")
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(name="createdAt", format="rfc3339")
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(name="lastModifiedBy")
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(name="lastModifiedByType")
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(name="lastModifiedAt", format="rfc3339")
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)
