# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.sql import SqlManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSqlManagementReplicationLinksOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SqlManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_links_list_by_database(self, resource_group):
        response = self.client.replication_links.list_by_database(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            api_version="2023-05-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_links_get(self, resource_group):
        response = self.client.replication_links.get(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            link_id="str",
            api_version="2023-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_links_begin_create_or_update(self, resource_group):
        response = self.client.replication_links.begin_create_or_update(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            link_id="str",
            parameters={
                "id": "str",
                "isTerminationAllowed": bool,
                "linkType": "str",
                "name": "str",
                "partnerDatabase": "str",
                "partnerDatabaseId": "str",
                "partnerLocation": "str",
                "partnerRole": "str",
                "partnerServer": "str",
                "percentComplete": 0,
                "replicationMode": "str",
                "replicationState": "str",
                "role": "str",
                "startTime": "2020-02-20 00:00:00",
                "type": "str",
            },
            api_version="2023-05-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_links_begin_delete(self, resource_group):
        response = self.client.replication_links.begin_delete(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            link_id="str",
            api_version="2023-05-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_links_begin_update(self, resource_group):
        response = self.client.replication_links.begin_update(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            link_id="str",
            parameters={"id": "str", "linkType": "str", "name": "str", "type": "str"},
            api_version="2023-05-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_links_begin_failover(self, resource_group):
        response = self.client.replication_links.begin_failover(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            link_id="str",
            api_version="2023-05-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_links_begin_failover_allow_data_loss(self, resource_group):
        response = self.client.replication_links.begin_failover_allow_data_loss(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            link_id="str",
            api_version="2023-05-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_links_list_by_server(self, resource_group):
        response = self.client.replication_links.list_by_server(
            resource_group_name=resource_group.name,
            server_name="str",
            api_version="2023-05-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
