# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
import json
from typing import Any, AsyncIterator, Callable, IO, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core import AsyncPipelineClient, MatchConditions
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceModifiedError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._utils.model_base import SdkJSONEncoder, _deserialize, _failsafe_deserialize
from ..._utils.serialization import Deserializer, Serializer
from ...operations._operations import (
    build_application_create_request,
    build_application_delete_request,
    build_application_get_request,
    build_application_list_request,
    build_application_package_activate_request,
    build_application_package_create_request,
    build_application_package_delete_request,
    build_application_package_get_request,
    build_application_package_list_request,
    build_application_update_request,
    build_batch_account_create_request,
    build_batch_account_delete_request,
    build_batch_account_get_detector_request,
    build_batch_account_get_keys_request,
    build_batch_account_get_request,
    build_batch_account_list_by_resource_group_request,
    build_batch_account_list_detectors_request,
    build_batch_account_list_outbound_network_dependencies_endpoints_request,
    build_batch_account_list_request,
    build_batch_account_regenerate_key_request,
    build_batch_account_synchronize_auto_storage_keys_request,
    build_batch_account_update_request,
    build_location_check_name_availability_request,
    build_location_get_quotas_request,
    build_location_list_supported_virtual_machine_skus_request,
    build_network_security_perimeter_get_configuration_request,
    build_network_security_perimeter_list_configurations_request,
    build_network_security_perimeter_reconcile_configuration_request,
    build_operations_list_request,
    build_pool_create_request,
    build_pool_delete_request,
    build_pool_disable_auto_scale_request,
    build_pool_get_request,
    build_pool_list_by_batch_account_request,
    build_pool_stop_resize_request,
    build_pool_update_request,
    build_private_endpoint_connection_delete_request,
    build_private_endpoint_connection_get_request,
    build_private_endpoint_connection_list_by_batch_account_request,
    build_private_endpoint_connection_update_request,
    build_private_link_resource_get_request,
    build_private_link_resource_list_by_batch_account_request,
)
from .._configuration import BatchManagementClientConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, dict[str, Any]], Any]]
JSON = MutableMapping[str, Any]
List = list


class Operations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.batch.aio.BatchManagementClient`'s
        :attr:`operations` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: BatchManagementClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(self, **kwargs: Any) -> AsyncItemPaged["_models.Operation"]:
        """Lists available operations for the Microsoft.Batch provider.

        :return: An iterator like instance of Operation
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.batch.models.Operation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.Operation]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_operations_list_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.Operation], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.CloudError,
                    response,
                )
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class BatchAccountOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.batch.aio.BatchManagementClient`'s
        :attr:`batch_account` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: BatchManagementClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(self, resource_group_name: str, account_name: str, **kwargs: Any) -> _models.BatchAccount:
        """Gets information about the specified Batch account.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :return: BatchAccount. The BatchAccount is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.BatchAccount
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.BatchAccount] = kwargs.pop("cls", None)

        _request = build_batch_account_get_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.BatchAccount, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_initial(
        self,
        resource_group_name: str,
        account_name: str,
        parameters: Union[_models.BatchAccountCreateParameters, JSON, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _content = json.dumps(parameters, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_account_create_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create(
        self,
        resource_group_name: str,
        account_name: str,
        parameters: _models.BatchAccountCreateParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.BatchAccount]:
        """Creates a new Batch account with the specified parameters. Existing accounts cannot be updated
        with this API and should instead be updated with the Update Batch Account API.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param parameters: Additional parameters for account creation. Required.
        :type parameters: ~azure.mgmt.batch.models.BatchAccountCreateParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns BatchAccount. The BatchAccount is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.batch.models.BatchAccount]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create(
        self,
        resource_group_name: str,
        account_name: str,
        parameters: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.BatchAccount]:
        """Creates a new Batch account with the specified parameters. Existing accounts cannot be updated
        with this API and should instead be updated with the Update Batch Account API.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param parameters: Additional parameters for account creation. Required.
        :type parameters: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns BatchAccount. The BatchAccount is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.batch.models.BatchAccount]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create(
        self,
        resource_group_name: str,
        account_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.BatchAccount]:
        """Creates a new Batch account with the specified parameters. Existing accounts cannot be updated
        with this API and should instead be updated with the Update Batch Account API.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param parameters: Additional parameters for account creation. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns BatchAccount. The BatchAccount is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.batch.models.BatchAccount]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create(
        self,
        resource_group_name: str,
        account_name: str,
        parameters: Union[_models.BatchAccountCreateParameters, JSON, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.BatchAccount]:
        """Creates a new Batch account with the specified parameters. Existing accounts cannot be updated
        with this API and should instead be updated with the Update Batch Account API.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param parameters: Additional parameters for account creation. Is one of the following types:
         BatchAccountCreateParameters, JSON, IO[bytes] Required.
        :type parameters: ~azure.mgmt.batch.models.BatchAccountCreateParameters or JSON or IO[bytes]
        :return: An instance of AsyncLROPoller that returns BatchAccount. The BatchAccount is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.batch.models.BatchAccount]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.BatchAccount] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_initial(
                resource_group_name=resource_group_name,
                account_name=account_name,
                parameters=parameters,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = _deserialize(_models.BatchAccount, response.json())
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.BatchAccount].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.BatchAccount](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @overload
    async def update(
        self,
        resource_group_name: str,
        account_name: str,
        parameters: _models.BatchAccountUpdateParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BatchAccount:
        """Updates the properties of an existing Batch account.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param parameters: Additional parameters for account update. Required.
        :type parameters: ~azure.mgmt.batch.models.BatchAccountUpdateParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: BatchAccount. The BatchAccount is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.BatchAccount
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        account_name: str,
        parameters: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BatchAccount:
        """Updates the properties of an existing Batch account.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param parameters: Additional parameters for account update. Required.
        :type parameters: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: BatchAccount. The BatchAccount is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.BatchAccount
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        account_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BatchAccount:
        """Updates the properties of an existing Batch account.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param parameters: Additional parameters for account update. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: BatchAccount. The BatchAccount is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.BatchAccount
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self,
        resource_group_name: str,
        account_name: str,
        parameters: Union[_models.BatchAccountUpdateParameters, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.BatchAccount:
        """Updates the properties of an existing Batch account.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param parameters: Additional parameters for account update. Is one of the following types:
         BatchAccountUpdateParameters, JSON, IO[bytes] Required.
        :type parameters: ~azure.mgmt.batch.models.BatchAccountUpdateParameters or JSON or IO[bytes]
        :return: BatchAccount. The BatchAccount is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.BatchAccount
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.BatchAccount] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _content = json.dumps(parameters, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_account_update_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.BatchAccount, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _delete_initial(self, resource_group_name: str, account_name: str, **kwargs: Any) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_batch_account_delete_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_delete(self, resource_group_name: str, account_name: str, **kwargs: Any) -> AsyncLROPoller[None]:
        """Deletes the specified Batch account.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(
                resource_group_name=resource_group_name,
                account_name=account_name,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def list_by_resource_group(self, resource_group_name: str, **kwargs: Any) -> AsyncItemPaged["_models.BatchAccount"]:
        """Gets information about the Batch accounts associated with the specified resource group.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :return: An iterator like instance of BatchAccount
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.batch.models.BatchAccount]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.BatchAccount]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_batch_account_list_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.BatchAccount], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.CloudError,
                    response,
                )
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list(self, **kwargs: Any) -> AsyncItemPaged["_models.BatchAccount"]:
        """Gets information about the Batch accounts associated with the subscription.

        :return: An iterator like instance of BatchAccount
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.batch.models.BatchAccount]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.BatchAccount]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_batch_account_list_request(
                    subscription_id=self._config.subscription_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.BatchAccount], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.CloudError,
                    response,
                )
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def synchronize_auto_storage_keys(self, resource_group_name: str, account_name: str, **kwargs: Any) -> None:
        """Synchronizes access keys for the auto-storage account configured for the specified Batch
        account, only if storage key authentication is being used.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_batch_account_synchronize_auto_storage_keys_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def regenerate_key(
        self,
        resource_group_name: str,
        account_name: str,
        parameters: _models.BatchAccountRegenerateKeyParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BatchAccountKeys:
        """Regenerates the specified account key for the Batch account.

        This operation applies only to Batch accounts with allowedAuthenticationModes containing
        'SharedKey'. If the Batch account doesn't contain 'SharedKey' in its allowedAuthenticationMode,
        clients cannot use shared keys to authenticate, and must use another allowedAuthenticationModes
        instead. In this case, regenerating the keys will fail.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param parameters: The type of key to regenerate. Required.
        :type parameters: ~azure.mgmt.batch.models.BatchAccountRegenerateKeyParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: BatchAccountKeys. The BatchAccountKeys is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.BatchAccountKeys
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def regenerate_key(
        self,
        resource_group_name: str,
        account_name: str,
        parameters: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BatchAccountKeys:
        """Regenerates the specified account key for the Batch account.

        This operation applies only to Batch accounts with allowedAuthenticationModes containing
        'SharedKey'. If the Batch account doesn't contain 'SharedKey' in its allowedAuthenticationMode,
        clients cannot use shared keys to authenticate, and must use another allowedAuthenticationModes
        instead. In this case, regenerating the keys will fail.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param parameters: The type of key to regenerate. Required.
        :type parameters: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: BatchAccountKeys. The BatchAccountKeys is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.BatchAccountKeys
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def regenerate_key(
        self,
        resource_group_name: str,
        account_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BatchAccountKeys:
        """Regenerates the specified account key for the Batch account.

        This operation applies only to Batch accounts with allowedAuthenticationModes containing
        'SharedKey'. If the Batch account doesn't contain 'SharedKey' in its allowedAuthenticationMode,
        clients cannot use shared keys to authenticate, and must use another allowedAuthenticationModes
        instead. In this case, regenerating the keys will fail.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param parameters: The type of key to regenerate. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: BatchAccountKeys. The BatchAccountKeys is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.BatchAccountKeys
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def regenerate_key(
        self,
        resource_group_name: str,
        account_name: str,
        parameters: Union[_models.BatchAccountRegenerateKeyParameters, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.BatchAccountKeys:
        """Regenerates the specified account key for the Batch account.

        This operation applies only to Batch accounts with allowedAuthenticationModes containing
        'SharedKey'. If the Batch account doesn't contain 'SharedKey' in its allowedAuthenticationMode,
        clients cannot use shared keys to authenticate, and must use another allowedAuthenticationModes
        instead. In this case, regenerating the keys will fail.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param parameters: The type of key to regenerate. Is one of the following types:
         BatchAccountRegenerateKeyParameters, JSON, IO[bytes] Required.
        :type parameters: ~azure.mgmt.batch.models.BatchAccountRegenerateKeyParameters or JSON or
         IO[bytes]
        :return: BatchAccountKeys. The BatchAccountKeys is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.BatchAccountKeys
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.BatchAccountKeys] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _content = json.dumps(parameters, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_batch_account_regenerate_key_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.BatchAccountKeys, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_keys(self, resource_group_name: str, account_name: str, **kwargs: Any) -> _models.BatchAccountKeys:
        """Gets the account keys for the specified Batch account.

        This operation applies only to Batch accounts with allowedAuthenticationModes containing
        'SharedKey'. If the Batch account doesn't contain 'SharedKey' in its allowedAuthenticationMode,
        clients cannot use shared keys to authenticate, and must use another allowedAuthenticationModes
        instead. In this case, getting the keys will fail.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :return: BatchAccountKeys. The BatchAccountKeys is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.BatchAccountKeys
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.BatchAccountKeys] = kwargs.pop("cls", None)

        _request = build_batch_account_get_keys_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.BatchAccountKeys, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_outbound_network_dependencies_endpoints(  # pylint: disable=name-too-long
        self, resource_group_name: str, account_name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.OutboundEnvironmentEndpoint"]:
        """Lists the endpoints that a Batch Compute Node under this Batch Account may call as part of
        Batch service administration. If you are deploying a Pool inside of a virtual network that you
        specify, you must make sure your network allows outbound access to these endpoints. Failure to
        allow access to these endpoints may cause Batch to mark the affected nodes as unusable. For
        more information about creating a pool inside of a virtual network, see
        `https://learn.microsoft.com/azure/batch/batch-virtual-network
        <https://learn.microsoft.com/azure/batch/batch-virtual-network>`_.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :return: An iterator like instance of OutboundEnvironmentEndpoint
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.batch.models.OutboundEnvironmentEndpoint]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.OutboundEnvironmentEndpoint]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_batch_account_list_outbound_network_dependencies_endpoints_request(
                    resource_group_name=resource_group_name,
                    account_name=account_name,
                    subscription_id=self._config.subscription_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.OutboundEnvironmentEndpoint], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.CloudError,
                    response,
                )
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_detector(
        self, resource_group_name: str, account_name: str, detector_id: str, **kwargs: Any
    ) -> _models.DetectorResponse:
        """Gets information about the given detector for a given Batch account.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param detector_id: The name of the detector. Required.
        :type detector_id: str
        :return: DetectorResponse. The DetectorResponse is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.DetectorResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.DetectorResponse] = kwargs.pop("cls", None)

        _request = build_batch_account_get_detector_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            detector_id=detector_id,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.DetectorResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_detectors(
        self, resource_group_name: str, account_name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.DetectorResponse"]:
        """Gets information about the detectors available for a given Batch account.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :return: An iterator like instance of DetectorResponse
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.batch.models.DetectorResponse]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.DetectorResponse]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_batch_account_list_detectors_request(
                    resource_group_name=resource_group_name,
                    account_name=account_name,
                    subscription_id=self._config.subscription_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.DetectorResponse], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.CloudError,
                    response,
                )
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class ApplicationPackageOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.batch.aio.BatchManagementClient`'s
        :attr:`application_package` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: BatchManagementClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, account_name: str, application_name: str, version_name: str, **kwargs: Any
    ) -> _models.ApplicationPackage:
        """Gets information about the specified application package.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param version_name: The version of the application. Required.
        :type version_name: str
        :return: ApplicationPackage. The ApplicationPackage is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.ApplicationPackage
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ApplicationPackage] = kwargs.pop("cls", None)

        _request = build_application_package_get_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            application_name=application_name,
            version_name=version_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.ApplicationPackage, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create(
        self,
        resource_group_name: str,
        account_name: str,
        application_name: str,
        version_name: str,
        parameters: Optional[_models.ApplicationPackage] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ApplicationPackage:
        """Creates an application package record. The record contains a storageUrl where the package
        should be uploaded to.  Once it is uploaded the ``ApplicationPackage`` needs to be activated
        using ``ApplicationPackageActive`` before it can be used. If the auto storage account was
        configured to use storage keys, the URL returned will contain a SAS.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param version_name: The version of the application. Required.
        :type version_name: str
        :param parameters: The parameters for the request. Default value is None.
        :type parameters: ~azure.mgmt.batch.models.ApplicationPackage
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ApplicationPackage. The ApplicationPackage is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.ApplicationPackage
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self,
        resource_group_name: str,
        account_name: str,
        application_name: str,
        version_name: str,
        parameters: Optional[JSON] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ApplicationPackage:
        """Creates an application package record. The record contains a storageUrl where the package
        should be uploaded to.  Once it is uploaded the ``ApplicationPackage`` needs to be activated
        using ``ApplicationPackageActive`` before it can be used. If the auto storage account was
        configured to use storage keys, the URL returned will contain a SAS.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param version_name: The version of the application. Required.
        :type version_name: str
        :param parameters: The parameters for the request. Default value is None.
        :type parameters: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ApplicationPackage. The ApplicationPackage is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.ApplicationPackage
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self,
        resource_group_name: str,
        account_name: str,
        application_name: str,
        version_name: str,
        parameters: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ApplicationPackage:
        """Creates an application package record. The record contains a storageUrl where the package
        should be uploaded to.  Once it is uploaded the ``ApplicationPackage`` needs to be activated
        using ``ApplicationPackageActive`` before it can be used. If the auto storage account was
        configured to use storage keys, the URL returned will contain a SAS.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param version_name: The version of the application. Required.
        :type version_name: str
        :param parameters: The parameters for the request. Default value is None.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ApplicationPackage. The ApplicationPackage is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.ApplicationPackage
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create(
        self,
        resource_group_name: str,
        account_name: str,
        application_name: str,
        version_name: str,
        parameters: Optional[Union[_models.ApplicationPackage, JSON, IO[bytes]]] = None,
        **kwargs: Any
    ) -> _models.ApplicationPackage:
        """Creates an application package record. The record contains a storageUrl where the package
        should be uploaded to.  Once it is uploaded the ``ApplicationPackage`` needs to be activated
        using ``ApplicationPackageActive`` before it can be used. If the auto storage account was
        configured to use storage keys, the URL returned will contain a SAS.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param version_name: The version of the application. Required.
        :type version_name: str
        :param parameters: The parameters for the request. Is one of the following types:
         ApplicationPackage, JSON, IO[bytes] Default value is None.
        :type parameters: ~azure.mgmt.batch.models.ApplicationPackage or JSON or IO[bytes]
        :return: ApplicationPackage. The ApplicationPackage is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.ApplicationPackage
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if parameters else None
        cls: ClsType[_models.ApplicationPackage] = kwargs.pop("cls", None)

        content_type = content_type or "application/json" if parameters else None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            if parameters is not None:
                _content = json.dumps(parameters, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_application_package_create_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            application_name=application_name,
            version_name=version_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.ApplicationPackage, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete(
        self, resource_group_name: str, account_name: str, application_name: str, version_name: str, **kwargs: Any
    ) -> None:
        """Deletes an application package record and its associated binary file.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param version_name: The version of the application. Required.
        :type version_name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_application_package_delete_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            application_name=application_name,
            version_name=version_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def list(
        self,
        resource_group_name: str,
        account_name: str,
        application_name: str,
        *,
        maxresults: Optional[int] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.ApplicationPackage"]:
        """Lists all of the application packages in the specified application.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :keyword maxresults: The maximum number of items to return in the response. Default value is
         None.
        :paramtype maxresults: int
        :return: An iterator like instance of ApplicationPackage
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.batch.models.ApplicationPackage]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.ApplicationPackage]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_application_package_list_request(
                    resource_group_name=resource_group_name,
                    account_name=account_name,
                    application_name=application_name,
                    subscription_id=self._config.subscription_id,
                    maxresults=maxresults,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.ApplicationPackage], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.CloudError,
                    response,
                )
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def activate(
        self,
        resource_group_name: str,
        account_name: str,
        application_name: str,
        version_name: str,
        parameters: _models.ActivateApplicationPackageParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ApplicationPackage:
        """Activates the specified application package. This should be done after the
        ``ApplicationPackage`` was created and uploaded. This needs to be done before an
        ``ApplicationPackage`` can be used on Pools or Tasks.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param version_name: The version of the application. Required.
        :type version_name: str
        :param parameters: The parameters for the request. Required.
        :type parameters: ~azure.mgmt.batch.models.ActivateApplicationPackageParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ApplicationPackage. The ApplicationPackage is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.ApplicationPackage
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def activate(
        self,
        resource_group_name: str,
        account_name: str,
        application_name: str,
        version_name: str,
        parameters: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ApplicationPackage:
        """Activates the specified application package. This should be done after the
        ``ApplicationPackage`` was created and uploaded. This needs to be done before an
        ``ApplicationPackage`` can be used on Pools or Tasks.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param version_name: The version of the application. Required.
        :type version_name: str
        :param parameters: The parameters for the request. Required.
        :type parameters: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ApplicationPackage. The ApplicationPackage is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.ApplicationPackage
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def activate(
        self,
        resource_group_name: str,
        account_name: str,
        application_name: str,
        version_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ApplicationPackage:
        """Activates the specified application package. This should be done after the
        ``ApplicationPackage`` was created and uploaded. This needs to be done before an
        ``ApplicationPackage`` can be used on Pools or Tasks.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param version_name: The version of the application. Required.
        :type version_name: str
        :param parameters: The parameters for the request. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ApplicationPackage. The ApplicationPackage is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.ApplicationPackage
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def activate(
        self,
        resource_group_name: str,
        account_name: str,
        application_name: str,
        version_name: str,
        parameters: Union[_models.ActivateApplicationPackageParameters, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.ApplicationPackage:
        """Activates the specified application package. This should be done after the
        ``ApplicationPackage`` was created and uploaded. This needs to be done before an
        ``ApplicationPackage`` can be used on Pools or Tasks.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param version_name: The version of the application. Required.
        :type version_name: str
        :param parameters: The parameters for the request. Is one of the following types:
         ActivateApplicationPackageParameters, JSON, IO[bytes] Required.
        :type parameters: ~azure.mgmt.batch.models.ActivateApplicationPackageParameters or JSON or
         IO[bytes]
        :return: ApplicationPackage. The ApplicationPackage is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.ApplicationPackage
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ApplicationPackage] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _content = json.dumps(parameters, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_application_package_activate_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            application_name=application_name,
            version_name=version_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.ApplicationPackage, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class ApplicationOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.batch.aio.BatchManagementClient`'s
        :attr:`application` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: BatchManagementClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, account_name: str, application_name: str, **kwargs: Any
    ) -> _models.Application:
        """Gets information about the specified application.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :return: Application. The Application is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.Application
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.Application] = kwargs.pop("cls", None)

        _request = build_application_get_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            application_name=application_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Application, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create(
        self,
        resource_group_name: str,
        account_name: str,
        application_name: str,
        parameters: Optional[_models.Application] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Application:
        """Adds an application to the specified Batch account.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param parameters: The parameters for the request. Default value is None.
        :type parameters: ~azure.mgmt.batch.models.Application
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Application. The Application is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.Application
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self,
        resource_group_name: str,
        account_name: str,
        application_name: str,
        parameters: Optional[JSON] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Application:
        """Adds an application to the specified Batch account.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param parameters: The parameters for the request. Default value is None.
        :type parameters: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Application. The Application is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.Application
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self,
        resource_group_name: str,
        account_name: str,
        application_name: str,
        parameters: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Application:
        """Adds an application to the specified Batch account.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param parameters: The parameters for the request. Default value is None.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Application. The Application is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.Application
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create(
        self,
        resource_group_name: str,
        account_name: str,
        application_name: str,
        parameters: Optional[Union[_models.Application, JSON, IO[bytes]]] = None,
        **kwargs: Any
    ) -> _models.Application:
        """Adds an application to the specified Batch account.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param parameters: The parameters for the request. Is one of the following types: Application,
         JSON, IO[bytes] Default value is None.
        :type parameters: ~azure.mgmt.batch.models.Application or JSON or IO[bytes]
        :return: Application. The Application is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.Application
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        content_type = content_type if parameters else None
        cls: ClsType[_models.Application] = kwargs.pop("cls", None)

        content_type = content_type or "application/json" if parameters else None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            if parameters is not None:
                _content = json.dumps(parameters, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_application_create_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            application_name=application_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Application, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update(
        self,
        resource_group_name: str,
        account_name: str,
        application_name: str,
        parameters: _models.Application,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Application:
        """Updates settings for the specified application.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param parameters: The parameters for the request. Required.
        :type parameters: ~azure.mgmt.batch.models.Application
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Application. The Application is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.Application
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        account_name: str,
        application_name: str,
        parameters: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Application:
        """Updates settings for the specified application.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param parameters: The parameters for the request. Required.
        :type parameters: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Application. The Application is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.Application
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        account_name: str,
        application_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Application:
        """Updates settings for the specified application.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param parameters: The parameters for the request. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Application. The Application is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.Application
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self,
        resource_group_name: str,
        account_name: str,
        application_name: str,
        parameters: Union[_models.Application, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.Application:
        """Updates settings for the specified application.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :param parameters: The parameters for the request. Is one of the following types: Application,
         JSON, IO[bytes] Required.
        :type parameters: ~azure.mgmt.batch.models.Application or JSON or IO[bytes]
        :return: Application. The Application is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.Application
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Application] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _content = json.dumps(parameters, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_application_update_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            application_name=application_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Application, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete(self, resource_group_name: str, account_name: str, application_name: str, **kwargs: Any) -> None:
        """Deletes an application.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param application_name: The name of the application. This must be unique within the account.
         Required.
        :type application_name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_application_delete_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            application_name=application_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def list(
        self, resource_group_name: str, account_name: str, *, maxresults: Optional[int] = None, **kwargs: Any
    ) -> AsyncItemPaged["_models.Application"]:
        """Lists all of the applications in the specified account.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :keyword maxresults: The maximum number of items to return in the response. Default value is
         None.
        :paramtype maxresults: int
        :return: An iterator like instance of Application
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.batch.models.Application]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.Application]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_application_list_request(
                    resource_group_name=resource_group_name,
                    account_name=account_name,
                    subscription_id=self._config.subscription_id,
                    maxresults=maxresults,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.Application], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.CloudError,
                    response,
                )
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class PrivateLinkResourceOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.batch.aio.BatchManagementClient`'s
        :attr:`private_link_resource` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: BatchManagementClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, account_name: str, private_link_resource_name: str, **kwargs: Any
    ) -> _models.PrivateLinkResource:
        """Gets information about the specified private link resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param private_link_resource_name: The private link resource name. This must be unique within
         the account. Required.
        :type private_link_resource_name: str
        :return: PrivateLinkResource. The PrivateLinkResource is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.PrivateLinkResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.PrivateLinkResource] = kwargs.pop("cls", None)

        _request = build_private_link_resource_get_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            private_link_resource_name=private_link_resource_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.PrivateLinkResource, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_by_batch_account(
        self, resource_group_name: str, account_name: str, *, maxresults: Optional[int] = None, **kwargs: Any
    ) -> AsyncItemPaged["_models.PrivateLinkResource"]:
        """Lists all of the private link resources in the specified account.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :keyword maxresults: The maximum number of items to return in the response. Default value is
         None.
        :paramtype maxresults: int
        :return: An iterator like instance of PrivateLinkResource
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.batch.models.PrivateLinkResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.PrivateLinkResource]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_private_link_resource_list_by_batch_account_request(
                    resource_group_name=resource_group_name,
                    account_name=account_name,
                    subscription_id=self._config.subscription_id,
                    maxresults=maxresults,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.PrivateLinkResource], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.CloudError,
                    response,
                )
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class PrivateEndpointConnectionOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.batch.aio.BatchManagementClient`'s
        :attr:`private_endpoint_connection` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: BatchManagementClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, account_name: str, private_endpoint_connection_name: str, **kwargs: Any
    ) -> _models.PrivateEndpointConnection:
        """Gets information about the specified private endpoint connection.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param private_endpoint_connection_name: The private endpoint connection name. This must be
         unique within the account. Required.
        :type private_endpoint_connection_name: str
        :return: PrivateEndpointConnection. The PrivateEndpointConnection is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.batch.models.PrivateEndpointConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.PrivateEndpointConnection] = kwargs.pop("cls", None)

        _request = build_private_endpoint_connection_get_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            private_endpoint_connection_name=private_endpoint_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.PrivateEndpointConnection, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _update_initial(
        self,
        resource_group_name: str,
        account_name: str,
        private_endpoint_connection_name: str,
        parameters: Union[_models.PrivateEndpointConnection, JSON, IO[bytes]],
        *,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _content = json.dumps(parameters, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_private_endpoint_connection_update_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            private_endpoint_connection_name=private_endpoint_connection_name,
            subscription_id=self._config.subscription_id,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update(
        self,
        resource_group_name: str,
        account_name: str,
        private_endpoint_connection_name: str,
        parameters: _models.PrivateEndpointConnection,
        *,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.PrivateEndpointConnection]:
        """Updates the properties of an existing private endpoint connection.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param private_endpoint_connection_name: The private endpoint connection name. This must be
         unique within the account. Required.
        :type private_endpoint_connection_name: str
        :param parameters: PrivateEndpointConnection properties that should be updated. Properties that
         are supplied will be updated, any property not supplied will be unchanged. Required.
        :type parameters: ~azure.mgmt.batch.models.PrivateEndpointConnection
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: An instance of AsyncLROPoller that returns PrivateEndpointConnection. The
         PrivateEndpointConnection is compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.batch.models.PrivateEndpointConnection]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update(
        self,
        resource_group_name: str,
        account_name: str,
        private_endpoint_connection_name: str,
        parameters: JSON,
        *,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.PrivateEndpointConnection]:
        """Updates the properties of an existing private endpoint connection.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param private_endpoint_connection_name: The private endpoint connection name. This must be
         unique within the account. Required.
        :type private_endpoint_connection_name: str
        :param parameters: PrivateEndpointConnection properties that should be updated. Properties that
         are supplied will be updated, any property not supplied will be unchanged. Required.
        :type parameters: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: An instance of AsyncLROPoller that returns PrivateEndpointConnection. The
         PrivateEndpointConnection is compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.batch.models.PrivateEndpointConnection]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update(
        self,
        resource_group_name: str,
        account_name: str,
        private_endpoint_connection_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.PrivateEndpointConnection]:
        """Updates the properties of an existing private endpoint connection.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param private_endpoint_connection_name: The private endpoint connection name. This must be
         unique within the account. Required.
        :type private_endpoint_connection_name: str
        :param parameters: PrivateEndpointConnection properties that should be updated. Properties that
         are supplied will be updated, any property not supplied will be unchanged. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: An instance of AsyncLROPoller that returns PrivateEndpointConnection. The
         PrivateEndpointConnection is compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.batch.models.PrivateEndpointConnection]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update(
        self,
        resource_group_name: str,
        account_name: str,
        private_endpoint_connection_name: str,
        parameters: Union[_models.PrivateEndpointConnection, JSON, IO[bytes]],
        *,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.PrivateEndpointConnection]:
        """Updates the properties of an existing private endpoint connection.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param private_endpoint_connection_name: The private endpoint connection name. This must be
         unique within the account. Required.
        :type private_endpoint_connection_name: str
        :param parameters: PrivateEndpointConnection properties that should be updated. Properties that
         are supplied will be updated, any property not supplied will be unchanged. Is one of the
         following types: PrivateEndpointConnection, JSON, IO[bytes] Required.
        :type parameters: ~azure.mgmt.batch.models.PrivateEndpointConnection or JSON or IO[bytes]
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: An instance of AsyncLROPoller that returns PrivateEndpointConnection. The
         PrivateEndpointConnection is compatible with MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.batch.models.PrivateEndpointConnection]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.PrivateEndpointConnection] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_initial(
                resource_group_name=resource_group_name,
                account_name=account_name,
                private_endpoint_connection_name=private_endpoint_connection_name,
                parameters=parameters,
                etag=etag,
                match_condition=match_condition,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = _deserialize(_models.PrivateEndpointConnection, response.json())
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.PrivateEndpointConnection].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.PrivateEndpointConnection](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _delete_initial(
        self, resource_group_name: str, account_name: str, private_endpoint_connection_name: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_private_endpoint_connection_delete_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            private_endpoint_connection_name=private_endpoint_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, account_name: str, private_endpoint_connection_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified private endpoint connection.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param private_endpoint_connection_name: The private endpoint connection name. This must be
         unique within the account. Required.
        :type private_endpoint_connection_name: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(
                resource_group_name=resource_group_name,
                account_name=account_name,
                private_endpoint_connection_name=private_endpoint_connection_name,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def list_by_batch_account(
        self, resource_group_name: str, account_name: str, *, maxresults: Optional[int] = None, **kwargs: Any
    ) -> AsyncItemPaged["_models.PrivateEndpointConnection"]:
        """Lists all of the private endpoint connections in the specified account.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :keyword maxresults: The maximum number of items to return in the response. Default value is
         None.
        :paramtype maxresults: int
        :return: An iterator like instance of PrivateEndpointConnection
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.batch.models.PrivateEndpointConnection]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.PrivateEndpointConnection]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_private_endpoint_connection_list_by_batch_account_request(
                    resource_group_name=resource_group_name,
                    account_name=account_name,
                    subscription_id=self._config.subscription_id,
                    maxresults=maxresults,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.PrivateEndpointConnection], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.CloudError,
                    response,
                )
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class PoolOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.batch.aio.BatchManagementClient`'s
        :attr:`pool` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: BatchManagementClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(self, resource_group_name: str, account_name: str, pool_name: str, **kwargs: Any) -> _models.Pool:
        """Gets information about the specified pool.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param pool_name: The pool name. This must be unique within the account. Required.
        :type pool_name: str
        :return: Pool. The Pool is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.Pool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.Pool] = kwargs.pop("cls", None)

        _request = build_pool_get_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            pool_name=pool_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Pool, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create(
        self,
        resource_group_name: str,
        account_name: str,
        pool_name: str,
        parameters: _models.Pool,
        *,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.Pool:
        """Creates a new pool inside the specified account.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param pool_name: The pool name. This must be unique within the account. Required.
        :type pool_name: str
        :param parameters: Additional parameters for pool creation. Required.
        :type parameters: ~azure.mgmt.batch.models.Pool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: Pool. The Pool is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.Pool
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self,
        resource_group_name: str,
        account_name: str,
        pool_name: str,
        parameters: JSON,
        *,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.Pool:
        """Creates a new pool inside the specified account.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param pool_name: The pool name. This must be unique within the account. Required.
        :type pool_name: str
        :param parameters: Additional parameters for pool creation. Required.
        :type parameters: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: Pool. The Pool is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.Pool
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self,
        resource_group_name: str,
        account_name: str,
        pool_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.Pool:
        """Creates a new pool inside the specified account.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param pool_name: The pool name. This must be unique within the account. Required.
        :type pool_name: str
        :param parameters: Additional parameters for pool creation. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: Pool. The Pool is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.Pool
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create(
        self,
        resource_group_name: str,
        account_name: str,
        pool_name: str,
        parameters: Union[_models.Pool, JSON, IO[bytes]],
        *,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.Pool:
        """Creates a new pool inside the specified account.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param pool_name: The pool name. This must be unique within the account. Required.
        :type pool_name: str
        :param parameters: Additional parameters for pool creation. Is one of the following types:
         Pool, JSON, IO[bytes] Required.
        :type parameters: ~azure.mgmt.batch.models.Pool or JSON or IO[bytes]
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: Pool. The Pool is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.Pool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Pool] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _content = json.dumps(parameters, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_pool_create_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            pool_name=pool_name,
            subscription_id=self._config.subscription_id,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Pool, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update(
        self,
        resource_group_name: str,
        account_name: str,
        pool_name: str,
        parameters: _models.Pool,
        *,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.Pool:
        """Updates the properties of an existing pool.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param pool_name: The pool name. This must be unique within the account. Required.
        :type pool_name: str
        :param parameters: Pool properties that should be updated. Properties that are supplied will be
         updated, any property not supplied will be unchanged. Required.
        :type parameters: ~azure.mgmt.batch.models.Pool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: Pool. The Pool is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.Pool
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        account_name: str,
        pool_name: str,
        parameters: JSON,
        *,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.Pool:
        """Updates the properties of an existing pool.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param pool_name: The pool name. This must be unique within the account. Required.
        :type pool_name: str
        :param parameters: Pool properties that should be updated. Properties that are supplied will be
         updated, any property not supplied will be unchanged. Required.
        :type parameters: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: Pool. The Pool is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.Pool
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        account_name: str,
        pool_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.Pool:
        """Updates the properties of an existing pool.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param pool_name: The pool name. This must be unique within the account. Required.
        :type pool_name: str
        :param parameters: Pool properties that should be updated. Properties that are supplied will be
         updated, any property not supplied will be unchanged. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: Pool. The Pool is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.Pool
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self,
        resource_group_name: str,
        account_name: str,
        pool_name: str,
        parameters: Union[_models.Pool, JSON, IO[bytes]],
        *,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any
    ) -> _models.Pool:
        """Updates the properties of an existing pool.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param pool_name: The pool name. This must be unique within the account. Required.
        :type pool_name: str
        :param parameters: Pool properties that should be updated. Properties that are supplied will be
         updated, any property not supplied will be unchanged. Is one of the following types: Pool,
         JSON, IO[bytes] Required.
        :type parameters: ~azure.mgmt.batch.models.Pool or JSON or IO[bytes]
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: Pool. The Pool is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.Pool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Pool] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _content = json.dumps(parameters, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_pool_update_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            pool_name=pool_name,
            subscription_id=self._config.subscription_id,
            etag=etag,
            match_condition=match_condition,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Pool, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    async def _delete_initial(
        self, resource_group_name: str, account_name: str, pool_name: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_pool_delete_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            pool_name=pool_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, account_name: str, pool_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified pool.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param pool_name: The pool name. This must be unique within the account. Required.
        :type pool_name: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(
                resource_group_name=resource_group_name,
                account_name=account_name,
                pool_name=pool_name,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def list_by_batch_account(
        self,
        resource_group_name: str,
        account_name: str,
        *,
        maxresults: Optional[int] = None,
        select: Optional[str] = None,
        filter: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.Pool"]:
        """Lists all of the pools in the specified account.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :keyword maxresults: The maximum number of items to return in the response. Default value is
         None.
        :paramtype maxresults: int
        :keyword select: Comma separated list of properties that should be returned. e.g.
         "properties/provisioningState". Only top level properties under properties/ are valid for
         selection. Default value is None.
        :paramtype select: str
        :keyword filter: OData filter expression. Valid properties for filtering are:

         name
         properties/allocationState
         properties/allocationStateTransitionTime
         properties/creationTime
         properties/provisioningState
         properties/provisioningStateTransitionTime
         properties/lastModified
         properties/vmSize
         properties/interNodeCommunication
         properties/scaleSettings/autoScale
         properties/scaleSettings/fixedScale. Default value is None.
        :paramtype filter: str
        :return: An iterator like instance of Pool
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.batch.models.Pool]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.Pool]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_pool_list_by_batch_account_request(
                    resource_group_name=resource_group_name,
                    account_name=account_name,
                    subscription_id=self._config.subscription_id,
                    maxresults=maxresults,
                    select=select,
                    filter=filter,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.Pool], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.CloudError,
                    response,
                )
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def disable_auto_scale(
        self, resource_group_name: str, account_name: str, pool_name: str, **kwargs: Any
    ) -> _models.Pool:
        """Disables automatic scaling for a pool.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param pool_name: The pool name. This must be unique within the account. Required.
        :type pool_name: str
        :return: Pool. The Pool is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.Pool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.Pool] = kwargs.pop("cls", None)

        _request = build_pool_disable_auto_scale_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            pool_name=pool_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Pool, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def stop_resize(
        self, resource_group_name: str, account_name: str, pool_name: str, **kwargs: Any
    ) -> _models.Pool:
        """Stops an ongoing resize operation on the pool.

        This does not restore the pool to its previous state before the resize operation: it only stops
        any further changes being made, and the pool maintains its current state. After stopping, the
        pool stabilizes at the number of nodes it was at when the stop operation was done. During the
        stop operation, the pool allocation state changes first to stopping and then to steady. A
        resize operation need not be an explicit resize pool request; this API can also be used to halt
        the initial sizing of the pool when it is created.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param pool_name: The pool name. This must be unique within the account. Required.
        :type pool_name: str
        :return: Pool. The Pool is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.Pool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.Pool] = kwargs.pop("cls", None)

        _request = build_pool_stop_resize_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            pool_name=pool_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Pool, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore


class NetworkSecurityPerimeterOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.batch.aio.BatchManagementClient`'s
        :attr:`network_security_perimeter` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: BatchManagementClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get_configuration(
        self,
        resource_group_name: str,
        account_name: str,
        network_security_perimeter_configuration_name: str,
        **kwargs: Any
    ) -> _models.NetworkSecurityPerimeterConfiguration:
        """Gets information about the specified NSP configuration.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param network_security_perimeter_configuration_name: The name for a network security perimeter
         configuration. Required.
        :type network_security_perimeter_configuration_name: str
        :return: NetworkSecurityPerimeterConfiguration. The NetworkSecurityPerimeterConfiguration is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.NetworkSecurityPerimeterConfiguration
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.NetworkSecurityPerimeterConfiguration] = kwargs.pop("cls", None)

        _request = build_network_security_perimeter_get_configuration_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            network_security_perimeter_configuration_name=network_security_perimeter_configuration_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.NetworkSecurityPerimeterConfiguration, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_configurations(
        self, resource_group_name: str, account_name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.NetworkSecurityPerimeterConfiguration"]:
        """Lists all of the NSP configurations in the specified account.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :return: An iterator like instance of NetworkSecurityPerimeterConfiguration
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.batch.models.NetworkSecurityPerimeterConfiguration]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.NetworkSecurityPerimeterConfiguration]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_network_security_perimeter_list_configurations_request(
                    resource_group_name=resource_group_name,
                    account_name=account_name,
                    subscription_id=self._config.subscription_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(
                List[_models.NetworkSecurityPerimeterConfiguration], deserialized.get("value", [])
            )
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.CloudError,
                    response,
                )
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    async def _reconcile_configuration_initial(
        self,
        resource_group_name: str,
        account_name: str,
        network_security_perimeter_configuration_name: str,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_network_security_perimeter_reconcile_configuration_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            network_security_perimeter_configuration_name=network_security_perimeter_configuration_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
        response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_reconcile_configuration(
        self,
        resource_group_name: str,
        account_name: str,
        network_security_perimeter_configuration_name: str,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Reconciles the specified NSP configuration.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param account_name: A name for the Batch account which must be unique within the region. Batch
         account names must be between 3 and 24 characters in length and must use only numbers and
         lowercase letters. This name is used as part of the DNS name that is used to access the Batch
         service in the region in which the account is created. For example:
         `http://accountname.region.batch.azure.com/ <http://accountname.region.batch.azure.com/>`_.
         Required.
        :type account_name: str
        :param network_security_perimeter_configuration_name: The name for a network security perimeter
         configuration. Required.
        :type network_security_perimeter_configuration_name: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._reconcile_configuration_initial(
                resource_group_name=resource_group_name,
                account_name=account_name,
                network_security_perimeter_configuration_name=network_security_perimeter_configuration_name,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore


class LocationOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.batch.aio.BatchManagementClient`'s
        :attr:`location` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: BatchManagementClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get_quotas(self, location_name: str, **kwargs: Any) -> _models.BatchLocationQuota:
        """Gets the Batch service quotas for the specified subscription at the given location.

        :param location_name: The region for which to retrieve Batch service quotas. Required.
        :type location_name: str
        :return: BatchLocationQuota. The BatchLocationQuota is compatible with MutableMapping
        :rtype: ~azure.mgmt.batch.models.BatchLocationQuota
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.BatchLocationQuota] = kwargs.pop("cls", None)

        _request = build_location_get_quotas_request(
            location_name=location_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.BatchLocationQuota, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_supported_virtual_machine_skus(
        self, location_name: str, *, maxresults: Optional[int] = None, filter: Optional[str] = None, **kwargs: Any
    ) -> AsyncItemPaged["_models.SupportedSku"]:
        """Gets the list of Batch supported Virtual Machine VM sizes available at the given location.

        :param location_name: The region for which to retrieve Batch service supported SKUs. Required.
        :type location_name: str
        :keyword maxresults: The maximum number of items to return in the response. Default value is
         None.
        :paramtype maxresults: int
        :keyword filter: OData filter expression. Valid properties for filtering are "familyName".
         Default value is None.
        :paramtype filter: str
        :return: An iterator like instance of SupportedSku
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.batch.models.SupportedSku]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.SupportedSku]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_location_list_supported_virtual_machine_skus_request(
                    location_name=location_name,
                    subscription_id=self._config.subscription_id,
                    maxresults=maxresults,
                    filter=filter,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.SupportedSku], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.CloudError,
                    response,
                )
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def check_name_availability(
        self,
        location_name: str,
        parameters: _models.CheckNameAvailabilityParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CheckNameAvailabilityResult:
        """Checks whether the Batch account name is available in the specified region.

        :param location_name: The desired region for the name check. Required.
        :type location_name: str
        :param parameters: Properties needed to check the availability of a name. Required.
        :type parameters: ~azure.mgmt.batch.models.CheckNameAvailabilityParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CheckNameAvailabilityResult. The CheckNameAvailabilityResult is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.batch.models.CheckNameAvailabilityResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def check_name_availability(
        self, location_name: str, parameters: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CheckNameAvailabilityResult:
        """Checks whether the Batch account name is available in the specified region.

        :param location_name: The desired region for the name check. Required.
        :type location_name: str
        :param parameters: Properties needed to check the availability of a name. Required.
        :type parameters: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CheckNameAvailabilityResult. The CheckNameAvailabilityResult is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.batch.models.CheckNameAvailabilityResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def check_name_availability(
        self, location_name: str, parameters: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CheckNameAvailabilityResult:
        """Checks whether the Batch account name is available in the specified region.

        :param location_name: The desired region for the name check. Required.
        :type location_name: str
        :param parameters: Properties needed to check the availability of a name. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CheckNameAvailabilityResult. The CheckNameAvailabilityResult is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.batch.models.CheckNameAvailabilityResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def check_name_availability(
        self,
        location_name: str,
        parameters: Union[_models.CheckNameAvailabilityParameters, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.CheckNameAvailabilityResult:
        """Checks whether the Batch account name is available in the specified region.

        :param location_name: The desired region for the name check. Required.
        :type location_name: str
        :param parameters: Properties needed to check the availability of a name. Is one of the
         following types: CheckNameAvailabilityParameters, JSON, IO[bytes] Required.
        :type parameters: ~azure.mgmt.batch.models.CheckNameAvailabilityParameters or JSON or IO[bytes]
        :return: CheckNameAvailabilityResult. The CheckNameAvailabilityResult is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.batch.models.CheckNameAvailabilityResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CheckNameAvailabilityResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _content = json.dumps(parameters, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_location_check_name_availability_request(
            location_name=location_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.CloudError,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CheckNameAvailabilityResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
