# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.containerregistrytasks import ContainerRegistryTasksMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-containerregistrytasks
# USAGE
    python tasks_create_with_login_identity.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ContainerRegistryTasksMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.tasks.create(
        resource_group_name="myResourceGroup",
        registry_name="myRegistry",
        task_name="mytTask",
        task_create_parameters={
            "identity": {"type": "SystemAssigned"},
            "location": "eastus",
            "properties": {
                "agentConfiguration": {"cpu": 2},
                "credentials": {"sourceRegistry": {"identity": "[system]"}},
                "isSystemTask": False,
                "logTemplate": None,
                "platform": {"architecture": "amd64", "os": "Linux"},
                "status": "Enabled",
                "step": {
                    "arguments": [
                        {"isSecret": False, "name": "mytestargument", "value": "mytestvalue"},
                        {"isSecret": True, "name": "mysecrettestargument", "value": "mysecrettestvalue"},
                    ],
                    "contextPath": "src",
                    "dockerFilePath": "src/DockerFile",
                    "imageNames": ["azurerest:testtag"],
                    "isPushEnabled": True,
                    "noCache": False,
                    "type": "Docker",
                },
                "trigger": {
                    "baseImageTrigger": {"baseImageTriggerType": "Runtime", "name": "myBaseImageTrigger"},
                    "sourceTriggers": [
                        {
                            "name": "mySourceTrigger",
                            "sourceRepository": {
                                "branch": "master",
                                "repositoryUrl": "https://github.com/Azure/azure-rest-api-specs",
                                "sourceControlAuthProperties": {"token": "xxxxx", "tokenType": "PAT"},
                                "sourceControlType": "Github",
                            },
                            "sourceTriggerEvents": ["commit"],
                        }
                    ],
                    "timerTriggers": [{"name": "myTimerTrigger", "schedule": "30 9 * * 1-5"}],
                },
            },
            "tags": {"testkey": "value"},
        },
    )
    print(response)


# x-ms-original-file: 2025-03-01-preview/ManagedIdentity/TasksCreate_WithLoginIdentity.json
if __name__ == "__main__":
    main()
