# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.netapp import NetAppManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-netapp
# USAGE
    python volumes_update.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = NetAppManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.volumes.begin_update(
        resource_group_name="myRG",
        account_name="account1",
        pool_name="pool1",
        volume_name="volume1",
        body={
            "id": "str",
            "location": "str",
            "name": "str",
            "properties": {
                "coolAccess": bool,
                "coolAccessRetrievalPolicy": "str",
                "coolAccessTieringPolicy": "str",
                "coolnessPeriod": 0,
                "dataProtection": {
                    "backup": {"backupPolicyId": "str", "backupVaultId": "str", "policyEnforced": bool},
                    "ransomwareProtection": {"desiredRansomwareProtectionState": "str"},
                    "snapshot": {"snapshotPolicyId": "str"},
                },
                "defaultGroupQuotaInKiBs": 0,
                "defaultUserQuotaInKiBs": 0,
                "exportPolicy": {
                    "rules": [
                        {
                            "allowedClients": "str",
                            "chownMode": "str",
                            "cifs": bool,
                            "hasRootAccess": bool,
                            "kerberos5ReadOnly": bool,
                            "kerberos5ReadWrite": bool,
                            "kerberos5iReadOnly": bool,
                            "kerberos5iReadWrite": bool,
                            "kerberos5pReadOnly": bool,
                            "kerberos5pReadWrite": bool,
                            "nfsv3": bool,
                            "nfsv41": bool,
                            "ruleIndex": 0,
                            "unixReadOnly": bool,
                            "unixReadWrite": bool,
                        }
                    ]
                },
                "isDefaultQuotaEnabled": bool,
                "protocolTypes": ["str"],
                "serviceLevel": "str",
                "smbAccessBasedEnumeration": "str",
                "smbNonBrowsable": "str",
                "snapshotDirectoryVisible": bool,
                "throughputMibps": 0.0,
                "unixPermissions": "str",
                "usageThreshold": 0,
            },
            "tags": {"str": "str"},
            "type": "str",
        },
    ).result()
    print(response)


# x-ms-original-file: 2025-12-01/Volumes_Update.json
if __name__ == "__main__":
    main()
