# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AzureManagedDiskPerformanceTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Storage tier of a server."""

    P1 = "P1"
    """P1."""
    P2 = "P2"
    """P2."""
    P3 = "P3"
    """P3."""
    P4 = "P4"
    """P4."""
    P6 = "P6"
    """P6."""
    P10 = "P10"
    """P10."""
    P15 = "P15"
    """P15."""
    P20 = "P20"
    """P20."""
    P30 = "P30"
    """P30."""
    P40 = "P40"
    """P40."""
    P50 = "P50"
    """P50."""
    P60 = "P60"
    """P60."""
    P70 = "P70"
    """P70."""
    P80 = "P80"
    """P80."""


class BackupType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of backup."""

    FULL = "Full"
    """FULL."""
    CUSTOMER_ON_DEMAND = "Customer On-Demand"
    """CUSTOMER_ON_DEMAND."""


class Cancel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates if cancel must be triggered for the entire migration."""

    TRUE = "True"
    """TRUE."""
    FALSE = "False"
    """FALSE."""


class CapabilityStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the capability."""

    VISIBLE = "Visible"
    """VISIBLE."""
    AVAILABLE = "Available"
    """AVAILABLE."""
    DEFAULT = "Default"
    """DEFAULT."""
    DISABLED = "Disabled"
    """DISABLED."""


class CheckNameAvailabilityReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible reasons for a name not being available."""

    INVALID = "Invalid"
    """Name is invalid."""
    ALREADY_EXISTS = "AlreadyExists"
    """Name already exists."""


class ConfigurationDataType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Data type of the configuration (also known as server parameter)."""

    BOOLEAN = "Boolean"
    """BOOLEAN."""
    NUMERIC = "Numeric"
    """NUMERIC."""
    INTEGER = "Integer"
    """INTEGER."""
    ENUMERATION = "Enumeration"
    """ENUMERATION."""
    STRING = "String"
    """STRING."""
    SET = "Set"
    """SET."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class CreateMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Creation mode of a new server."""

    DEFAULT = "Default"
    """DEFAULT."""
    CREATE = "Create"
    """CREATE."""
    UPDATE = "Update"
    """UPDATE."""
    POINT_IN_TIME_RESTORE = "PointInTimeRestore"
    """POINT_IN_TIME_RESTORE."""
    GEO_RESTORE = "GeoRestore"
    """GEO_RESTORE."""
    REPLICA = "Replica"
    """REPLICA."""
    REVIVE_DROPPED = "ReviveDropped"
    """REVIVE_DROPPED."""


class CreateModeForPatch(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Update mode of an existing server."""

    DEFAULT = "Default"
    """DEFAULT."""
    UPDATE = "Update"
    """UPDATE."""


class DataEncryptionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Data encryption type used by a server."""

    SYSTEM_MANAGED = "SystemManaged"
    """SYSTEM_MANAGED."""
    AZURE_KEY_VAULT = "AzureKeyVault"
    """AZURE_KEY_VAULT."""


class EncryptionKeyStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of key used by a server configured with data encryption based on customer managed key,
    to encrypt the primary storage associated to the server.
    """

    VALID = "Valid"
    """VALID."""
    INVALID = "Invalid"
    """INVALID."""


class ExecutionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Service-set extensible enum indicating the status of operation."""

    RUNNING = "Running"
    """RUNNING."""
    CANCELLED = "Cancelled"
    """CANCELLED."""
    FAILED = "Failed"
    """FAILED."""
    SUCCEEDED = "Succeeded"
    """SUCCEEDED."""


class FailoverMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Failover mode."""

    PLANNED_FAILOVER = "PlannedFailover"
    """PLANNED_FAILOVER."""
    FORCED_FAILOVER = "ForcedFailover"
    """FORCED_FAILOVER."""
    PLANNED_SWITCHOVER = "PlannedSwitchover"
    """PLANNED_SWITCHOVER."""
    FORCED_SWITCHOVER = "ForcedSwitchover"
    """FORCED_SWITCHOVER."""


class FastProvisioningSupport(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates if fast provisioning is supported. 'Enabled' means fast provisioning is supported.
    'Disabled' stands for fast provisioning is not supported. Will be deprecated in the future.
    Look to Supported Features for 'FastProvisioning'.
    """

    ENABLED = "Enabled"
    """ENABLED."""
    DISABLED = "Disabled"
    """DISABLED."""


class FeatureStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the feature. Indicates if the feature is enabled or not."""

    ENABLED = "Enabled"
    """ENABLED."""
    DISABLED = "Disabled"
    """DISABLED."""


class GeographicallyRedundantBackup(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates if the server is configured to create geographically redundant backups."""

    ENABLED = "Enabled"
    """ENABLED."""
    DISABLED = "Disabled"
    """DISABLED."""


class GeographicallyRedundantBackupSupport(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates if geographically redundant backups are supported in this location. 'Enabled' means
    geographically redundant backups are supported. 'Disabled' stands for geographically redundant
    backup is not supported. Will be deprecated in the future. Look to Supported Features for
    'GeoBackup'.
    """

    ENABLED = "Enabled"
    """ENABLED."""
    DISABLED = "Disabled"
    """DISABLED."""


class HighAvailabilityMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Modes of high availability supported for this compute."""

    ZONE_REDUNDANT = "ZoneRedundant"
    """ZONE_REDUNDANT."""
    SAME_ZONE = "SameZone"
    """SAME_ZONE."""


class HighAvailabilityState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible states of the standby server created when high availability is set to SameZone or
    ZoneRedundant.
    """

    NOT_ENABLED = "NotEnabled"
    """NOT_ENABLED."""
    CREATING_STANDBY = "CreatingStandby"
    """CREATING_STANDBY."""
    REPLICATING_DATA = "ReplicatingData"
    """REPLICATING_DATA."""
    FAILING_OVER = "FailingOver"
    """FAILING_OVER."""
    HEALTHY = "Healthy"
    """HEALTHY."""
    REMOVING_STANDBY = "RemovingStandby"
    """REMOVING_STANDBY."""


class IdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Types of identities associated with a server."""

    NONE = "None"
    """NONE."""
    USER_ASSIGNED = "UserAssigned"
    """USER_ASSIGNED."""
    SYSTEM_ASSIGNED = "SystemAssigned"
    """SYSTEM_ASSIGNED."""
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"
    """SYSTEM_ASSIGNED_USER_ASSIGNED."""


class LocationRestricted(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates if this location is restricted. 'Enabled' means location is restricted. 'Disabled'
    stands for location is not restricted. Will be deprecated in the future. Look to Supported
    Features for 'Restricted'.
    """

    ENABLED = "Enabled"
    """ENABLED."""
    DISABLED = "Disabled"
    """DISABLED."""


class LogicalReplicationOnSourceServer(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether to setup logical replication on source server, if needed."""

    TRUE = "True"
    """TRUE."""
    FALSE = "False"
    """FALSE."""


class MicrosoftEntraAuth(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates if the server supports Microsoft Entra authentication."""

    ENABLED = "Enabled"
    """ENABLED."""
    DISABLED = "Disabled"
    """DISABLED."""


class MigrateRolesAndPermissions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates if roles and permissions must be migrated."""

    TRUE = "True"
    """TRUE."""
    FALSE = "False"
    """FALSE."""


class MigrationDatabaseState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Migration state of a database."""

    IN_PROGRESS = "InProgress"
    """IN_PROGRESS."""
    WAITING_FOR_CUTOVER_TRIGGER = "WaitingForCutoverTrigger"
    """WAITING_FOR_CUTOVER_TRIGGER."""
    FAILED = "Failed"
    """FAILED."""
    CANCELED = "Canceled"
    """CANCELED."""
    SUCCEEDED = "Succeeded"
    """SUCCEEDED."""
    CANCELING = "Canceling"
    """CANCELING."""


class MigrationListFilter(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of MigrationListFilter."""

    ACTIVE = "Active"
    """ACTIVE."""
    ALL = "All"
    """ALL."""


class MigrationMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Mode used to perform the migration: Online or Offline."""

    OFFLINE = "Offline"
    """OFFLINE."""
    ONLINE = "Online"
    """ONLINE."""


class MigrationNameAvailabilityReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Migration name availability reason."""

    INVALID = "Invalid"
    """INVALID."""
    ALREADY_EXISTS = "AlreadyExists"
    """ALREADY_EXISTS."""


class MigrationOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Supported option for a migration."""

    VALIDATE = "Validate"
    """VALIDATE."""
    MIGRATE = "Migrate"
    """MIGRATE."""
    VALIDATE_AND_MIGRATE = "ValidateAndMigrate"
    """VALIDATE_AND_MIGRATE."""


class MigrationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of migration."""

    IN_PROGRESS = "InProgress"
    """IN_PROGRESS."""
    WAITING_FOR_USER_ACTION = "WaitingForUserAction"
    """WAITING_FOR_USER_ACTION."""
    CANCELED = "Canceled"
    """CANCELED."""
    FAILED = "Failed"
    """FAILED."""
    SUCCEEDED = "Succeeded"
    """SUCCEEDED."""
    VALIDATION_FAILED = "ValidationFailed"
    """VALIDATION_FAILED."""
    CLEANING_UP = "CleaningUp"
    """CLEANING_UP."""


class MigrationSubstate(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Substate of migration."""

    PERFORMING_PRE_REQUISITE_STEPS = "PerformingPreRequisiteSteps"
    """PERFORMING_PRE_REQUISITE_STEPS."""
    WAITING_FOR_LOGICAL_REPLICATION_SETUP_REQUEST_ON_SOURCE_DB = "WaitingForLogicalReplicationSetupRequestOnSourceDB"
    """WAITING_FOR_LOGICAL_REPLICATION_SETUP_REQUEST_ON_SOURCE_DB."""
    WAITING_FOR_DBS_TO_MIGRATE_SPECIFICATION = "WaitingForDBsToMigrateSpecification"
    """WAITING_FOR_DBS_TO_MIGRATE_SPECIFICATION."""
    WAITING_FOR_TARGET_DB_OVERWRITE_CONFIRMATION = "WaitingForTargetDBOverwriteConfirmation"
    """WAITING_FOR_TARGET_DB_OVERWRITE_CONFIRMATION."""
    WAITING_FOR_DATA_MIGRATION_SCHEDULING = "WaitingForDataMigrationScheduling"
    """WAITING_FOR_DATA_MIGRATION_SCHEDULING."""
    WAITING_FOR_DATA_MIGRATION_WINDOW = "WaitingForDataMigrationWindow"
    """WAITING_FOR_DATA_MIGRATION_WINDOW."""
    MIGRATING_DATA = "MigratingData"
    """MIGRATING_DATA."""
    WAITING_FOR_CUTOVER_TRIGGER = "WaitingForCutoverTrigger"
    """WAITING_FOR_CUTOVER_TRIGGER."""
    COMPLETING_MIGRATION = "CompletingMigration"
    """COMPLETING_MIGRATION."""
    COMPLETED = "Completed"
    """COMPLETED."""
    CANCELING_REQUESTED_DB_MIGRATIONS = "CancelingRequestedDBMigrations"
    """CANCELING_REQUESTED_DB_MIGRATIONS."""
    VALIDATION_IN_PROGRESS = "ValidationInProgress"
    """VALIDATION_IN_PROGRESS."""


class NetworkMigrationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of the network migration operation."""

    PENDING = "Pending"
    """The network migration is pending."""
    IN_PROGRESS = "InProgress"
    """The network migration is in progress."""
    SUCCEEDED = "Succeeded"
    """The network migration succeeded."""
    FAILED = "Failed"
    """The network migration failed."""
    CANCEL_IN_PROGRESS = "CancelInProgress"
    """The network migration cancellation is in progress."""
    CANCELLED = "Cancelled"
    """The network migration was cancelled."""


class OnlineStorageResizeSupport(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates if resizing the storage, without interrupting the operation of the database engine,
    is supported in this location for the given subscription. 'Enabled' means resizing the storage
    without interrupting the operation of the database engine is supported. 'Disabled' means
    resizing the storage without interrupting the operation of the database engine is not
    supported. Will be deprecated in the future. Look to Supported Features for 'OnlineResize'.
    """

    ENABLED = "Enabled"
    """ENABLED."""
    DISABLED = "Disabled"
    """DISABLED."""


class OperationOrigin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Intended executor of the operation."""

    NOT_SPECIFIED = "NotSpecified"
    """NOT_SPECIFIED."""
    USER = "user"
    """USER."""
    SYSTEM = "system"
    """SYSTEM."""


class OverwriteDatabasesOnTargetServer(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates if databases on the target server can be overwritten when already present. If set to
    'False', when the migration workflow detects that the database already exists on the target
    server, it will wait for a confirmation.
    """

    TRUE = "True"
    """TRUE."""
    FALSE = "False"
    """FALSE."""


class PasswordBasedAuth(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates if the server supports password based authentication."""

    ENABLED = "Enabled"
    """ENABLED."""
    DISABLED = "Disabled"
    """DISABLED."""


class PostgresMajorVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Major version of PostgreSQL database engine."""

    EIGHTEEN = "18"
    """EIGHTEEN."""
    SEVENTEEN = "17"
    """SEVENTEEN."""
    SIXTEEN = "16"
    """SIXTEEN."""
    FIFTEEN = "15"
    """FIFTEEN."""
    FOURTEEN = "14"
    """FOURTEEN."""
    THIRTEEN = "13"
    """THIRTEEN."""
    TWELVE = "12"
    """TWELVE."""
    ELEVEN = "11"
    """ELEVEN."""


class PostgreSqlFlexibleServerHighAvailabilityMode(  # pylint: disable=name-too-long
    str, Enum, metaclass=CaseInsensitiveEnumMeta
):
    """Modes of high availability supported for this compute."""

    DISABLED = "Disabled"
    """DISABLED."""
    ZONE_REDUNDANT = "ZoneRedundant"
    """ZONE_REDUNDANT."""
    SAME_ZONE = "SameZone"
    """SAME_ZONE."""


class PrincipalType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of Microsoft Entra principal to which the server administrator is associated."""

    UNKNOWN = "Unknown"
    """The principal type is not known or not specified."""
    USER = "User"
    """A Microsoft Entra user."""
    GROUP = "Group"
    """A Microsoft Entra group."""
    SERVICE_PRINCIPAL = "ServicePrincipal"
    """A Microsoft Entra service principal, typically representing an application or service identity."""


class PrivateEndpointConnectionProvisioningState(  # pylint: disable=name-too-long
    str, Enum, metaclass=CaseInsensitiveEnumMeta
):
    """The current provisioning state."""

    SUCCEEDED = "Succeeded"
    """Connection has been provisioned."""
    CREATING = "Creating"
    """Connection is being created."""
    DELETING = "Deleting"
    """Connection is being deleted."""
    FAILED = "Failed"
    """Connection provisioning has failed."""


class PrivateEndpointServiceConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The private endpoint connection status."""

    PENDING = "Pending"
    """Connection waiting for approval or rejection."""
    APPROVED = "Approved"
    """Connection approved."""
    REJECTED = "Rejected"
    """Connection Rejected."""


class ReadReplicaPromoteMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of operation to apply on the read replica. This property is write only. Standalone means
    that the read replica will be promoted to a standalone server, and will become a completely
    independent entity from the replication set. Switchover means that the read replica will roles
    with the primary server.
    """

    STANDALONE = "Standalone"
    """Read replica will become an independent server."""
    SWITCHOVER = "Switchover"
    """Read replica will swap roles with primary server."""


class ReadReplicaPromoteOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Data synchronization option to use when processing the operation specified in the promoteMode
    property. This property is write only.
    """

    PLANNED = "Planned"
    """The operation will wait for data in the read replica to be fully synchronized with its source
    server, before it initiates the operation."""
    FORCED = "Forced"
    """The operation will not wait for data in the read replica to be synchronized with its source
    server, before it initiates the operation."""


class RecommendationTypeEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type for this recommendation."""

    CREATE_INDEX = "CreateIndex"
    """CREATE_INDEX."""
    DROP_INDEX = "DropIndex"
    """DROP_INDEX."""
    RE_INDEX = "ReIndex"
    """RE_INDEX."""
    ANALYZE_TABLE = "AnalyzeTable"
    """ANALYZE_TABLE."""
    VACUUM_TABLE = "VacuumTable"
    """VACUUM_TABLE."""


class RecommendationTypeParameterEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Recommendations list filter. Retrieves recommendations based on type."""

    CREATE_INDEX = "CreateIndex"
    """CREATE_INDEX."""
    DROP_INDEX = "DropIndex"
    """DROP_INDEX."""
    RE_INDEX = "ReIndex"
    """RE_INDEX."""
    ANALYZE_TABLE = "AnalyzeTable"
    """ANALYZE_TABLE."""
    VACUUM_TABLE = "VacuumTable"
    """VACUUM_TABLE."""


class ReplicationRole(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Role of the server in a replication set."""

    NONE = "None"
    """NONE."""
    PRIMARY = "Primary"
    """PRIMARY."""
    ASYNC_REPLICA = "AsyncReplica"
    """ASYNC_REPLICA."""
    GEO_ASYNC_REPLICA = "GeoAsyncReplica"
    """GEO_ASYNC_REPLICA."""


class ReplicationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the replication state of a read replica. This property is returned only when the
    target server is a read replica. Possible  values are Active, Broken, Catchup, Provisioning,
    Reconfiguring, and Updating.
    """

    ACTIVE = "Active"
    """The read replica server is fully synchronized and actively replicating data from the primary
    server."""
    CATCHUP = "Catchup"
    """The read replica server is behind the primary server and is currently catching up with pending
    changes."""
    PROVISIONING = "Provisioning"
    """The read replica server is being created and is in process of getting initialized."""
    UPDATING = "Updating"
    """The read replica server is undergoing some changes it can be changing compute size of promoting
    it to primary server."""
    BROKEN = "Broken"
    """Replication has failed or been interrupted."""
    RECONFIGURING = "Reconfiguring"
    """The read replica server is being reconfigured, possibly due to changes in source or settings."""


class ServerPublicNetworkAccessState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates if public network access is enabled or not."""

    ENABLED = "Enabled"
    """ENABLED."""
    DISABLED = "Disabled"
    """DISABLED."""


class ServerState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible states of a server."""

    READY = "Ready"
    """READY."""
    DROPPING = "Dropping"
    """DROPPING."""
    DISABLED = "Disabled"
    """DISABLED."""
    STARTING = "Starting"
    """STARTING."""
    STOPPING = "Stopping"
    """STOPPING."""
    STOPPED = "Stopped"
    """STOPPED."""
    UPDATING = "Updating"
    """UPDATING."""
    RESTARTING = "Restarting"
    """RESTARTING."""
    INACCESSIBLE = "Inaccessible"
    """INACCESSIBLE."""
    PROVISIONING = "Provisioning"
    """PROVISIONING."""


class SkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Tier of the compute assigned to a server."""

    BURSTABLE = "Burstable"
    """BURSTABLE."""
    GENERAL_PURPOSE = "GeneralPurpose"
    """GENERAL_PURPOSE."""
    MEMORY_OPTIMIZED = "MemoryOptimized"
    """MEMORY_OPTIMIZED."""


class SourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Source server type used for the migration: ApsaraDB_RDS, AWS, AWS_AURORA, AWS_EC2, AWS_RDS,
    AzureVM, Crunchy_PostgreSQL, Digital_Ocean_Droplets, Digital_Ocean_PostgreSQL, EDB,
    EDB_Oracle_Server, EDB_PostgreSQL, GCP, GCP_AlloyDB, GCP_CloudSQL, GCP_Compute,
    Heroku_PostgreSQL, Huawei_Compute, Huawei_RDS, OnPremises, PostgreSQLCosmosDB,
    PostgreSQLFlexibleServer, PostgreSQLSingleServer, or Supabase_PostgreSQL.
    """

    ON_PREMISES = "OnPremises"
    """ON_PREMISES."""
    AWS = "AWS"
    """AWS."""
    GCP = "GCP"
    """GCP."""
    AZURE_VM = "AzureVM"
    """AZURE_VM."""
    POSTGRE_SQL_SINGLE_SERVER = "PostgreSQLSingleServer"
    """POSTGRE_SQL_SINGLE_SERVER."""
    AWS_RDS = "AWS_RDS"
    """AWS_RDS."""
    AWS_AURORA = "AWS_AURORA"
    """AWS_AURORA."""
    AWS_EC2 = "AWS_EC2"
    """AWS_EC2."""
    GCP_CLOUD_SQL = "GCP_CloudSQL"
    """GCP_CLOUD_SQL."""
    GCP_ALLOY_DB = "GCP_AlloyDB"
    """GCP_ALLOY_DB."""
    GCP_COMPUTE = "GCP_Compute"
    """GCP_COMPUTE."""
    EDB = "EDB"
    """EDB."""
    EDB_ORACLE_SERVER = "EDB_Oracle_Server"
    """EDB_ORACLE_SERVER."""
    EDB_POSTGRE_SQL = "EDB_PostgreSQL"
    """EDB_POSTGRE_SQL."""
    POSTGRE_SQL_FLEXIBLE_SERVER = "PostgreSQLFlexibleServer"
    """POSTGRE_SQL_FLEXIBLE_SERVER."""
    POSTGRE_SQL_COSMOS_DB = "PostgreSQLCosmosDB"
    """POSTGRE_SQL_COSMOS_DB."""
    HUAWEI_RDS = "Huawei_RDS"
    """HUAWEI_RDS."""
    HUAWEI_COMPUTE = "Huawei_Compute"
    """HUAWEI_COMPUTE."""
    HEROKU_POSTGRE_SQL = "Heroku_PostgreSQL"
    """HEROKU_POSTGRE_SQL."""
    CRUNCHY_POSTGRE_SQL = "Crunchy_PostgreSQL"
    """CRUNCHY_POSTGRE_SQL."""
    APSARA_DB_RDS = "ApsaraDB_RDS"
    """APSARA_DB_RDS."""
    DIGITAL_OCEAN_DROPLETS = "Digital_Ocean_Droplets"
    """DIGITAL_OCEAN_DROPLETS."""
    DIGITAL_OCEAN_POSTGRE_SQL = "Digital_Ocean_PostgreSQL"
    """DIGITAL_OCEAN_POSTGRE_SQL."""
    SUPABASE_POSTGRE_SQL = "Supabase_PostgreSQL"
    """SUPABASE_POSTGRE_SQL."""


class SslMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SSL mode used by a migration. Default SSL mode for 'PostgreSQLSingleServer' is 'VerifyFull'.
    Default SSL mode for other source types is 'Prefer'.
    """

    PREFER = "Prefer"
    """PREFER."""
    REQUIRE = "Require"
    """REQUIRE."""
    VERIFY_CA = "VerifyCA"
    """VERIFY_CA."""
    VERIFY_FULL = "VerifyFull"
    """VERIFY_FULL."""


class StartDataMigration(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates if data migration must start right away."""

    TRUE = "True"
    """TRUE."""
    FALSE = "False"
    """FALSE."""


class StorageAutoGrow(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Flag to enable or disable the automatic growth of storage size of a server when available space
    is nearing zero and conditions allow for automatically growing storage size.
    """

    ENABLED = "Enabled"
    """ENABLED."""
    DISABLED = "Disabled"
    """DISABLED."""


class StorageAutoGrowthSupport(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates if storage autogrow is supported in this location. 'Enabled' means storage autogrow
    is supported. 'Disabled' stands for storage autogrow is not supported. Will be deprecated in
    the future. Look to Supported Features for 'StorageAutoGrowth'.
    """

    ENABLED = "Enabled"
    """ENABLED."""
    DISABLED = "Disabled"
    """DISABLED."""


class StorageType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of storage assigned to a server. Allowed values are Premium_LRS, PremiumV2_LRS, or
    UltraSSD_LRS. If not specified, it defaults to Premium_LRS.
    """

    PREMIUM_LRS = "Premium_LRS"
    """PREMIUM_LRS."""
    PREMIUM_V2_LRS = "PremiumV2_LRS"
    """PREMIUM_V2_LRS."""
    ULTRA_SSD_LRS = "UltraSSD_LRS"
    """ULTRA_SSD_LRS."""


class ThreatProtectionName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of ThreatProtectionName."""

    DEFAULT = "Default"
    """DEFAULT."""


class ThreatProtectionState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the state of the advanced threat protection, whether it is enabled, disabled, or a
    state has not been applied yet on the server.
    """

    ENABLED = "Enabled"
    """ENABLED."""
    DISABLED = "Disabled"
    """DISABLED."""


class TriggerCutover(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates if cutover must be triggered for the entire migration."""

    TRUE = "True"
    """TRUE."""
    FALSE = "False"
    """FALSE."""


class TuningOptionParameterEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The name of the tuning option."""

    INDEX = "index"
    """INDEX."""
    TABLE = "table"
    """TABLE."""


class ValidationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Validation status for migration."""

    FAILED = "Failed"
    """FAILED."""
    SUCCEEDED = "Succeeded"
    """SUCCEEDED."""
    WARNING = "Warning"
    """WARNING."""


class VirtualEndpointType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of endpoint for the virtual endpoints."""

    READ_WRITE = "ReadWrite"
    """READ_WRITE."""


class ZoneRedundantHighAvailabilityAndGeographicallyRedundantBackupSupport(  # pylint: disable=name-too-long
    str, Enum, metaclass=CaseInsensitiveEnumMeta
):
    """Indicates if high availability with zone redundancy is supported in conjunction with
    geographically redundant backups in this location. 'Enabled' means high availability with zone
    redundancy is supported in conjunction with geographically redundant backups is supported.
    'Disabled' stands for high availability with zone redundancy is supported in conjunction with
    geographically redundant backups is not supported. Will be deprecated in the future. Look to
    Supported Features for 'ZoneRedundantHaAndGeoBackup'.
    """

    ENABLED = "Enabled"
    """ENABLED."""
    DISABLED = "Disabled"
    """DISABLED."""


class ZoneRedundantHighAvailabilitySupport(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates if high availability with zone redundancy is supported in this location. 'Enabled'
    means high availability with zone redundancy is supported. 'Disabled' stands for high
    availability with zone redundancy is not supported. Will be deprecated in the future. Look to
    Supported Features for  'ZoneRedundantHa'.
    """

    ENABLED = "Enabled"
    """ENABLED."""
    DISABLED = "Disabled"
    """DISABLED."""
