# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.resource.deploymentstacks import DeploymentStacksClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-resource-deploymentstacks
# USAGE
    python deployment_stack_what_if_results_subscription_create.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = DeploymentStacksClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.deployment_stacks_what_if_results_at_subscription.begin_create_or_update(
        deployment_stacks_what_if_result_name="simpleDeploymentStackWhatIfResult",
        resource={
            "location": "eastus",
            "properties": {
                "actionOnUnmanage": {"managementGroups": "detach", "resourceGroups": "delete", "resources": "delete"},
                "denySettings": {"applyToChildScopes": False, "mode": "none"},
                "deploymentStackResourceId": "/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Resources/deploymentStacks/simpleDeploymentStack",
                "extensionConfigs": {"contoso": {"configOne": {"value": "config1Value"}, "configTwo": {"value": True}}},
                "parameters": {},
                "retentionInterval": "P7D",
                "templateLink": {"uri": "https://example.com/exampleTemplate.json"},
            },
        },
    ).result()
    print(response)


# x-ms-original-file: 2025-07-01/DeploymentStackWhatIfResultsSubscriptionCreate.json
if __name__ == "__main__":
    main()
