# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.security import SecurityCenter

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-security
# USAGE
    python create_jit_network_access_policy_example.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = SecurityCenter(
        credential=DefaultAzureCredential(),
        subscription_id="20ff7fc3-e762-44dd-bd96-b71116dcdc23",
    )

    response = client.jit_network_access_policies.create_or_update(
        resource_group_name="myRg1",
        asc_location="westeurope",
        jit_network_access_policy_name="default",
        body={
            "id": "/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Security/locations/westeurope/jitNetworkAccessPolicies/default",
            "kind": "Basic",
            "location": "westeurope",
            "name": "default",
            "properties": {
                "provisioningState": "Succeeded",
                "requests": [
                    {
                        "requestor": "barbara@contoso.com",
                        "startTimeUtc": "2018-05-17T08:06:45.5691611Z",
                        "virtualMachines": [
                            {
                                "id": "/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Compute/virtualMachines/vm1",
                                "ports": [
                                    {
                                        "allowedSourceAddressPrefix": "192.127.0.2",
                                        "endTimeUtc": "2018-05-17T09:06:45.5691611Z",
                                        "number": 3389,
                                        "status": "Initiated",
                                        "statusReason": "UserRequested",
                                    }
                                ],
                            }
                        ],
                    }
                ],
                "virtualMachines": [
                    {
                        "id": "/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Compute/virtualMachines/vm1",
                        "ports": [
                            {
                                "allowedSourceAddressPrefix": "*",
                                "maxRequestAccessDuration": "PT3H",
                                "number": 22,
                                "protocol": "*",
                            },
                            {
                                "allowedSourceAddressPrefix": "*",
                                "maxRequestAccessDuration": "PT3H",
                                "number": 3389,
                                "protocol": "*",
                            },
                        ],
                    }
                ],
            },
            "type": "Microsoft.Security/locations/jitNetworkAccessPolicies",
        },
    )
    print(response)


# x-ms-original-file: specification/security/resource-manager/Microsoft.Security/stable/2020-01-01/examples/JitNetworkAccessPolicies/CreateJitNetworkAccessPolicy_example.json
if __name__ == "__main__":
    main()
