% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_parameters.R
\name{bootstrap_parameters}
\alias{bootstrap_parameters}
\alias{bootstrap_parameters.default}
\title{Parameters bootstrapping}
\usage{
bootstrap_parameters(model, ...)

\method{bootstrap_parameters}{default}(
  model,
  iterations = 1000,
  centrality = "median",
  ci = 0.95,
  ci_method = "quantile",
  test = "p-value",
  ...
)
}
\arguments{
\item{model}{Statistical model.}

\item{...}{Arguments passed to other methods, like \code{\link[=bootstrap_model]{bootstrap_model()}} or
\code{\link[bayestestR:describe_posterior]{bayestestR::describe_posterior()}}.}

\item{iterations}{The number of draws to simulate/bootstrap.}

\item{centrality}{The point-estimates (centrality indices) to compute. Character
(vector) or list with one or more of these options: \code{"median"}, \code{"mean"}, \code{"MAP"}
(see \code{\link[bayestestR:map_estimate]{map_estimate()}}), \code{"trimmed"} (which is just \code{mean(x, trim = threshold)}),
\code{"mode"} or \code{"all"}.}

\item{ci}{Value or vector of probability of the CI (between 0 and 1)
to be estimated. Default to \code{0.95} (\verb{95\%}).}

\item{ci_method}{The type of index used for Credible Interval. Can be \code{"ETI"}
(default, see \code{\link[bayestestR:eti]{eti()}}), \code{"HDI"} (see \code{\link[bayestestR:hdi]{hdi()}}), \code{"BCI"} (see \code{\link[bayestestR:bci]{bci()}}),
\code{"SPI"} (see \code{\link[bayestestR:spi]{spi()}}), or \code{"SI"} (see \code{\link[bayestestR:si]{si()}}).}

\item{test}{The indices to compute. Character (vector) with one or more of
these options: \code{"p-value"} (or \code{"p"}), \code{"p_direction"} (or \code{"pd"}), \code{"rope"},
\code{"p_map"}, \code{"equivalence_test"} (or \code{"equitest"}), \code{"bayesfactor"} (or \code{"bf"})
or \code{"all"} to compute all tests. For each "test", the corresponding
\strong{bayestestR} function is called (e.g. \code{\link[bayestestR:rope]{bayestestR::rope()}} or
\code{\link[bayestestR:p_direction]{bayestestR::p_direction()}}) and its results included in the summary output.}
}
\value{
A data frame summarizing the bootstrapped parameters.
}
\description{
Compute bootstrapped parameters and their related indices such as Confidence Intervals (CI) and p-values.
}
\details{
This function first calls \code{\link[=bootstrap_model]{bootstrap_model()}} to generate
bootstrapped coefficients. The resulting replicated for each coefficient
are treated as "distribution", and is passed to \code{\link[bayestestR:describe_posterior]{bayestestR::describe_posterior()}}
to calculate the related indices defined in the \code{"test"} argument.

Note that that p-values returned here are estimated under the assumption of
\emph{translation equivariance}: that shape of the sampling distribution is
unaffected by the null being true or not. If this assumption does not hold,
p-values can be biased, and it is suggested to use proper permutation tests
to obtain non-parametric p-values.
}
\section{Using with \strong{emmeans}}{

The output can be passed directly to the various functions from the
\strong{emmeans} package, to obtain bootstrapped estimates, contrasts, simple
slopes, etc. and their confidence intervals. These can then be passed to
\code{model_parameter()} to obtain standard errors, p-values, etc. (see
example).

Note that that p-values returned here are estimated under the assumption of
\emph{translation equivariance}: that shape of the sampling distribution is
unaffected by the null being true or not. If this assumption does not hold,
p-values can be biased, and it is suggested to use proper permutation tests
to obtain non-parametric p-values.
}

\examples{
\dontshow{if (require("boot", quietly = TRUE) && require("emmeans", quietly = TRUE)) withAutoprint(\{ # examplesIf}
\donttest{
set.seed(2)
model <- lm(Sepal.Length ~ Species * Petal.Width, data = iris)
b <- bootstrap_parameters(model)
print(b)

# different type of bootstrapping
set.seed(2)
b <- bootstrap_parameters(model, type = "balanced")
print(b)

est <- emmeans::emmeans(b, trt.vs.ctrl ~ Species)
print(model_parameters(est))
}
\dontshow{\}) # examplesIf}
}
\references{
Davison, A. C., & Hinkley, D. V. (1997). Bootstrap methods and their
application (Vol. 1). Cambridge university press.
}
\seealso{
\code{\link[=bootstrap_model]{bootstrap_model()}}, \code{\link[=simulate_parameters]{simulate_parameters()}}, \code{\link[=simulate_model]{simulate_model()}}
}
