# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `mocha` gem.
# Please instead update this file by running `bin/tapioca gem mocha`.


# source://mocha//lib/mocha/inspect.rb#56
class Array
  include ::Enumerable
  include ::Mocha::Inspect::ArrayMethods
end

class Class < ::Module
  include ::Mocha::ClassMethods
end

# source://mocha//lib/mocha/inspect.rb#68
class Date
  include ::Comparable
  include ::Mocha::Inspect::DateMethods
end

# source://mocha//lib/mocha/inspect.rb#60
class Hash
  include ::Enumerable
  include ::Mocha::Inspect::HashMethods
end

class Minitest::Test < ::Minitest::Runnable
  include ::Mocha::ParameterMatchers
  include ::Mocha::Hooks
  include ::Mocha::API
  include ::Mocha::Integration::Minitest::Adapter
end

# source://mocha//lib/mocha/version.rb#1
module Mocha
  class << self
    # @private
    #
    # source://mocha//lib/mocha/configuration.rb#25
    def configuration; end

    # Allows setting of configuration options. See {Configuration} for the available options.
    #
    # Typically the configuration is set globally in a +test_helper.rb+ or +spec_helper.rb+ file.
    #
    # @example Setting multiple configuration options
    #   Mocha.configure do |c|
    #   c.stubbing_method_unnecessarily = :prevent
    #   c.stubbing_method_on_non_mock_object = :warn
    #   c.stubbing_method_on_nil = :allow
    #   end
    # @see Configuration
    # @yieldparam configuration [Configuration] the configuration for modification
    #
    # source://mocha//lib/mocha/configuration.rb#20
    def configure; end
  end
end

# Methods added to +Test::Unit::TestCase+, +Minitest::Unit::TestCase+ or equivalent.
# The mock creation methods are {#mock}, {#stub} and {#stub_everything}, all of which return a #{Mock}
# which can be further modified by {Mock#responds_like} and {Mock#responds_like_instance_of} methods,
# both of which return a {Mock}, too, and can therefore, be chained to the original creation methods.
#
# {Mock#responds_like} and {Mock#responds_like_instance_of} force the mock to indicate what it is
# supposed to be mocking, thus making it a safer verifying mock. They check that the underlying +responder+
# will actually respond to the methods being stubbed, throwing a +NoMethodError+ upon invocation otherwise.
#
# @example Verifying mock using {Mock#responds_like_instance_of}
#   class Sheep
#   def initialize
#   raise "some awkward code we don't want to call"
#   end
#   def chew(grass); end
#   end
#
#   sheep = mock('sheep').responds_like_instance_of(Sheep)
#   sheep.expects(:chew)
#   sheep.expects(:foo)
#   sheep.respond_to?(:chew) # => true
#   sheep.respond_to?(:foo) # => false
#   sheep.chew
#   sheep.foo # => raises NoMethodError exception
#
# source://mocha//lib/mocha/api.rb#34
module Mocha::API
  include ::Mocha::ParameterMatchers
  include ::Mocha::Hooks

  # Builds a new mock object
  #
  # @example Using expected_methods_vs_return_values Hash to setup expectations.
  #   def test_motor_starts_and_stops
  #   motor = mock('motor', start: true, stop: true)
  #   assert motor.start
  #   assert motor.stop
  #   # an error will be raised unless both Motor#start and Motor#stop have been called
  #   end
  # @overload mock
  # @overload mock
  # @overload mock
  # @return [Mock] a new mock object
  #
  # source://mocha//lib/mocha/api.rb#69
  def mock(*arguments); end

  # Builds a new sequence which can be used to constrain the order in which expectations can occur.
  #
  # Specify that an expected invocation must occur within a named {Sequence} by calling {Expectation#in_sequence}
  # on each expectation or by passing a block within which all expectations should be constrained by the {Sequence}.
  #
  # @example Ensure methods across multiple objects are invoked in correct order.
  #   sequence = sequence(:task_order)
  #
  #   task_one = mock("task_one")
  #   task_two = mock("task_two")
  #
  #   task_one.expects(:execute).in_sequence(sequence)
  #   task_two.expects(:execute).in_sequence(sequence)
  #
  #   task_one.execute
  #   task_two.execute
  # @example Ensure methods on egg are invoked in correct order.
  #   breakfast = sequence('breakfast')
  #
  #   egg = mock('egg')
  #   egg.expects(:crack).in_sequence(breakfast)
  #   egg.expects(:fry).in_sequence(breakfast)
  #   egg.expects(:eat).in_sequence(breakfast)
  # @example Ensure methods on egg are invoked in the correct order using a block.
  #   egg = mock('egg')
  #   sequence('breakfast') do
  #   egg.expects(:crack)
  #   egg.expects(:fry)
  #   egg.expects(:eat)
  #   end
  # @param name [String] name of sequence
  # @return [Sequence] a new sequence
  # @see Expectation#in_sequence
  # @yield optional block within which expectations should be constrained by the sequence
  #
  # source://mocha//lib/mocha/api.rb#170
  def sequence(name); end

  # Builds a new state machine which can be used to constrain the order in which expectations can occur.
  #
  # Specify the initial state of the state machine by using {StateMachine#starts_as}.
  #
  # Specify that an expected invocation should change the state of the state machine by using {Expectation#then}.
  #
  # Specify that an expected invocation should be constrained to occur within a particular +state+ by using {Expectation#when}.
  #
  # A test can contain multiple state machines.
  #
  # @example Constrain expected invocations to occur in particular states.
  #   power = states('power').starts_as('off')
  #
  #   radio = mock('radio')
  #   radio.expects(:switch_on).then(power.is('on'))
  #   radio.expects(:select_channel).with('BBC Radio 4').when(power.is('on'))
  #   radio.expects(:adjust_volume).with(+5).when(power.is('on'))
  #   radio.expects(:select_channel).with('BBC World Service').when(power.is('on'))
  #   radio.expects(:adjust_volume).with(-5).when(power.is('on'))
  #   radio.expects(:switch_off).then(power.is('off'))
  # @param name [String] name of state machine
  # @return [StateMachine] a new state machine
  # @see Expectation#then
  # @see Expectation#when
  # @see StateMachine
  #
  # source://mocha//lib/mocha/api.rb#207
  def states(name); end

  # Builds a new mock object
  #
  # @example Using stubbed_methods_vs_return_values Hash to setup stubbed methods.
  #   def test_motor_starts_and_stops
  #   motor = stub('motor', start: true, stop: true)
  #   assert motor.start
  #   assert motor.stop
  #   # an error will not be raised even if either Motor#start or Motor#stop has not been called
  #   end
  # @overload stub
  # @overload stub
  # @overload stub
  # @return [Mock] a new mock object
  #
  # source://mocha//lib/mocha/api.rb#96
  def stub(*arguments); end

  # Builds a mock object that accepts calls to any method. By default it will return +nil+ for any method call.
  #
  # @example Ignore invocations of irrelevant methods.
  #   def test_motor_stops
  #   motor = stub_everything('motor', stop: true)
  #   assert_nil motor.irrelevant_method_1 # => no error raised
  #   assert_nil motor.irrelevant_method_2 # => no error raised
  #   assert motor.stop
  #   end
  # @overload stub_everything
  # @overload stub_everything
  # @overload stub_everything
  # @return [Mock] a new mock object
  #
  # source://mocha//lib/mocha/api.rb#123
  def stub_everything(*arguments); end

  class << self
    # @private
    # @private
    #
    # source://mocha//lib/mocha/api.rb#45
    def extended(mod); end

    # @private
    # @private
    #
    # source://mocha//lib/mocha/api.rb#39
    def included(_mod); end
  end
end

# source://mocha//lib/mocha/any_instance_method.rb#4
class Mocha::AnyInstanceMethod < ::Mocha::StubbedMethod
  private

  # source://mocha//lib/mocha/any_instance_method.rb#7
  def mock_owner; end

  # source://mocha//lib/mocha/any_instance_method.rb#15
  def original_method_owner; end

  # source://mocha//lib/mocha/any_instance_method.rb#11
  def stubbee_method(method_name); end
end

# source://mocha//lib/mocha/receivers.rb#19
class Mocha::AnyInstanceReceiver
  # @return [AnyInstanceReceiver] a new instance of AnyInstanceReceiver
  #
  # source://mocha//lib/mocha/receivers.rb#20
  def initialize(klass); end

  # source://mocha//lib/mocha/receivers.rb#24
  def mocks; end
end

# source://mocha//lib/mocha/argument_iterator.rb#2
class Mocha::ArgumentIterator
  # @return [ArgumentIterator] a new instance of ArgumentIterator
  #
  # source://mocha//lib/mocha/argument_iterator.rb#3
  def initialize(argument); end

  # source://mocha//lib/mocha/argument_iterator.rb#7
  def each; end
end

# source://mocha//lib/mocha/backtrace_filter.rb#2
class Mocha::BacktraceFilter
  # @return [BacktraceFilter] a new instance of BacktraceFilter
  #
  # source://mocha//lib/mocha/backtrace_filter.rb#5
  def initialize(lib_directory = T.unsafe(nil)); end

  # source://mocha//lib/mocha/backtrace_filter.rb#9
  def filtered(backtrace); end
end

# source://mocha//lib/mocha/backtrace_filter.rb#3
Mocha::BacktraceFilter::LIB_DIRECTORY = T.let(T.unsafe(nil), String)

# source://mocha//lib/mocha/block_matcher.rb#2
module Mocha::BlockMatchers; end

# source://mocha//lib/mocha/block_matcher.rb#11
class Mocha::BlockMatchers::BlockGiven
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/block_matcher.rb#12
  def match?(actual_block); end

  # source://mocha//lib/mocha/block_matcher.rb#16
  def mocha_inspect; end
end

# source://mocha//lib/mocha/block_matcher.rb#21
class Mocha::BlockMatchers::NoBlockGiven
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/block_matcher.rb#22
  def match?(actual_block); end

  # source://mocha//lib/mocha/block_matcher.rb#26
  def mocha_inspect; end
end

# source://mocha//lib/mocha/block_matcher.rb#3
class Mocha::BlockMatchers::OptionalBlock
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/block_matcher.rb#4
  def match?(_actual_block); end

  # source://mocha//lib/mocha/block_matcher.rb#8
  def mocha_inspect; end
end

# source://mocha//lib/mocha/cardinality.rb#2
class Mocha::Cardinality
  # @return [Cardinality] a new instance of Cardinality
  #
  # source://mocha//lib/mocha/cardinality.rb#5
  def initialize(required = T.unsafe(nil), maximum = T.unsafe(nil)); end

  # source://mocha//lib/mocha/cardinality.rb#29
  def <<(invocation); end

  # source://mocha//lib/mocha/cardinality.rb#83
  def actual_invocations; end

  # @return [Boolean]
  #
  # source://mocha//lib/mocha/cardinality.rb#53
  def allowed_any_number_of_times?; end

  # source://mocha//lib/mocha/cardinality.rb#62
  def anticipated_times; end

  # source://mocha//lib/mocha/cardinality.rb#14
  def at_least(count); end

  # source://mocha//lib/mocha/cardinality.rb#18
  def at_most(count); end

  # source://mocha//lib/mocha/cardinality.rb#10
  def exactly(count); end

  # @return [Boolean]
  #
  # source://mocha//lib/mocha/cardinality.rb#33
  def invocations_allowed?; end

  # @return [Boolean]
  #
  # source://mocha//lib/mocha/cardinality.rb#37
  def invocations_never_allowed?; end

  # source://mocha//lib/mocha/cardinality.rb#79
  def invoked_times; end

  # @return [Boolean]
  #
  # source://mocha//lib/mocha/cardinality.rb#45
  def needs_verifying?; end

  # @return [Boolean]
  #
  # source://mocha//lib/mocha/cardinality.rb#41
  def satisfied?; end

  # source://mocha//lib/mocha/cardinality.rb#22
  def times(range_or_count); end

  # @return [Boolean]
  #
  # source://mocha//lib/mocha/cardinality.rb#57
  def used?; end

  # @return [Boolean]
  #
  # source://mocha//lib/mocha/cardinality.rb#49
  def verified?; end

  protected

  # source://mocha//lib/mocha/cardinality.rb#91
  def count(number); end

  # @return [Boolean]
  #
  # source://mocha//lib/mocha/cardinality.rb#106
  def infinite?(number); end

  # Returns the value of attribute maximum.
  #
  # source://mocha//lib/mocha/cardinality.rb#89
  def maximum; end

  # Returns the value of attribute required.
  #
  # source://mocha//lib/mocha/cardinality.rb#89
  def required; end

  # source://mocha//lib/mocha/cardinality.rb#100
  def update(required, maximum); end
end

# source://mocha//lib/mocha/cardinality.rb#3
Mocha::Cardinality::INFINITY = T.let(T.unsafe(nil), Float)

# source://mocha//lib/mocha/central.rb#2
class Mocha::Central
  # @return [Central] a new instance of Central
  #
  # source://mocha//lib/mocha/central.rb#20
  def initialize; end

  # source://mocha//lib/mocha/central.rb#24
  def stub(method); end

  # Returns the value of attribute stubba_methods.
  #
  # source://mocha//lib/mocha/central.rb#18
  def stubba_methods; end

  # Sets the attribute stubba_methods
  #
  # @param value the value to set the attribute stubba_methods to.
  #
  # source://mocha//lib/mocha/central.rb#18
  def stubba_methods=(_arg0); end

  # source://mocha//lib/mocha/central.rb#30
  def unstub(method); end

  # source://mocha//lib/mocha/central.rb#36
  def unstub_all; end
end

# source://mocha//lib/mocha/central.rb#3
class Mocha::Central::Null < ::Mocha::Central
  # @return [Null] a new instance of Null
  #
  # source://mocha//lib/mocha/central.rb#4
  def initialize(&block); end

  # source://mocha//lib/mocha/central.rb#9
  def stub(*_arg0); end

  # source://mocha//lib/mocha/central.rb#13
  def unstub(*_arg0); end
end

# source://mocha//lib/mocha/change_state_side_effect.rb#2
class Mocha::ChangeStateSideEffect
  # @return [ChangeStateSideEffect] a new instance of ChangeStateSideEffect
  #
  # source://mocha//lib/mocha/change_state_side_effect.rb#3
  def initialize(state); end

  # source://mocha//lib/mocha/change_state_side_effect.rb#11
  def mocha_inspect; end

  # source://mocha//lib/mocha/change_state_side_effect.rb#7
  def perform; end
end

# Methods added to all classes to allow mocking and stubbing on real (i.e. non-mock) objects.
#
# source://mocha//lib/mocha/class_methods.rb#6
module Mocha::ClassMethods
  # @private
  #
  # source://mocha//lib/mocha/class_methods.rb#60
  def __method_exists__?(method, include_public_methods = T.unsafe(nil)); end

  # @private
  #
  # source://mocha//lib/mocha/class_methods.rb#54
  def __method_visibility__(method, include_public_methods = T.unsafe(nil)); end

  # @example Return false to invocation of +Product#save+ for any instance of +Product+.
  #   Product.any_instance.stubs(:save).returns(false)
  #   product_1 = Product.new
  #   assert_equal false, product_1.save
  #   product_2 = Product.new
  #   assert_equal false, product_2.save
  # @raise [StubbingError] if attempting to stub method which is not allowed.
  # @return [Mock] a mock object which will detect calls to any instance of this class.
  #
  # source://mocha//lib/mocha/class_methods.rb#45
  def any_instance; end
end

# @private
#
# source://mocha//lib/mocha/class_methods.rb#8
class Mocha::ClassMethods::AnyInstance
  # @return [AnyInstance] a new instance of AnyInstance
  #
  # source://mocha//lib/mocha/class_methods.rb#9
  def initialize(klass); end

  # source://mocha//lib/mocha/class_methods.rb#13
  def mocha(instantiate = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://mocha//lib/mocha/class_methods.rb#29
  def respond_to?(symbol, include_all = T.unsafe(nil)); end

  # source://mocha//lib/mocha/class_methods.rb#25
  def stubba_class; end

  # source://mocha//lib/mocha/class_methods.rb#21
  def stubba_method; end

  # Returns the value of attribute stubba_object.
  #
  # source://mocha//lib/mocha/class_methods.rb#33
  def stubba_object; end
end

# This class provides a number of ways to configure the library.
#
# Typically the configuration is set globally in a +test_helper.rb+ or +spec_helper.rb+ file.
#
# @example Setting multiple configuration options
#   Mocha.configure do |c|
#   c.stubbing_method_unnecessarily = :prevent
#   c.stubbing_method_on_non_mock_object = :warn
#   c.stubbing_method_on_nil = :allow
#   end
#
# source://mocha//lib/mocha/configuration.rb#40
class Mocha::Configuration
  # @private
  # @return [Configuration] a new instance of Configuration
  #
  # source://mocha//lib/mocha/configuration.rb#56
  def initialize(options = T.unsafe(nil)); end

  # Display matching invocations alongside expectations on Mocha-related test failure.
  #
  # @example Enable display of matching invocations
  #   Mocha.configure do |c|
  #   c.display_matching_invocations_on_failure = true
  #   end
  #
  #   foo = mock('foo')
  #   foo.expects(:bar)
  #   foo.stubs(:baz).returns('baz').raises(RuntimeError).throws(:tag, 'value')
  #
  #   foo.baz(1, 2)
  #   assert_raises(RuntimeError) { foo.baz(3, 4) }
  #   assert_throws(:tag) { foo.baz(5, 6) }
  #
  #   not all expectations were satisfied
  #   unsatisfied expectations:
  #   - expected exactly once, invoked never: #<Mock:foo>.bar
  #   satisfied expectations:
  #   - allowed any number of times, invoked 3 times: #<Mock:foo>.baz(any_parameters)
  #   - #<Mock:foo>.baz(1, 2) # => "baz"
  #   - #<Mock:foo>.baz(3, 4) # => raised RuntimeError
  #   - #<Mock:foo>.baz(5, 6) # => threw (:tag, "value")
  # @param value [Boolean] +true+ to enable display of matching invocations; disabled by default.
  #
  # source://mocha//lib/mocha/configuration.rb#251
  def display_matching_invocations_on_failure=(value); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/configuration.rb#256
  def display_matching_invocations_on_failure?; end

  # @private
  #
  # source://mocha//lib/mocha/configuration.rb#66
  def merge(other); end

  # Perform strict keyword argument comparison. Only supported in Ruby >= v2.7.
  #
  # When this option is set to +false+ a positional +Hash+ and a set of keyword arguments are treated the same during comparison, which can lead to misleading passing tests in Ruby >= v3.0 (see examples below). However, a deprecation warning will be displayed if a positional +Hash+ matches a set of keyword arguments or vice versa. This is because {#strict_keyword_argument_matching=} will default to +true+ in the future.
  #
  # For more details on keyword arguments in Ruby v3, refer to {https://www.ruby-lang.org/en/news/2019/12/12/separation-of-positional-and-keyword-arguments-in-ruby-3-0 this article}.
  #
  # Note that +Hash+-related matchers such as {ParameterMatchers#has_value} or {ParameterMatchers#has_key} will still treat a positional +Hash+ and a set of keyword arguments the same, so misleading passing tests are still possible when they are used.
  #
  # This configuration option is +false+ by default to enable gradual adoption, but will be +true+ by default in the future.
  #
  # @example Loose keyword argument matching (default)
  #
  #   class Example
  #   def foo(a, bar:); end
  #   end
  #
  #   example = Example.new
  #   example.expects(:foo).with('a', bar: 'b')
  #   example.foo('a', { bar: 'b' })
  #   # This passes the test, but would result in an ArgumentError in practice
  # @example Strict keyword argument matching
  #
  #   Mocha.configure do |c|
  #   c.strict_keyword_argument_matching = true
  #   end
  #
  #   class Example
  #   def foo(a, bar:); end
  #   end
  #
  #   example = Example.new
  #   example.expects(:foo).with('a', bar: 'b')
  #   example.foo('a', { bar: 'b' })
  #   # This now fails as expected
  # @param value [Boolean] +true+ to enable strict keyword argument matching; +false+ by default.
  #
  # source://mocha//lib/mocha/configuration.rb#297
  def strict_keyword_argument_matching=(value); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/configuration.rb#303
  def strict_keyword_argument_matching?; end

  # @private
  #
  # source://mocha//lib/mocha/configuration.rb#222
  def stubbing_method_on_nil; end

  # Configure whether stubbing methods on the +nil+ object is allowed.
  #
  # This is usually done accidentally, but there might be rare cases where it is intended.
  #
  # This option only works for Ruby < v2.2.0. In later versions of Ruby +nil+ is frozen and so a {StubbingError} will be raised if you attempt to stub a method on +nil+.
  #
  # When +value+ is +:allow+, do nothing.
  # When +value+ is +:warn+, display a warning.
  # When +value+ is +:prevent+, raise a {StubbingError}. This is the default.
  #
  # @deprecated This method is deprecated and will be removed in a future release. +nil+ is frozen in Ruby >= v2.2 and Mocha will be dropping support for Ruby v2.1. At that point it won't be possible to stub methods on +nil+ any more.
  # @param value [Symbol] one of +:allow+, +:warn+, +:prevent+.
  #
  # source://mocha//lib/mocha/configuration.rb#212
  def stubbing_method_on_nil=(value); end

  # @private
  #
  # source://mocha//lib/mocha/configuration.rb#128
  def stubbing_method_on_non_mock_object; end

  # Configure whether stubbing methods on non-mock objects is allowed.
  #
  # If you like the idea of {http://www.jmock.org/oopsla2004.pdf mocking roles not objects} and {http://www.mockobjects.com/2007/04/test-smell-mocking-concrete-classes.html you don't like stubbing concrete classes}, this is the setting for you. However, while this restriction makes a lot of sense in Java with its {http://java.sun.com/docs/books/tutorial/java/concepts/interface.html explicit interfaces}, it may be moot in Ruby where roles are probably best represented as Modules.
  #
  # When +value+ is +:allow+, do nothing. This is the default.
  # When +value+ is +:warn+, display a warning.
  # When +value+ is +:prevent+, raise a {StubbingError}.
  #
  # @example Preventing stubbing of a method on a non-mock object
  #   Mocha.configure do |c|
  #   c.stubbing_method_on_non_mock_object = :prevent
  #   end
  #
  #   class Example
  #   def example_method; end
  #   end
  #
  #   example = Example.new
  #   example.stubs(:example_method)
  #   # => Mocha::StubbingError: stubbing method on non-mock object:
  #   # =>   #<Example:0x593620>.example_method
  # @param value [Symbol] one of +:allow+, +:warn+, +:prevent+.
  #
  # source://mocha//lib/mocha/configuration.rb#123
  def stubbing_method_on_non_mock_object=(value); end

  # @private
  #
  # source://mocha//lib/mocha/configuration.rb#95
  def stubbing_method_unnecessarily; end

  # Configure whether stubbing methods unnecessarily is allowed.
  #
  # This is useful for identifying unused stubs. Unused stubs are often accidentally introduced when code is {http://martinfowler.com/bliki/DefinitionOfRefactoring.html refactored}.
  #
  # When +value+ is +:allow+, do nothing. This is the default.
  # When +value+ is +:warn+, display a warning.
  # When +value+ is +:prevent+, raise a {StubbingError}.
  #
  # @example Preventing unnecessary stubbing of a method
  #   Mocha.configure do |c|
  #   c.stubbing_method_unnecessarily = :prevent
  #   end
  #
  #   example = mock('example')
  #   example.stubs(:unused_stub)
  #   # => Mocha::StubbingError: stubbing method unnecessarily:
  #   # =>   #<Mock:example>.unused_stub(any_parameters)
  # @param value [Symbol] one of +:allow+, +:warn+, +:prevent+.
  #
  # source://mocha//lib/mocha/configuration.rb#90
  def stubbing_method_unnecessarily=(value); end

  # @private
  #
  # source://mocha//lib/mocha/configuration.rb#161
  def stubbing_non_existent_method; end

  # Configure whether stubbing of non-existent methods is allowed.
  #
  # This is useful if you want to ensure that methods you're mocking really exist. A common criticism of unit tests with mock objects is that such a test may (incorrectly) pass when an equivalent non-mocking test would (correctly) fail. While you should always have some integration tests, particularly for critical business functionality, this Mocha configuration setting should catch scenarios when mocked methods and real methods have become misaligned.
  #
  # When +value+ is +:allow+, do nothing. This is the default.
  # When +value+ is +:warn+, display a warning.
  # When +value+ is +:prevent+, raise a {StubbingError}.
  #
  # @example Preventing stubbing of a non-existent method
  #
  #   Mocha.configure do |c|
  #   c.stubbing_non_existent_method = :prevent
  #   end
  #
  #   class Example
  #   end
  #
  #   example = Example.new
  #   example.stubs(:method_that_doesnt_exist)
  #   # => Mocha::StubbingError: stubbing non-existent method:
  #   # =>   #<Example:0x593760>.method_that_doesnt_exist
  # @param value [Symbol] one of +:allow+, +:warn+, +:prevent+.
  #
  # source://mocha//lib/mocha/configuration.rb#156
  def stubbing_non_existent_method=(value); end

  # @private
  #
  # source://mocha//lib/mocha/configuration.rb#195
  def stubbing_non_public_method; end

  # Configure whether stubbing of non-public methods is allowed.
  #
  # Many people think that it's good practice only to mock public methods. This is one way to prevent your tests being too tightly coupled to the internal implementation of a class. Such tests tend to be very brittle and not much use when refactoring.
  #
  # When +value+ is +:allow+, do nothing. This is the default.
  # When +value+ is +:warn+, display a warning.
  # When +value+ is +:prevent+, raise a {StubbingError}.
  #
  # @example Preventing stubbing of a non-public method
  #   Mocha.configure do |c|
  #   c.stubbing_non_public_method = :prevent
  #   end
  #
  #   class Example
  #   def internal_method; end
  #   private :internal_method
  #   end
  #
  #   example = Example.new
  #   example.stubs(:internal_method)
  #   # => Mocha::StubbingError: stubbing non-public method:
  #   # =>   #<Example:0x593530>.internal_method
  # @param value [Symbol] one of +:allow+, +:warn+, +:prevent+.
  #
  # source://mocha//lib/mocha/configuration.rb#190
  def stubbing_non_public_method=(value); end

  protected

  # Returns the value of attribute options.
  #
  # source://mocha//lib/mocha/configuration.rb#52
  def options; end

  private

  # @private
  #
  # source://mocha//lib/mocha/configuration.rb#61
  def initialize_copy(other); end

  class << self
    # @private
    #
    # source://mocha//lib/mocha/configuration.rb#334
    def configuration; end

    # Temporarily modify {Configuration} options.
    #
    # The supplied +temporary_options+ will override the current configuration for the duration of the supplied block.
    # The configuration will be returned to its original state when the block returns.
    #
    # @example Temporarily allow stubbing of +nil+
    #   Mocha::Configuration.override(stubbing_method_on_nil: :allow) do
    #   nil.stubs(:foo)
    #   end
    # @param temporary_options [Hash] the configuration options to apply for the duration of the block.
    # @yield block during which the configuration change will be in force.
    #
    # source://mocha//lib/mocha/configuration.rb#325
    def override(temporary_options); end

    # @private
    #
    # source://mocha//lib/mocha/configuration.rb#309
    def reset_configuration; end

    private

    # @private
    #
    # source://mocha//lib/mocha/configuration.rb#341
    def change_config(action, new_value, &block); end

    # @private
    #
    # source://mocha//lib/mocha/configuration.rb#350
    def temporarily_change_config(action, new_value); end
  end
end

# @private
#
# source://mocha//lib/mocha/configuration.rb#42
Mocha::Configuration::DEFAULTS = T.let(T.unsafe(nil), Hash)

# source://mocha//lib/mocha/debug.rb#2
module Mocha::Debug
  class << self
    # source://mocha//lib/mocha/debug.rb#5
    def puts(message); end
  end
end

# source://mocha//lib/mocha/debug.rb#3
Mocha::Debug::OPTIONS = T.let(T.unsafe(nil), Array)

# source://mocha//lib/mocha/names.rb#32
class Mocha::DefaultName
  # @return [DefaultName] a new instance of DefaultName
  #
  # source://mocha//lib/mocha/names.rb#33
  def initialize(mock); end

  # source://mocha//lib/mocha/names.rb#37
  def mocha_inspect; end
end

# source://mocha//lib/mocha/receivers.rb#36
class Mocha::DefaultReceiver
  # @return [DefaultReceiver] a new instance of DefaultReceiver
  #
  # source://mocha//lib/mocha/receivers.rb#37
  def initialize(mock); end

  # source://mocha//lib/mocha/receivers.rb#41
  def mocks; end
end

# source://mocha//lib/mocha/deprecation.rb#4
class Mocha::Deprecation
  class << self
    # Returns the value of attribute messages.
    #
    # source://mocha//lib/mocha/deprecation.rb#6
    def messages; end

    # Sets the attribute messages
    #
    # @param value the value to set the attribute messages to.
    #
    # source://mocha//lib/mocha/deprecation.rb#6
    def messages=(_arg0); end

    # Returns the value of attribute mode.
    #
    # source://mocha//lib/mocha/deprecation.rb#6
    def mode; end

    # Sets the attribute mode
    #
    # @param value the value to set the attribute mode to.
    #
    # source://mocha//lib/mocha/deprecation.rb#6
    def mode=(_arg0); end

    # source://mocha//lib/mocha/deprecation.rb#8
    def warning(*messages); end
  end
end

# source://mocha//lib/mocha/detection/minitest.rb#2
module Mocha::Detection; end

# source://mocha//lib/mocha/detection/minitest.rb#3
module Mocha::Detection::Minitest
  class << self
    # source://mocha//lib/mocha/detection/minitest.rb#4
    def testcase; end

    # source://mocha//lib/mocha/detection/minitest.rb#12
    def version; end
  end
end

# @private
#
# source://mocha//lib/mocha/error_with_filtered_backtrace.rb#5
class Mocha::ErrorWithFilteredBacktrace < ::StandardError
  # @private
  # @return [ErrorWithFilteredBacktrace] a new instance of ErrorWithFilteredBacktrace
  #
  # source://mocha//lib/mocha/error_with_filtered_backtrace.rb#7
  def initialize(message = T.unsafe(nil), backtrace = T.unsafe(nil)); end
end

# source://mocha//lib/mocha/exception_raiser.rb#2
class Mocha::ExceptionRaiser
  # @return [ExceptionRaiser] a new instance of ExceptionRaiser
  #
  # source://mocha//lib/mocha/exception_raiser.rb#3
  def initialize(exception, message); end

  # @raise [@exception]
  #
  # source://mocha//lib/mocha/exception_raiser.rb#8
  def evaluate(invocation); end
end

# Methods on expectations returned from {Mock#expects}, {Mock#stubs}, {ObjectMethods#expects} and {ObjectMethods#stubs}.
#
# source://mocha//lib/mocha/expectation.rb#19
class Mocha::Expectation
  # @private
  # @return [Expectation] a new instance of Expectation
  #
  # source://mocha//lib/mocha/expectation.rb#618
  def initialize(mock, expected_method_name, backtrace = T.unsafe(nil)); end

  # @private
  #
  # source://mocha//lib/mocha/expectation.rb#637
  def add_in_sequence_ordering_constraint(sequence); end

  # @private
  #
  # source://mocha//lib/mocha/expectation.rb#632
  def add_ordering_constraint(ordering_constraint); end

  # @private
  #
  # source://mocha//lib/mocha/expectation.rb#642
  def add_side_effect(side_effect); end

  # Modifies expectation so that the expected method must be called at least a +minimum_number_of_times+.
  #
  # @example Expected method must be called at least twice.
  #   object = mock()
  #   object.expects(:expected_method).at_least(2)
  #   3.times { object.expected_method }
  #   # => verify succeeds
  #
  #   object = mock()
  #   object.expects(:expected_method).at_least(2)
  #   object.expected_method
  #   # => verify fails
  # @param minimum_number_of_times [Integer] minimum number of expected invocations.
  # @return [Expectation] the same expectation, thereby allowing invocations of other {Expectation} methods to be chained.
  #
  # source://mocha//lib/mocha/expectation.rb#134
  def at_least(minimum_number_of_times); end

  # Modifies expectation so that the expected method must be called at least once.
  #
  # @example Expected method must be called at least once.
  #   object = mock()
  #   object.expects(:expected_method).at_least_once
  #   object.expected_method
  #   # => verify succeeds
  #
  #   object = mock()
  #   object.expects(:expected_method).at_least_once
  #   # => verify fails
  # @return [Expectation] the same expectation, thereby allowing invocations of other {Expectation} methods to be chained.
  #
  # source://mocha//lib/mocha/expectation.rb#152
  def at_least_once; end

  # Modifies expectation so that the expected method must be called at most a +maximum_number_of_times+.
  #
  # @example Expected method must be called at most twice.
  #   object = mock()
  #   object.expects(:expected_method).at_most(2)
  #   2.times { object.expected_method }
  #   # => verify succeeds
  #
  #   object = mock()
  #   object.expects(:expected_method).at_most(2)
  #   3.times { object.expected_method } # => unexpected invocation
  # @param maximum_number_of_times [Integer] maximum number of expected invocations.
  # @return [Expectation] the same expectation, thereby allowing invocations of other {Expectation} methods to be chained.
  #
  # source://mocha//lib/mocha/expectation.rb#170
  def at_most(maximum_number_of_times); end

  # Modifies expectation so that the expected method must be called at most once.
  #
  # @example Expected method must be called at most once.
  #   object = mock()
  #   object.expects(:expected_method).at_most_once
  #   object.expected_method
  #   # => verify succeeds
  #
  #   object = mock()
  #   object.expects(:expected_method).at_most_once
  #   2.times { object.expected_method } # => unexpected invocation
  # @return [Expectation] the same expectation, thereby allowing invocations of other {Expectation} methods to be chained.
  #
  # source://mocha//lib/mocha/expectation.rb#188
  def at_most_once; end

  # @private
  #
  # source://mocha//lib/mocha/expectation.rb#615
  def backtrace; end

  # @private
  #
  # source://mocha//lib/mocha/expectation.rb#730
  def definition_location; end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/expectation.rb#652
  def in_correct_order?; end

  # Constrains the expectation so that it must be invoked at the current point in the +sequence+.
  #
  # To expect a sequence of invocations, write the expectations in order and add the +in_sequence(sequence)+ clause to each one.
  #
  # Expectations in a +sequence+ can have any invocation count.
  #
  # If an expectation in a sequence is stubbed, rather than expected, it can be skipped in the +sequence+.
  #
  # An expected method can appear in multiple sequences.
  #
  # @example Ensure methods are invoked in a specified order.
  #   breakfast = sequence('breakfast')
  #
  #   egg = mock('egg')
  #   egg.expects(:crack).in_sequence(breakfast)
  #   egg.expects(:fry).in_sequence(breakfast)
  #   egg.expects(:eat).in_sequence(breakfast)
  # @param sequence [Sequence] sequence in which expected method should appear.
  # @param sequences [*Array<Sequence>] more sequences in which expected method should appear.
  # @return [Expectation] the same expectation, thereby allowing invocations of other {Expectation} methods to be chained.
  # @see API#sequence
  #
  # source://mocha//lib/mocha/expectation.rb#609
  def in_sequence(sequence, *sequences); end

  # @private
  #
  # source://mocha//lib/mocha/expectation.rb#706
  def inspect; end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/expectation.rb#673
  def invocations_allowed?; end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/expectation.rb#678
  def invocations_never_allowed?; end

  # @private
  #
  # source://mocha//lib/mocha/expectation.rb#688
  def invoke(invocation); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/expectation.rb#667
  def match?(invocation, ignoring_order: T.unsafe(nil)); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/expectation.rb#662
  def matches_method?(method_name); end

  # @private
  #
  # source://mocha//lib/mocha/expectation.rb#723
  def method_signature; end

  # @private
  #
  # source://mocha//lib/mocha/expectation.rb#713
  def mocha_inspect; end

  # Modifies expectation so that when the expected method is called, it yields multiple times per invocation with the specified +parameter_groups+.
  #
  # If no block is provided, the method will still attempt to yield resulting in a +LocalJumpError+. Note that this is what would happen if a "real" (non-mock) method implementation tried to yield to a non-existent block.
  #
  # @example When +foreach+ is called, the stub will invoke the block twice, the first time it passes ['row1_col1', 'row1_col2'] as the parameters, and the second time it passes ['row2_col1', ''] as the parameters.
  #   csv = mock()
  #   csv.expects(:foreach).with("path/to/file.csv").multiple_yields(['row1_col1', 'row1_col2'], ['row2_col1', ''])
  #   rows = []
  #   csv.foreach { |row| rows << row }
  #   rows # => [['row1_col1', 'row1_col2'], ['row2_col1', '']]
  # @example Yield different groups of parameters on different invocations of the expected method. Simulating a situation where the CSV file at 'path/to/file.csv' has been modified between the two calls to +foreach+.
  #   csv = mock()
  #   csv.stubs(:foreach).with("path/to/file.csv").multiple_yields(['old_row1_col1', 'old_row1_col2'], ['old_row2_col1', '']).then.multiple_yields(['new_row1_col1', ''], ['new_row2_col1', 'new_row2_col2'])
  #   rows_from_first_invocation = []
  #   rows_from_second_invocation = []
  #   csv.foreach { |row| rows_from_first_invocation << row } # first invocation
  #   csv.foreach { |row| rows_from_second_invocation << row } # second invocation
  #   rows_from_first_invocation # => [['old_row1_col1', 'old_row1_col2'], ['old_row2_col1', '']]
  #   rows_from_second_invocation # => [['new_row1_col1', ''], ['new_row2_col1', 'new_row2_col2']]
  # @param parameter_groups [*Array<Array>] each element of +parameter_groups+ should iself be an +Array+ representing the parameters to be passed to the block for a single yield. Any element of +parameter_groups+ that is not an +Array+ is wrapped in an +Array+.
  # @return [Expectation] the same expectation, thereby allowing invocations of other {Expectation} methods to be chained.
  # @see #then
  #
  # source://mocha//lib/mocha/expectation.rb#396
  def multiple_yields(*parameter_groups); end

  # Modifies expectation so that the expected method must never be called.
  #
  # @example Expected method must never be called.
  #   object = mock()
  #   object.expects(:expected_method).never
  #   object.expected_method # => unexpected invocation
  #
  #   object = mock()
  #   object.expects(:expected_method).never
  #   # => verify succeeds
  # @return [Expectation] the same expectation, thereby allowing invocations of other {Expectation} methods to be chained.
  #
  # source://mocha//lib/mocha/expectation.rb#114
  def never; end

  # Modifies expectation so that the expected method must be called exactly once.
  #
  # Note that this is the default behaviour for an expectation, but you may wish to use it for clarity/emphasis.
  #
  # @example Expected method must be invoked exactly once.
  #   object = mock()
  #   object.expects(:expected_method).once
  #   object.expected_method
  #   # => verify succeeds
  #
  #   object = mock()
  #   object.expects(:expected_method).once
  #   object.expected_method
  #   object.expected_method # => unexpected invocation
  #
  #   object = mock()
  #   object.expects(:expected_method).once
  #   # => verify fails
  # @return [Expectation] the same expectation, thereby allowing invocations of other {Expectation} methods to be chained.
  #
  # source://mocha//lib/mocha/expectation.rb#97
  def once; end

  # @private
  #
  # source://mocha//lib/mocha/expectation.rb#657
  def ordering_constraints_not_allowing_invocation_now; end

  # @private
  #
  # source://mocha//lib/mocha/expectation.rb#647
  def perform_side_effects; end

  # Modifies expectation so that when the expected method is called, it raises the specified +exception+ with the specified +message+ i.e. calls +Kernel#raise(exception, message)+.
  #
  # @example Raise an exception on first invocation of expected method and then return values on subsequent invocations.
  #   object = stub()
  #   object.stubs(:expected_method).raises(Exception).then.returns(2, 3)
  #   object.expected_method # => raises exception of class Exception1
  #   object.expected_method # => 2
  #   object.expected_method # => 3
  # @example Raise custom exception with extra constructor parameters by passing in an instance of the exception.
  #   object = stub()
  #   object.stubs(:expected_method).raises(MyException.new('message', 1, 2, 3))
  #   object.expected_method # => raises the specified instance of MyException
  # @example Raise different exceptions on consecutive invocations of the expected method.
  #   object = stub()
  #   object.stubs(:expected_method).raises(Exception1).then.raises(Exception2)
  #   object.expected_method # => raises exception of class Exception1
  #   object.expected_method # => raises exception of class Exception2
  # @example Raise specified exception if expected method is invoked.
  #   object = stub()
  #   object.stubs(:expected_method).raises(Exception, 'message')
  #   object.expected_method # => raises exception of class Exception and with message 'message'
  # @overload raises
  # @overload raises
  # @overload raises
  # @param exception [Class, Exception, String, #exception] exception to be raised or message to be passed to RuntimeError.
  # @param message [String] exception message.
  # @return [Expectation] the same expectation, thereby allowing invocations of other {Expectation} methods to be chained.
  # @see #then
  # @see Kernel#raise
  #
  # source://mocha//lib/mocha/expectation.rb#483
  def raises(exception = T.unsafe(nil), message = T.unsafe(nil)); end

  # Modifies expectation so that when the expected method is called, it returns the specified +value+.
  #
  # @example Alternative way to return a different value on consecutive invocations.
  #   object = mock()
  #   object.stubs(:expected_method).returns(1, 2).then.returns(3)
  #   object.expected_method # => 1
  #   object.expected_method # => 2
  #   object.expected_method # => 3
  # @example May be called in conjunction with {#raises} on the same expectation.
  #   object = mock()
  #   object.stubs(:expected_method).returns(1, 2).then.raises(Exception)
  #   object.expected_method # => 1
  #   object.expected_method # => 2
  #   object.expected_method # => raises exception of class Exception1
  # @example Note that in Ruby a method returning multiple values is exactly equivalent to a method returning an +Array+ of those values.
  #   object = mock()
  #   object.stubs(:expected_method).returns([1, 2])
  #   x, y = object.expected_method
  #   x # => 1
  #   y # => 2
  # @example Return a different value on consecutive invocations.
  #   object = mock()
  #   object.stubs(:stubbed_method).returns(1, 2)
  #   object.stubbed_method # => 1
  #   object.stubbed_method # => 2
  # @example Return the same value on every invocation.
  #   object = mock()
  #   object.stubs(:stubbed_method).returns('result')
  #   object.stubbed_method # => 'result'
  #   object.stubbed_method # => 'result'
  # @overload returns
  # @overload returns
  # @return [Expectation] the same expectation, thereby allowing invocations of other {Expectation} methods to be chained.
  # @see #then
  #
  # source://mocha//lib/mocha/expectation.rb#443
  def returns(*values); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/expectation.rb#683
  def satisfied?; end

  # @example Using {#then} as syntactic sugar when specifying values to be returned and exceptions to be raised on consecutive invocations of the expected method.
  #   object = mock()
  #   object.stubs(:expected_method).returns(1, 2).then.raises(Exception).then.returns(4)
  #   object.expected_method # => 1
  #   object.expected_method # => 2
  #   object.expected_method # => raises exception of class Exception
  #   object.expected_method # => 4
  # @example Using {#then} to change the +state+ of a +state_machine+ on the invocation of an expected method.
  #   power = states('power').starts_as('off')
  #
  #   radio = mock('radio')
  #   radio.expects(:switch_on).then(power.is('on'))
  #   radio.expects(:select_channel).with('BBC Radio 4').when(power.is('on'))
  #   radio.expects(:adjust_volume).with(+5).when(power.is('on'))
  #   radio.expects(:select_channel).with('BBC World Service').when(power.is('on'))
  #   radio.expects(:adjust_volume).with(-5).when(power.is('on'))
  #   radio.expects(:switch_off).then(power.is('off'))
  # @overload then
  # @overload then
  # @return [Expectation] the same expectation, thereby allowing invocations of other {Expectation} methods to be chained.
  #
  # source://mocha//lib/mocha/expectation.rb#557
  def then(state = T.unsafe(nil)); end

  # Modifies expectation so that when the expected method is called, it throws the specified +tag+ with the specific return value +object+ i.e. calls +Kernel#throw(tag, object)+.
  #
  # @example Throw different tags on consecutive invocations of the expected method.
  #   object = stub()
  #   object.stubs(:expected_method).throws(:done).then.throws(:continue)
  #   object.expected_method # => throws :done
  #   object.expected_method # => throws :continue
  # @example Throw tag on first invocation of expected method and then return values for subsequent invocations.
  #   object = stub()
  #   object.stubs(:expected_method).throws(:done).then.returns(2, 3)
  #   object.expected_method # => throws :done
  #   object.expected_method # => 2
  #   object.expected_method # => 3
  # @example Throw tag when expected method is invoked.
  #   object = stub()
  #   object.stubs(:expected_method).throws(:done)
  #   object.expected_method # => throws tag :done
  # @example Throw tag with return value +object+ c.f. +Kernel#throw+.
  #   object = stub()
  #   object.stubs(:expected_method).throws(:done, 'result')
  #   object.expected_method # => throws tag :done and causes catch block to return 'result'
  # @overload throw
  # @overload throw
  # @param object [Object] return value for the catch block.
  # @param tag [Symbol, String] tag to throw to transfer control to the active catch block.
  # @return [Expectation] the same expectation, thereby allowing invocations of other {Expectation} methods to be chained.
  # @see #then
  # @see Kernel#throw
  #
  # source://mocha//lib/mocha/expectation.rb#522
  def throws(tag, object = T.unsafe(nil)); end

  # Modifies expectation so that the number of calls to the expected method must be within a specific +range+.
  #
  # @example Specifying a range in the number of expected invocations.
  #   object = mock()
  #   object.expects(:expected_method).times(2..4)
  #   3.times { object.expected_method }
  #   # => verify succeeds
  #
  #   object = mock()
  #   object.expects(:expected_method).times(2..4)
  #   object.expected_method
  #   # => verify fails
  # @example Specifying a specific number of expected invocations.
  #   object = mock()
  #   object.expects(:expected_method).times(3)
  #   3.times { object.expected_method }
  #   # => verify succeeds
  #
  #   object = mock()
  #   object.expects(:expected_method).times(3)
  #   2.times { object.expected_method }
  #   # => verify fails
  # @param range [Range, Integer] specifies the allowable range in the number of expected invocations.
  # @return [Expectation] the same expectation, thereby allowing invocations of other {Expectation} methods to be chained.
  #
  # source://mocha//lib/mocha/expectation.rb#46
  def times(range); end

  # Modifies expectation so that the expected method must be called exactly twice.
  #
  # @example Expected method must be invoked exactly twice.
  #   object = mock()
  #   object.expects(:expected_method).twice
  #   object.expected_method
  #   object.expected_method
  #   # => verify succeeds
  #
  #   object = mock()
  #   object.expects(:expected_method).twice
  #   object.expected_method
  #   object.expected_method
  #   object.expected_method # => unexpected invocation
  #
  #   object = mock()
  #   object.expects(:expected_method).twice
  #   object.expected_method
  #   # => verify fails
  # @return [Expectation] the same expectation, thereby allowing invocations of other {Expectation} methods to be chained.
  #
  # source://mocha//lib/mocha/expectation.rb#72
  def twice; end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/expectation.rb#701
  def used?; end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/expectation.rb#695
  def verified?(assertion_counter = T.unsafe(nil)); end

  # Constrains the expectation to occur only when the +state_machine+ is in the state specified by +state_predicate+.
  #
  # @example Using {#when} to only allow invocation of methods when "power" state machine is in the "on" state.
  #   power = states('power').starts_as('off')
  #
  #   radio = mock('radio')
  #   radio.expects(:switch_on).then(power.is('on'))
  #   radio.expects(:select_channel).with('BBC Radio 4').when(power.is('on'))
  #   radio.expects(:adjust_volume).with(+5).when(power.is('on'))
  #   radio.expects(:select_channel).with('BBC World Service').when(power.is('on'))
  #   radio.expects(:adjust_volume).with(-5).when(power.is('on'))
  #   radio.expects(:switch_off).then(power.is('off'))
  # @param state_predicate [StateMachine::StatePredicate] +state_machine.is(state_name)+ provides a mechanism to determine whether the +state_machine+ is in the state specified by +state_predicate+ when the expected method is invoked.
  # @return [Expectation] the same expectation, thereby allowing invocations of other {Expectation} methods to be chained.
  # @see #then
  # @see API#states
  # @see StateMachine
  #
  # source://mocha//lib/mocha/expectation.rb#581
  def when(state_predicate); end

  # Modifies expectation so that the expected method must be called with +expected_parameters_or_matchers+.
  #
  # May be used with Ruby literals or variables for exact matching or with parameter matchers for less-specific matching, e.g. {ParameterMatchers#includes}, {ParameterMatchers#has_key}, etc. See {ParameterMatchers} for a list of all available parameter matchers.
  #
  # Alternatively a block argument can be passed to {#with} to implement custom parameter matching. The block receives the +*actual_parameters+ as its arguments and should return +true+ if they are acceptable or +false+ otherwise. See the example below where a method is expected to be called with a value divisible by 4.
  # The block argument takes precedence over +expected_parameters_or_matchers+. The block may be called multiple times per invocation of the expected method and so it should be idempotent.
  #
  # Note that if {#with} is called multiple times on the same expectation, the last call takes precedence; other calls are ignored.
  #
  # Positional arguments were separated from keyword arguments in Ruby v3 (see {https://www.ruby-lang.org/en/news/2019/12/12/separation-of-positional-and-keyword-arguments-in-ruby-3-0 this article}). In relation to this a new configuration option ({Configuration#strict_keyword_argument_matching=}) is available in Ruby >= 2.7.
  #
  # When {Configuration#strict_keyword_argument_matching=} is set to +false+ (which is currently the default), a positional +Hash+ and a set of keyword arguments passed to {#with} are treated the same for the purposes of parameter matching. However, a deprecation warning will be displayed if a positional +Hash+ matches a set of keyword arguments or vice versa. This is because {Configuration#strict_keyword_argument_matching=} will default to +true+ in the future.
  #
  # When {Configuration#strict_keyword_argument_matching=} is set to +true+, an actual positional +Hash+ will not match an expected set of keyword arguments; and vice versa, an actual set of keyword arguments will not match an expected positional +Hash+, i.e. the parameter matching is stricter.
  #
  # @example Expected method must be called with exact parameter values.
  #   object = mock()
  #   object.expects(:expected_method).with(:param1, :param2)
  #   object.expected_method(:param1, :param2)
  #   # => verify succeeds
  #
  #   object = mock()
  #   object.expects(:expected_method).with(:param1, :param2)
  #   object.expected_method(:param3)
  #   # => verify fails
  # @example Expected method must be called with parameters matching parameter matchers.
  #   object = mock()
  #   object.expects(:expected_method).with(includes('string2'), anything)
  #   object.expected_method(['string1', 'string2'], 'any-old-value')
  #   # => verify succeeds
  #
  #   object = mock()
  #   object.expects(:expected_method).with(includes('string2'), anything)
  #   object.expected_method(['string1'], 'any-old-value')
  #   # => verify fails
  # @example Extracting a custom matcher into an instance method on the test class.
  #   class MyTest < Minitest::Test
  #   def test_expected_method_is_called_with_a_value_divisible_by_4
  #   object = mock()
  #   object.expects(:expected_method).with(&method(:divisible_by_4))
  #   object.expected_method(16)
  #   # => verify succeeds
  #   end
  #
  #   private
  #
  #   def divisible_by_4(value)
  #   value % 4 == 0
  #   end
  #   end
  # @example Loose keyword argument matching (default)
  #
  #   class Example
  #   def foo(a, bar:); end
  #   end
  #
  #   example = Example.new
  #   example.expects(:foo).with('a', bar: 'b')
  #   example.foo('a', { bar: 'b' })
  #   # This passes the test, but would result in an ArgumentError in practice
  # @example Strict keyword argument matching
  #
  #   Mocha.configure do |c|
  #   c.strict_keyword_argument_matching = true
  #   end
  #
  #   class Example
  #   def foo(a, bar:); end
  #   end
  #
  #   example = Example.new
  #   example.expects(:foo).with('a', bar: 'b')
  #   example.foo('a', { bar: 'b' })
  #   # This now fails as expected
  # @example Using a block argument to expect the method to be called with a value divisible by 4.
  #   object = mock()
  #   object.expects(:expected_method).with() { |value| value % 4 == 0 }
  #   object.expected_method(16)
  #   # => verify succeeds
  #
  #   object = mock()
  #   object.expects(:expected_method).with() { |value| value % 4 == 0 }
  #   object.expected_method(17)
  #   # => verify fails
  # @param expected_parameters_or_matchers [Array<Object,ParameterMatchers::Base>] expected parameter values or parameter matchers.
  # @return [Expectation] the same expectation, thereby allowing invocations of other {Expectation} methods to be chained.
  # @see Configuration#strict_keyword_argument_matching=
  # @see ParameterMatchers
  # @yield optional block specifying custom matching.
  # @yieldparam actual_parameters [Array<Object>] parameters with which expected method was invoked.
  # @yieldreturn [Boolean] +true+ if +actual_parameters+ are acceptable; +false+ otherwise.
  #
  # source://mocha//lib/mocha/expectation.rb#290
  def with(*expected_parameters_or_matchers, **_arg1, &matching_block); end

  # Modifies expectation so that the expected method must be called with a block.
  #
  # @example Expected method must be called with a block.
  #   object = mock()
  #   object.expects(:expected_method).with_block_given
  #   object.expected_method { 1 + 1 }
  #   # => verify succeeds
  #
  #   object = mock()
  #   object.expects(:expected_method).with_block_given
  #   object.expected_method
  #   # => verify fails
  # @return [Expectation] the same expectation, thereby allowing invocations of other {Expectation} methods to be chained.
  #
  # source://mocha//lib/mocha/expectation.rb#310
  def with_block_given; end

  # Modifies expectation so that the expected method must be called without a block.
  #
  # @example Expected method must be called without a block.
  #   object = mock()
  #   object.expects(:expected_method).with_no_block_given
  #   object.expected_method
  #   # => verify succeeds
  #
  #   object = mock()
  #   object.expects(:expected_method).with_block_given
  #   object.expected_method { 1 + 1 }
  #   # => verify fails
  # @return [Expectation] the same expectation, thereby allowing invocations of other {Expectation} methods to be chained.
  #
  # source://mocha//lib/mocha/expectation.rb#329
  def with_no_block_given; end

  # Modifies expectation so that when the expected method is called, it yields to the block with the specified +parameters+.
  #
  # If no +parameters+ are specified, it yields to the block without any parameters.
  #
  # If no block is provided, the method will still attempt to yield resulting in a +LocalJumpError+. Note that this is what would happen if a "real" (non-mock) method implementation tried to yield to a non-existent block.
  #
  # May be called multiple times on the same expectation for consecutive invocations.
  #
  # @example Yield different parameters on different invocations of the expected method.
  #   fibonacci = mock()
  #   fibonacci.expects(:next_pair).yields(0, 1).then.yields(1, 1)
  #   sum = 0
  #   fibonacci.next_pair { |first, second| sum = first + second }
  #   sum # => 1
  #   fibonacci.next_pair { |first, second| sum = first + second }
  #   sum # => 2
  # @example Yield parameters when expected method is invoked.
  #   fibonacci = mock()
  #   fibonacci.expects(:next_pair).yields(0, 1)
  #   sum = 0
  #   fibonacci.next_pair { |first, second| sum = first + second }
  #   sum # => 1
  # @example Yield when expected method is invoked.
  #   benchmark = mock()
  #   benchmark.expects(:measure).yields
  #   yielded = false
  #   benchmark.measure { yielded = true }
  #   yielded # => true
  # @param parameters [*Array] parameters to be yielded.
  # @return [Expectation] the same expectation, thereby allowing invocations of other {Expectation} methods to be chained.
  # @see #then
  #
  # source://mocha//lib/mocha/expectation.rb#368
  def yields(*parameters); end
end

# Default exception class raised when an unexpected invocation or an unsatisfied expectation occurs.
#
# Authors of test libraries may use +Mocha::ExpectationErrorFactory+ to have Mocha raise a different exception.
#
# @see Mocha::ExpectationErrorFactory
#
# source://mocha//lib/mocha/expectation_error.rb#7
class Mocha::ExpectationError < ::Exception; end

# This factory determines what class of exception should be raised when Mocha detects a test failure.
#
# This class should only be used by authors of test libraries and not by typical "users" of Mocha.
#
# For example, it is used by +Mocha::Integration::Minitest::Adapter+ in order to have Mocha raise a +Minitest::Assertion+ which can then be sensibly handled by +Minitest::Unit::TestCase+.
#
# @see Mocha::Integration::Minitest::Adapter
#
# source://mocha//lib/mocha/expectation_error_factory.rb#12
class Mocha::ExpectationErrorFactory
  class << self
    # @private
    #
    # source://mocha//lib/mocha/expectation_error_factory.rb#26
    def build(message = T.unsafe(nil), backtrace = T.unsafe(nil)); end

    # Determines what class of exception should be raised when Mocha detects a test failure.
    #
    # This attribute may be set by authors of test libraries in order to have Mocha raise exceptions of a specific class when there is an unexpected invocation or an unsatisfied expectation.
    #
    # By default a +Mocha::ExpectationError+ will be raised.
    #
    # @return [Exception] class of exception to be raised when an expectation error occurs
    # @see Mocha::ExpectationError
    #
    # source://mocha//lib/mocha/expectation_error_factory.rb#23
    def exception_class; end

    # Sets the attribute exception_class
    #
    # @param value the value to set the attribute exception_class to.
    #
    # source://mocha//lib/mocha/expectation_error_factory.rb#23
    def exception_class=(_arg0); end
  end
end

# source://mocha//lib/mocha/expectation_list.rb#2
class Mocha::ExpectationList
  # @return [ExpectationList] a new instance of ExpectationList
  #
  # source://mocha//lib/mocha/expectation_list.rb#3
  def initialize(expectations = T.unsafe(nil)); end

  # source://mocha//lib/mocha/expectation_list.rb#52
  def +(other); end

  # source://mocha//lib/mocha/expectation_list.rb#7
  def add(expectation); end

  # @return [Boolean]
  #
  # source://mocha//lib/mocha/expectation_list.rb#48
  def any?; end

  # source://mocha//lib/mocha/expectation_list.rb#44
  def length; end

  # source://mocha//lib/mocha/expectation_list.rb#20
  def match(invocation, ignoring_order: T.unsafe(nil)); end

  # source://mocha//lib/mocha/expectation_list.rb#24
  def match_allowing_invocation(invocation); end

  # source://mocha//lib/mocha/expectation_list.rb#28
  def match_never_allowing_invocation(invocation); end

  # @return [Boolean]
  #
  # source://mocha//lib/mocha/expectation_list.rb#16
  def matches_method?(method_name); end

  # source://mocha//lib/mocha/expectation_list.rb#56
  def matching_expectations(invocation, ignoring_order: T.unsafe(nil)); end

  # source://mocha//lib/mocha/expectation_list.rb#12
  def remove_all_matching_method(method_name); end

  # source://mocha//lib/mocha/expectation_list.rb#36
  def to_a; end

  # source://mocha//lib/mocha/expectation_list.rb#40
  def to_set; end

  # @return [Boolean]
  #
  # source://mocha//lib/mocha/expectation_list.rb#32
  def verified?(assertion_counter = T.unsafe(nil)); end
end

# Integration hooks for test library authors.
#
# The methods in this module should be called from test libraries wishing to integrate with Mocha.
#
# This module is provided as part of the +Mocha::API+ module and is therefore part of the public API, but should only be used by authors of test libraries and not by typical "users" of Mocha.
#
# Integration with Test::Unit and Minitest are provided as part of Mocha, because they are (or were once) part of the Ruby standard library. Integration with other test libraries is not provided as *part* of Mocha, but is supported by means of the methods in this module.
#
# See the code in the +Adapter+ modules for examples of how to use the methods in this module. +Mocha::ExpectationErrorFactory+ may be used if you want +Mocha+ to raise a different type of exception.
#
# @see Mocha::API
# @see Mocha::ExpectationErrorFactory
# @see Mocha::Integration::Minitest::Adapter
# @see Mocha::Integration::TestUnit::Adapter
#
# source://mocha//lib/mocha/hooks.rb#18
module Mocha::Hooks
  # Prepares Mocha before a test (only for use by authors of test libraries).
  #
  # This method should be called before each individual test starts (including before any "setup" code).
  #
  # source://mocha//lib/mocha/hooks.rb#22
  def mocha_setup; end

  # Resets Mocha after a test (only for use by authors of test libraries).
  #
  # This method should be called after each individual test has finished (including after any "teardown" code).
  #
  # source://mocha//lib/mocha/hooks.rb#38
  def mocha_teardown(origin = T.unsafe(nil)); end

  # Returns a string representing the unit test name, to be included in some Mocha
  # to help track down potential bugs.
  #
  # source://mocha//lib/mocha/hooks.rb#44
  def mocha_test_name; end

  # Verifies that all mock expectations have been met (only for use by authors of test libraries).
  #
  # This is equivalent to a series of "assertions".
  #
  # This method should be called at the end of each individual test, before it has been determined whether or not the test has passed.
  #
  # source://mocha//lib/mocha/hooks.rb#31
  def mocha_verify(assertion_counter = T.unsafe(nil)); end
end

# source://mocha//lib/mocha/names.rb#12
class Mocha::ImpersonatingAnyInstanceName
  # @return [ImpersonatingAnyInstanceName] a new instance of ImpersonatingAnyInstanceName
  #
  # source://mocha//lib/mocha/names.rb#13
  def initialize(klass); end

  # source://mocha//lib/mocha/names.rb#17
  def mocha_inspect; end
end

# source://mocha//lib/mocha/names.rb#2
class Mocha::ImpersonatingName
  # @return [ImpersonatingName] a new instance of ImpersonatingName
  #
  # source://mocha//lib/mocha/names.rb#3
  def initialize(object); end

  # source://mocha//lib/mocha/names.rb#7
  def mocha_inspect; end
end

# source://mocha//lib/mocha/in_state_ordering_constraint.rb#2
class Mocha::InStateOrderingConstraint
  # @return [InStateOrderingConstraint] a new instance of InStateOrderingConstraint
  #
  # source://mocha//lib/mocha/in_state_ordering_constraint.rb#3
  def initialize(state_predicate); end

  # @return [Boolean]
  #
  # source://mocha//lib/mocha/in_state_ordering_constraint.rb#7
  def allows_invocation_now?; end

  # source://mocha//lib/mocha/in_state_ordering_constraint.rb#11
  def mocha_inspect; end
end

# source://mocha//lib/mocha/inspect.rb#4
module Mocha::Inspect; end

# source://mocha//lib/mocha/inspect.rb#13
module Mocha::Inspect::ArrayMethods
  # source://mocha//lib/mocha/inspect.rb#14
  def mocha_inspect(wrapped = T.unsafe(nil)); end
end

# source://mocha//lib/mocha/inspect.rb#44
module Mocha::Inspect::DateMethods
  # source://mocha//lib/mocha/inspect.rb#45
  def mocha_inspect; end
end

# source://mocha//lib/mocha/inspect.rb#20
module Mocha::Inspect::HashMethods
  # source://mocha//lib/mocha/inspect.rb#21
  def mocha_inspect; end
end

# source://mocha//lib/mocha/inspect.rb#5
module Mocha::Inspect::ObjectMethods
  # source://mocha//lib/mocha/inspect.rb#6
  def mocha_inspect; end
end

# source://mocha//lib/mocha/inspect.rb#38
module Mocha::Inspect::TimeMethods
  # source://mocha//lib/mocha/inspect.rb#39
  def mocha_inspect; end
end

# source://mocha//lib/mocha/instance_method.rb#4
class Mocha::InstanceMethod < ::Mocha::StubbedMethod
  private

  # source://mocha//lib/mocha/instance_method.rb#7
  def mock_owner; end

  # source://mocha//lib/mocha/instance_method.rb#15
  def original_method_owner; end

  # source://mocha//lib/mocha/instance_method.rb#11
  def stubbee_method(method_name); end
end

# source://mocha//lib/mocha/integration/assertion_counter.rb#2
module Mocha::Integration; end

# source://mocha//lib/mocha/integration/assertion_counter.rb#3
class Mocha::Integration::AssertionCounter
  # @return [AssertionCounter] a new instance of AssertionCounter
  #
  # source://mocha//lib/mocha/integration/assertion_counter.rb#4
  def initialize(test_case); end

  # source://mocha//lib/mocha/integration/assertion_counter.rb#8
  def increment; end
end

# source://mocha//lib/mocha/integration/minitest/adapter.rb#7
module Mocha::Integration::Minitest
  class << self
    # source://mocha//lib/mocha/integration/minitest.rb#8
    def activate; end
  end
end

# Integrates Mocha into recent versions of Minitest.
#
# See the source code for an example of how to integrate Mocha into a test library.
#
# source://mocha//lib/mocha/integration/minitest/adapter.rb#11
module Mocha::Integration::Minitest::Adapter
  include ::Mocha::ParameterMatchers
  include ::Mocha::Hooks
  include ::Mocha::API

  # @private
  #
  # source://mocha//lib/mocha/integration/minitest/adapter.rb#45
  def after_teardown; end

  # @private
  #
  # source://mocha//lib/mocha/integration/minitest/adapter.rb#30
  def before_setup; end

  # @private
  #
  # source://mocha//lib/mocha/integration/minitest/adapter.rb#36
  def before_teardown; end

  # @private
  #
  # source://mocha//lib/mocha/integration/minitest/adapter.rb#51
  def mocha_test_name; end

  class << self
    # @private
    # @return [Boolean]
    #
    # source://mocha//lib/mocha/integration/minitest/adapter.rb#15
    def applicable_to?(minitest_version); end

    # @private
    #
    # source://mocha//lib/mocha/integration/minitest/adapter.rb#20
    def description; end

    # @private
    # @private
    #
    # source://mocha//lib/mocha/integration/minitest/adapter.rb#25
    def included(_mod); end
  end
end

# source://mocha//lib/mocha/invocation.rb#8
class Mocha::Invocation
  # @return [Invocation] a new instance of Invocation
  #
  # source://mocha//lib/mocha/invocation.rb#11
  def initialize(mock, method_name, arguments = T.unsafe(nil), block = T.unsafe(nil)); end

  # source://mocha//lib/mocha/invocation.rb#41
  def arguments; end

  # Returns the value of attribute block.
  #
  # source://mocha//lib/mocha/invocation.rb#9
  def block; end

  # source://mocha//lib/mocha/invocation.rb#20
  def call(yield_parameters = T.unsafe(nil), return_values = T.unsafe(nil)); end

  # source://mocha//lib/mocha/invocation.rb#45
  def call_description; end

  # source://mocha//lib/mocha/invocation.rb#61
  def full_description; end

  # Returns the value of attribute method_name.
  #
  # source://mocha//lib/mocha/invocation.rb#9
  def method_name; end

  # source://mocha//lib/mocha/invocation.rb#33
  def raised(exception); end

  # source://mocha//lib/mocha/invocation.rb#55
  def result_description; end

  # source://mocha//lib/mocha/invocation.rb#29
  def returned(value); end

  # source://mocha//lib/mocha/invocation.rb#51
  def short_call_description; end

  # source://mocha//lib/mocha/invocation.rb#37
  def threw(tag, value); end

  private

  # source://mocha//lib/mocha/invocation.rb#67
  def argument_description; end
end

# source://mocha//lib/mocha/logger.rb#2
class Mocha::Logger
  # @return [Logger] a new instance of Logger
  #
  # source://mocha//lib/mocha/logger.rb#3
  def initialize(io); end

  # source://mocha//lib/mocha/logger.rb#7
  def warn(message); end
end

# source://mocha//lib/mocha/method_matcher.rb#2
class Mocha::MethodMatcher
  # @return [MethodMatcher] a new instance of MethodMatcher
  #
  # source://mocha//lib/mocha/method_matcher.rb#5
  def initialize(expected_method_name); end

  # Returns the value of attribute expected_method_name.
  #
  # source://mocha//lib/mocha/method_matcher.rb#3
  def expected_method_name; end

  # @return [Boolean]
  #
  # source://mocha//lib/mocha/method_matcher.rb#9
  def match?(actual_method_name); end

  # source://mocha//lib/mocha/method_matcher.rb#13
  def mocha_inspect; end
end

# Traditional mock object.
#
# {expects} and {stubs} return an {Expectation} which can be further modified
# by methods on {Expectation}.
#
# {responds_like} and {responds_like_instance_of} both return a {Mock}, and
# can therefore, be chained to the original creation methods in {API}.
# They force the mock to indicate what it is supposed to be mocking, thus
# making it a safer verifying mock. They check that the underlying +responder+
# will actually respond to the methods being stubbed, throwing a
# +NoMethodError+ upon invocation otherwise.
#
# Stubs and expectations are basically the same thing. A stub is just an
# expectation of zero or more invocations. The {#stubs} method is syntactic
# sugar to make the intent of the test more explicit.
#
# When a method is invoked on a mock object, the mock object searches through
# its expectations from newest to oldest to find one that matches the
# invocation. After the invocation, the matching expectation might stop
# matching further invocations. For example, an +expects(:foo).once+
# expectation only matches once and will be ignored on future invocations
# while an +expects(:foo).at_least_once+ expectation will always be matched
# against invocations.
#
# However, note that if the expectation that matches the invocation has a
# cardinality of "never", then an unexpected invocation error is reported.
#
# This scheme allows you to:
#
# - Set up default stubs in your the +setup+ method of your test class and
#   override some of those stubs in individual tests.
# - Set up different +once+ expectations for the same method with different
#   action per invocation. However, it's better to use the
#   {Expectation#returns} method with multiple arguments to do this, as
#   described below.
#
# However, there are some possible "gotchas" caused by this scheme:
#
# - if you create an expectation and then a stub for the same method, the
#   stub will always override the expectation and the expectation will never
#   be met.
# - if you create a stub and then an expectation for the same method, the
#   expectation will match, and when it stops matching the stub will be used
#   instead, possibly masking test failures.
# - if you create different expectations for the same method, they will be
#   invoked in the opposite order than that in which they were specified,
#   rather than the same order.
#
# The best thing to do is not set up multiple expectations and stubs for the
# same method with exactly the same matchers. Instead, use the
# {Expectation#returns} method with multiple arguments to create multiple
# actions for a method. You can also chain multiple calls to
# {Expectation#returns} and {Expectation#raises} (along with syntactic sugar
# {Expectation#then} if desired).
#
# If you want to specify more complex ordering or order invocations across
# different mock objects, use the {Expectation#in_sequence} method to
# explicitly define a total or partial ordering of invocations.
#
# @example
#   object = mock()
#   object.stubs(:expected_method).returns(1, 2).then.raises(Exception)
#   object.expected_method # => 1
#   object.expected_method # => 2
#   object.expected_method # => raises exception of class Exception1
#
# source://mocha//lib/mocha/mock.rb#79
class Mocha::Mock
  # @private
  # @return [Mock] a new instance of Mock
  #
  # source://mocha//lib/mocha/mock.rb#279
  def initialize(mockery, name = T.unsafe(nil), receiver = T.unsafe(nil)); end

  # @private
  #
  # source://mocha//lib/mocha/mock.rb#303
  def __expectations__; end

  # Adds an expectation that the specified method must be called exactly once with any parameters.
  #
  # @example Expected method invoked once so no error raised
  #   object = mock()
  #   object.expects(:expected_method)
  #   object.expected_method
  # @example Expected method invoked twice so error raised
  #   object = mock()
  #   object.expects(:expected_method)
  #   object.expected_method
  #   object.expected_method # => error raised when expected method invoked second time
  # @example Expected method not invoked so error raised
  #   object = mock()
  #   object.expects(:expected_method)
  #   # error raised when test completes, because expected_method not called exactly once
  # @example Setup multiple expectations using +expected_methods_vs_return_values+.
  #   object = mock()
  #   object.expects(expected_method_one: :result_one, expected_method_two: :result_two)
  #
  #   # is exactly equivalent to
  #
  #   object = mock()
  #   object.expects(:expected_method_one).returns(:result_one)
  #   object.expects(:expected_method_two).returns(:result_two)
  # @overload expects
  # @overload expects
  # @return [Expectation] last-built expectation which can be further modified by methods on {Expectation}.
  #
  # source://mocha//lib/mocha/mock.rb#293
  def __expects__(method_name_or_hash, backtrace = T.unsafe(nil)); end

  # @private
  #
  # source://mocha//lib/mocha/mock.rb#363
  def __expire__(origin); end

  # source://mocha//lib/mocha/mock.rb#297
  def __singleton_class__; end

  # Adds an expectation that the specified method may be called any number of times with any parameters.
  #
  # @example No error raised however many times stubbed method is invoked
  #   object = mock()
  #   object.stubs(:stubbed_method)
  #   object.stubbed_method
  #   object.stubbed_method
  #   # no error raised
  # @example Setup multiple expectations using +stubbed_methods_vs_return_values+.
  #   object = mock()
  #   object.stubs(stubbed_method_one: :result_one, stubbed_method_two: :result_two)
  #
  #   # is exactly equivalent to
  #
  #   object = mock()
  #   object.stubs(:stubbed_method_one).returns(:result_one)
  #   object.stubs(:stubbed_method_two).returns(:result_two)
  # @overload stubs
  # @overload stubs
  # @return [Expectation] last-built expectation which can be further modified by methods on {Expectation}.
  #
  # source://mocha//lib/mocha/mock.rb#295
  def __stubs__(method_name_or_hash, backtrace = T.unsafe(nil)); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/mock.rb#358
  def __verified__?(assertion_counter = T.unsafe(nil)); end

  # @private
  #
  # source://mocha//lib/mocha/mock.rb#313
  def all_expectations; end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/mock.rb#383
  def any_expectations?; end

  # @private
  #
  # source://mocha//lib/mocha/mock.rb#378
  def ensure_method_not_already_defined(method_name); end

  # @private
  #
  # source://mocha//lib/mocha/mock.rb#291
  def everything_stubbed; end

  # Adds an expectation that the specified method must be called exactly once with any parameters.
  #
  # @example Expected method invoked once so no error raised
  #   object = mock()
  #   object.expects(:expected_method)
  #   object.expected_method
  # @example Expected method invoked twice so error raised
  #   object = mock()
  #   object.expects(:expected_method)
  #   object.expected_method
  #   object.expected_method # => error raised when expected method invoked second time
  # @example Expected method not invoked so error raised
  #   object = mock()
  #   object.expects(:expected_method)
  #   # error raised when test completes, because expected_method not called exactly once
  # @example Setup multiple expectations using +expected_methods_vs_return_values+.
  #   object = mock()
  #   object.expects(expected_method_one: :result_one, expected_method_two: :result_two)
  #
  #   # is exactly equivalent to
  #
  #   object = mock()
  #   object.expects(:expected_method_one).returns(:result_one)
  #   object.expects(:expected_method_two).returns(:result_two)
  # @overload expects
  # @overload expects
  # @return [Expectation] last-built expectation which can be further modified by methods on {Expectation}.
  #
  # source://mocha//lib/mocha/mock.rb#114
  def expects(method_name_or_hash, backtrace = T.unsafe(nil)); end

  # @private
  #
  # source://mocha//lib/mocha/mock.rb#324
  def handle_method_call(symbol, arguments, block); end

  # @private
  #
  # source://mocha//lib/mocha/mock.rb#373
  def inspect; end

  # @private
  #
  # source://mocha//lib/mocha/mock.rb#318
  def method_missing(symbol, *arguments, **_arg2, &block); end

  # @private
  #
  # source://mocha//lib/mocha/mock.rb#368
  def mocha_inspect; end

  # Constrains the {Mock} instance so that it can only expect or stub methods to which +responder+ responds publicly. The constraint is only applied at method invocation time.
  #
  # A +NoMethodError+ will be raised if the +responder+ does not publicly +#respond_to?+ the invoked method (even if the method has been expected or stubbed).
  #
  # The {Mock} instance will delegate its +#respond_to?+ method to the +responder+. However, the +include_all+ parameter is not passed through, so only public methods on the +responder+ will be considered.
  #
  # Note that the methods on +responder+ are never actually invoked.
  #
  # @example Normal mocking
  #   sheep = mock('sheep')
  #   sheep.expects(:chew)
  #   sheep.expects(:foo)
  #   sheep.respond_to?(:chew) # => true
  #   sheep.respond_to?(:foo) # => true
  #   sheep.chew
  #   sheep.foo
  #   # no error raised
  # @example Using {#responds_like} with a class method
  #   class Sheep
  #   def self.number_of_legs; end
  #   end
  #
  #   sheep_class = mock('sheep_class')
  #   sheep_class.responds_like(Sheep)
  #   sheep_class.stubs(:number_of_legs).returns(4)
  #   sheep_class.expects(:foo)
  #   sheep_class.respond_to?(:number_of_legs) # => true
  #   sheep_class.respond_to?(:foo) # => false
  #   sheep_class.number_of_legs # => 4
  #   sheep_class.foo # => raises NoMethodError exception
  # @example Using {#responds_like} with an instance method
  #   class Sheep
  #   def chew(grass); end
  #   end
  #
  #   sheep = mock('sheep')
  #   sheep.responds_like(Sheep.new)
  #   sheep.expects(:chew)
  #   sheep.expects(:foo)
  #   sheep.respond_to?(:chew) # => true
  #   sheep.respond_to?(:foo) # => false
  #   sheep.chew
  #   sheep.foo # => raises NoMethodError exception
  # @param responder [Object, #respond_to?] an object used to determine whether {Mock} instance should +#respond_to?+ to an invocation.
  # @return [Mock] the same {Mock} instance, thereby allowing invocations of other {Mock} methods to be chained.
  # @see #responds_like_instance_of
  #
  # source://mocha//lib/mocha/mock.rb#299
  def quacks_like(responder); end

  # Constrains the {Mock} instance so that it can only expect or stub methods to which an instance of the +responder_class+ responds publicly. The constraint is only applied at method invocation time. Note that the responder instance is instantiated using +Class#allocate+.
  #
  # A +NoMethodError+ will be raised if the responder instance does not publicly +#respond_to?+ the invoked method (even if the method has been expected or stubbed).
  #
  # The {Mock} instance will delegate its +#respond_to?+ method to the responder instance. However, the +include_all+ parameter is not passed through, so only public methods on the +responder+  will be considered.
  #
  # Note that the methods on the responder instance are never actually invoked.
  #
  # @example Using {#responds_like_instance_of}
  #   class Sheep
  #   def initialize
  #   raise "some awkward code we don't want to call"
  #   end
  #   def chew(grass); end
  #   end
  #
  #   sheep = mock('sheep')
  #   sheep.responds_like_instance_of(Sheep)
  #   sheep.expects(:chew)
  #   sheep.expects(:foo)
  #   sheep.respond_to?(:chew) # => true
  #   sheep.respond_to?(:foo) # => false
  #   sheep.chew
  #   sheep.foo # => raises NoMethodError exception
  # @param responder_class [Class] a class used to determine whether {Mock} instance should +#respond_to?+ to an invocation.
  # @return [Mock] the same {Mock} instance, thereby allowing invocations of other {Mock} methods to be chained.
  # @see #responds_like
  #
  # source://mocha//lib/mocha/mock.rb#300
  def quacks_like_instance_of(responder_class); end

  # Constrains the {Mock} instance so that it can only expect or stub methods to which +responder+ responds publicly. The constraint is only applied at method invocation time.
  #
  # A +NoMethodError+ will be raised if the +responder+ does not publicly +#respond_to?+ the invoked method (even if the method has been expected or stubbed).
  #
  # The {Mock} instance will delegate its +#respond_to?+ method to the +responder+. However, the +include_all+ parameter is not passed through, so only public methods on the +responder+ will be considered.
  #
  # Note that the methods on +responder+ are never actually invoked.
  #
  # @example Normal mocking
  #   sheep = mock('sheep')
  #   sheep.expects(:chew)
  #   sheep.expects(:foo)
  #   sheep.respond_to?(:chew) # => true
  #   sheep.respond_to?(:foo) # => true
  #   sheep.chew
  #   sheep.foo
  #   # no error raised
  # @example Using {#responds_like} with a class method
  #   class Sheep
  #   def self.number_of_legs; end
  #   end
  #
  #   sheep_class = mock('sheep_class')
  #   sheep_class.responds_like(Sheep)
  #   sheep_class.stubs(:number_of_legs).returns(4)
  #   sheep_class.expects(:foo)
  #   sheep_class.respond_to?(:number_of_legs) # => true
  #   sheep_class.respond_to?(:foo) # => false
  #   sheep_class.number_of_legs # => 4
  #   sheep_class.foo # => raises NoMethodError exception
  # @example Using {#responds_like} with an instance method
  #   class Sheep
  #   def chew(grass); end
  #   end
  #
  #   sheep = mock('sheep')
  #   sheep.responds_like(Sheep.new)
  #   sheep.expects(:chew)
  #   sheep.expects(:foo)
  #   sheep.respond_to?(:chew) # => true
  #   sheep.respond_to?(:foo) # => false
  #   sheep.chew
  #   sheep.foo # => raises NoMethodError exception
  # @param responder [Object, #respond_to?] an object used to determine whether {Mock} instance should +#respond_to?+ to an invocation.
  # @return [Mock] the same {Mock} instance, thereby allowing invocations of other {Mock} methods to be chained.
  # @see #responds_like_instance_of
  #
  # source://mocha//lib/mocha/mock.rb#241
  def responds_like(responder); end

  # Constrains the {Mock} instance so that it can only expect or stub methods to which an instance of the +responder_class+ responds publicly. The constraint is only applied at method invocation time. Note that the responder instance is instantiated using +Class#allocate+.
  #
  # A +NoMethodError+ will be raised if the responder instance does not publicly +#respond_to?+ the invoked method (even if the method has been expected or stubbed).
  #
  # The {Mock} instance will delegate its +#respond_to?+ method to the responder instance. However, the +include_all+ parameter is not passed through, so only public methods on the +responder+  will be considered.
  #
  # Note that the methods on the responder instance are never actually invoked.
  #
  # @example Using {#responds_like_instance_of}
  #   class Sheep
  #   def initialize
  #   raise "some awkward code we don't want to call"
  #   end
  #   def chew(grass); end
  #   end
  #
  #   sheep = mock('sheep')
  #   sheep.responds_like_instance_of(Sheep)
  #   sheep.expects(:chew)
  #   sheep.expects(:foo)
  #   sheep.respond_to?(:chew) # => true
  #   sheep.respond_to?(:foo) # => false
  #   sheep.chew
  #   sheep.foo # => raises NoMethodError exception
  # @param responder_class [Class] a class used to determine whether {Mock} instance should +#respond_to?+ to an invocation.
  # @return [Mock] the same {Mock} instance, thereby allowing invocations of other {Mock} methods to be chained.
  # @see #responds_like
  #
  # source://mocha//lib/mocha/mock.rb#274
  def responds_like_instance_of(responder_class); end

  # @private
  #
  # source://mocha//lib/mocha/mock.rb#308
  def stub_everything; end

  # Adds an expectation that the specified method may be called any number of times with any parameters.
  #
  # @example No error raised however many times stubbed method is invoked
  #   object = mock()
  #   object.stubs(:stubbed_method)
  #   object.stubbed_method
  #   object.stubbed_method
  #   # no error raised
  # @example Setup multiple expectations using +stubbed_methods_vs_return_values+.
  #   object = mock()
  #   object.stubs(stubbed_method_one: :result_one, stubbed_method_two: :result_two)
  #
  #   # is exactly equivalent to
  #
  #   object = mock()
  #   object.stubs(:stubbed_method_one).returns(:result_one)
  #   object.stubs(:stubbed_method_two).returns(:result_two)
  # @overload stubs
  # @overload stubs
  # @return [Expectation] last-built expectation which can be further modified by methods on {Expectation}.
  #
  # source://mocha//lib/mocha/mock.rb#153
  def stubs(method_name_or_hash, backtrace = T.unsafe(nil)); end

  # Removes the specified stubbed methods (added by calls to {#expects} or {#stubs}) and all expectations associated with them.
  #
  # @example Invoking an unstubbed method causes error to be raised
  #   object = mock('mock')
  #   object.stubs(:stubbed_method).returns(:result_one)
  #   object.stubbed_method # => :result_one
  #   object.unstub(:stubbed_method)
  #   object.stubbed_method # => unexpected invocation: #<Mock:mock>.stubbed_method()
  # @example Unstubbing multiple methods.
  #   multiplier.unstub(:double, :triple)
  #
  #   # exactly equivalent to
  #
  #   multiplier.unstub(:double)
  #   multiplier.unstub(:triple)
  # @param method_names [Array<Symbol>] names of methods to unstub.
  #
  # source://mocha//lib/mocha/mock.rb#186
  def unstub(*method_names); end

  private

  # @raise [StubbingError]
  #
  # source://mocha//lib/mocha/mock.rb#410
  def check_expiry; end

  # source://mocha//lib/mocha/mock.rb#404
  def check_responder_responds_to(symbol); end

  # source://mocha//lib/mocha/mock.rb#389
  def raise_unexpected_invocation_error(invocation, matching_expectation); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/mock.rb#349
  def respond_to_missing?(symbol, _include_all); end
end

# source://mocha//lib/mocha/mockery.rb#13
class Mocha::Mockery
  # source://mocha//lib/mocha/mockery.rb#138
  def logger; end

  # Sets the attribute logger
  #
  # @param value the value to set the attribute logger to.
  #
  # source://mocha//lib/mocha/mockery.rb#136
  def logger=(_arg0); end

  # source://mocha//lib/mocha/mockery.rb#116
  def mocha_inspect; end

  # source://mocha//lib/mocha/mockery.rb#66
  def mock_impersonating(object); end

  # source://mocha//lib/mocha/mockery.rb#70
  def mock_impersonating_any_instance_of(klass); end

  # source://mocha//lib/mocha/mockery.rb#104
  def mocks; end

  # source://mocha//lib/mocha/mockery.rb#58
  def named_mock(name); end

  # source://mocha//lib/mocha/mockery.rb#74
  def new_state_machine(name); end

  # source://mocha//lib/mocha/mockery.rb#124
  def on_stubbing(object, method); end

  # source://mocha//lib/mocha/mockery.rb#112
  def sequences; end

  # source://mocha//lib/mocha/mockery.rb#108
  def state_machines; end

  # source://mocha//lib/mocha/mockery.rb#100
  def stubba; end

  # source://mocha//lib/mocha/mockery.rb#94
  def teardown(origin = T.unsafe(nil)); end

  # source://mocha//lib/mocha/mockery.rb#62
  def unnamed_mock; end

  # source://mocha//lib/mocha/mockery.rb#78
  def verify(assertion_counter = T.unsafe(nil)); end

  private

  # source://mocha//lib/mocha/mockery.rb#165
  def add_mock(mock); end

  # source://mocha//lib/mocha/mockery.rb#170
  def add_state_machine(state_machine); end

  # @raise [StubbingError]
  #
  # source://mocha//lib/mocha/mockery.rb#144
  def check(action, description, signature_proc, backtrace = T.unsafe(nil)); end

  # source://mocha//lib/mocha/mockery.rb#153
  def expectations; end

  # source://mocha//lib/mocha/mockery.rb#175
  def reset; end

  # source://mocha//lib/mocha/mockery.rb#161
  def satisfied_expectations; end

  # source://mocha//lib/mocha/mockery.rb#157
  def unsatisfied_expectations; end

  class << self
    # source://mocha//lib/mocha/mockery.rb#36
    def instance; end

    # source://mocha//lib/mocha/mockery.rb#40
    def setup; end

    # source://mocha//lib/mocha/mockery.rb#51
    def teardown(origin = T.unsafe(nil)); end

    # source://mocha//lib/mocha/mockery.rb#47
    def verify(*args); end
  end
end

# source://mocha//lib/mocha/mockery.rb#14
class Mocha::Mockery::Null < ::Mocha::Mockery
  # source://mocha//lib/mocha/mockery.rb#15
  def add_mock(*_arg0); end

  # source://mocha//lib/mocha/mockery.rb#19
  def add_state_machine(*_arg0); end

  # source://mocha//lib/mocha/mockery.rb#23
  def stubba; end

  private

  # @raise [NotInitializedError]
  #
  # source://mocha//lib/mocha/mockery.rb#29
  def raise_not_initialized_error; end
end

# source://mocha//lib/mocha/names.rb#22
class Mocha::Name
  # @return [Name] a new instance of Name
  #
  # source://mocha//lib/mocha/names.rb#23
  def initialize(name); end

  # source://mocha//lib/mocha/names.rb#27
  def mocha_inspect; end
end

# Exception raised when Mocha has not been initialized, e.g. outside the
# context of a test.
#
# source://mocha//lib/mocha/not_initialized_error.rb#6
class Mocha::NotInitializedError < ::Mocha::ErrorWithFilteredBacktrace; end

# Methods added to all objects to allow mocking and stubbing on real (i.e. non-mock) objects.
#
# Both {#expects} and {#stubs} return an {Expectation} which can be further modified by methods on {Expectation}.
#
# source://mocha//lib/mocha/object_methods.rb#10
module Mocha::ObjectMethods
  # @private
  #
  # source://mocha//lib/mocha/object_methods.rb#12
  def _method(_arg0); end

  # Adds an expectation that the specified method must be called exactly once with any parameters.
  #
  # The original implementation of the method is replaced during the test and then restored at the end of the test. The temporary replacement method has the same visibility as the original method.
  #
  # @example Setting up an expectation on a non-mock object.
  #   product = Product.new
  #   product.expects(:save).returns(true)
  #   assert_equal true, product.save
  # @example Setting up multiple expectations on a non-mock object.
  #   product = Product.new
  #   product.expects(valid?: true, save: true)
  #
  #   # exactly equivalent to
  #
  #   product = Product.new
  #   product.expects(:valid?).returns(true)
  #   product.expects(:save).returns(true)
  # @overload expects
  # @overload expects
  # @raise [StubbingError] if attempting to stub method which is not allowed.
  # @return [Expectation] last-built expectation which can be further modified by methods on {Expectation}.
  # @see Mock#expects
  #
  # source://mocha//lib/mocha/object_methods.rb#71
  def expects(expected_methods_vs_return_values); end

  # @private
  #
  # source://mocha//lib/mocha/object_methods.rb#15
  def mocha(instantiate = T.unsafe(nil)); end

  # @private
  #
  # source://mocha//lib/mocha/object_methods.rb#24
  def reset_mocha; end

  # @private
  #
  # source://mocha//lib/mocha/object_methods.rb#39
  def stubba_class; end

  # @private
  #
  # source://mocha//lib/mocha/object_methods.rb#29
  def stubba_method; end

  # @private
  #
  # source://mocha//lib/mocha/object_methods.rb#34
  def stubba_object; end

  # Adds an expectation that the specified method may be called any number of times with any parameters.
  #
  # The original implementation of the method is replaced during the test and then restored at the end of the test. The temporary replacement method has the same visibility as the original method.
  #
  # @example Setting up a stubbed methods on a non-mock object.
  #   product = Product.new
  #   product.stubs(:save).returns(true)
  #   assert_equal true, product.save
  # @example Setting up multiple stubbed methods on a non-mock object.
  #   product = Product.new
  #   product.stubs(valid?: true, save: true)
  #
  #   # exactly equivalent to
  #
  #   product = Product.new
  #   product.stubs(:valid?).returns(true)
  #   product.stubs(:save).returns(true)
  # @overload stubs
  # @overload stubs
  # @raise [StubbingError] if attempting to stub method which is not allowed.
  # @return [Expectation] last-built expectation which can be further modified by methods on {Expectation}.
  # @see Mock#stubs
  #
  # source://mocha//lib/mocha/object_methods.rb#120
  def stubs(stubbed_methods_vs_return_values); end

  # Removes the specified stubbed methods (added by calls to {#expects} or {#stubs}) and all expectations associated with them.
  #
  # Restores the original behaviour of the methods before they were stubbed. This is normally done automatically at the end of each test, but in some circumstances you may want to do it *before* the end of the test.
  #
  # WARNING: If you {#unstub} a method which still has unsatisfied expectations, you may be removing the only way those expectations can be satisfied. Use {#unstub} with care.
  #
  # @example Stubbing and unstubbing a method on a real (non-mock) object.
  #   multiplier = Multiplier.new
  #   multiplier.double(2) # => 4
  #   multiplier.stubs(:double).raises # new behaviour defined
  #   multiplier.double(2) # => raises exception
  #   multiplier.unstub(:double) # original behaviour restored
  #   multiplier.double(2) # => 4
  # @example Unstubbing multiple methods on a real (non-mock) object.
  #   multiplier.unstub(:double, :triple)
  #
  #   # exactly equivalent to
  #
  #   multiplier.unstub(:double)
  #   multiplier.unstub(:triple)
  # @param method_names [Array<Symbol>] names of methods to unstub.
  #
  # source://mocha//lib/mocha/object_methods.rb#161
  def unstub(*method_names); end
end

# source://mocha//lib/mocha/receivers.rb#2
class Mocha::ObjectReceiver
  # @return [ObjectReceiver] a new instance of ObjectReceiver
  #
  # source://mocha//lib/mocha/receivers.rb#3
  def initialize(object); end

  # source://mocha//lib/mocha/receivers.rb#7
  def mocks; end
end

# Used as parameters for {Expectation#with} to restrict the parameter values which will match the expectation. Can be nested.
#
# source://mocha//lib/mocha/parameter_matchers.rb#3
module Mocha::ParameterMatchers
  # Matches if +matcher+ does *not* match.
  #
  # @example Actual parameter does include the value +1+.
  #   object = mock()
  #   object.expects(:method_1).with(Not(includes(1)))
  #   object.method_1([0, 1, 2, 3])
  #   # error raised, because method_1 was not called with object not including 1
  # @example Actual parameter does not include the value +1+.
  #   object = mock()
  #   object.expects(:method_1).with(Not(includes(1)))
  #   object.method_1([0, 2, 3])
  #   # no error raised
  # @param matcher [Base] matcher whose logic to invert.
  # @return [Not] parameter matcher.
  # @see Expectation#with
  #
  # source://mocha//lib/mocha/parameter_matchers/not.rb#24
  def Not(matcher); end

  # Matches if all +matchers+ match.
  #
  # @example All parameter matchers match.
  #   object = mock()
  #   object.expects(:method_1).with(all_of(includes(1), includes(3)))
  #   object.method_1([1, 3])
  #   # no error raised
  # @example One of the parameter matchers does not match.
  #   object = mock()
  #   object.expects(:method_1).with(all_of(includes(1), includes(3)))
  #   object.method_1([1, 2])
  #   # error raised, because method_1 was not called with object including 1 and 3
  # @param matchers [*Array<Base>] parameter matchers.
  # @return [AllOf] parameter matcher.
  # @see Expectation#with
  #
  # source://mocha//lib/mocha/parameter_matchers/all_of.rb#23
  def all_of(*matchers); end

  # Matches if any +matchers+ match.
  #
  # @example Neither parameter matcher matches.
  #   object = mock()
  #   object.expects(:method_1).with(any_of(1, 3))
  #   object.method_1(2)
  #   # error raised, because method_1 was not called with 1 or 3
  # @example One parameter matcher matches.
  #   object = mock()
  #   object.expects(:method_1).with(any_of(1, 3))
  #   object.method_1(1)
  #   # no error raised
  # @example The other parameter matcher matches.
  #   object = mock()
  #   object.expects(:method_1).with(any_of(1, 3))
  #   object.method_1(3)
  #   # no error raised
  # @param matchers [*Array<Base>] parameter matchers.
  # @return [AnyOf] parameter matcher.
  # @see Expectation#with
  #
  # source://mocha//lib/mocha/parameter_matchers/any_of.rb#29
  def any_of(*matchers); end

  # Matches any parameters. This is used as the default for a newly built expectation.
  #
  # @example Any parameters will match.
  #   object = mock()
  #   object.expects(:method_1).with(any_parameters)
  #   object.method_1(1, 2, 3, 4)
  #   # no error raised
  #
  #   object = mock()
  #   object.expects(:method_1).with(any_parameters)
  #   object.method_1(5, 6, 7, 8, 9, 0)
  #   # no error raised
  # @return [AnyParameters] parameter matcher.
  # @see Expectation#with
  #
  # source://mocha//lib/mocha/parameter_matchers/any_parameters.rb#21
  def any_parameters; end

  # Matches any object.
  #
  # @example Any object will match.
  #   object = mock()
  #   object.expects(:method_1).with(anything)
  #   object.method_1('foo')
  #   object.method_1(789)
  #   object.method_1(:bar)
  #   # no error raised
  # @return [Anything] parameter matcher.
  # @see Expectation#with
  #
  # source://mocha//lib/mocha/parameter_matchers/anything.rb#18
  def anything; end

  # Matches any +Object+ equalling +value+.
  #
  # @example Actual parameter does not equal expected parameter.
  #   object = mock()
  #   object.expects(:method_1).with(equals(2))
  #   object.method_1(3)
  #   # error raised, because method_1 was not called with an +Object+ that equals 2
  # @example Actual parameter equals expected parameter.
  #   object = mock()
  #   object.expects(:method_1).with(equals(2))
  #   object.method_1(2)
  #   # no error raised
  # @param value [Object] expected value.
  # @return [Equals] parameter matcher.
  # @see Expectation#with
  # @see Object#==
  #
  # source://mocha//lib/mocha/parameter_matchers/equals.rb#24
  def equals(value); end

  # Matches a URI without regard to the ordering of parameters in the query string.
  #
  # @example Actual URI is equivalent.
  #   object = mock()
  #   object.expects(:method_1).with(equivalent_uri('http://example.com/foo?a=1&b=2))
  #   object.method_1('http://example.com/foo?b=2&a=1')
  #   # no error raised
  # @example Actual URI is not equivalent.
  #   object = mock()
  #   object.expects(:method_1).with(equivalent_uri('http://example.com/foo?a=1&b=2))
  #   object.method_1('http://example.com/foo?a=1&b=3')
  #   # error raised, because the query parameters were different
  # @param uri [String] URI to match.
  # @return [EquivalentUri] parameter matcher.
  # @see Expectation#with
  #
  # source://mocha//lib/mocha/parameter_matchers/equivalent_uri.rb#25
  def equivalent_uri(uri); end

  # Matches +Hash+ containing all +entries+.
  #
  # @example Actual parameter contains all expected entries.
  #   object = mock()
  #   object.expects(:method_1).with(has_entries('key_1' => 1, 'key_2' => 2))
  #   object.method_1('key_1' => 1, 'key_2' => 2, 'key_3' => 3)
  #   # no error raised
  # @example Actual parameter does not contain all expected entries.
  #   object = mock()
  #   object.expects(:method_1).with(has_entries('key_1' => 1, 'key_2' => 2))
  #   object.method_1('key_1' => 1, 'key_2' => 99)
  #   # error raised, because method_1 was not called with Hash containing entries: 'key_1' => 1, 'key_2' => 2
  # @param entries [Hash] expected +Hash+ entries.
  # @return [HasEntries] parameter matcher.
  # @see Expectation#with
  #
  # source://mocha//lib/mocha/parameter_matchers/has_entries.rb#26
  def has_entries(entries); end

  # Matches +Hash+ containing entry with +key+ and +value+.
  #
  # @example Actual parameter contains expected entry supplied as +Hash+ entry.
  #   object = mock()
  #   object.expects(:method_1).with(has_entry('key_1' => 1))
  #   object.method_1('key_1' => 1, 'key_2' => 2)
  #   # no error raised
  # @example Actual parameter contains expected entry supplied as key and value.
  #   object = mock()
  #   object.expects(:method_1).with(has_entry('key_1', 1))
  #   object.method_1('key_1' => 1, 'key_2' => 2)
  #   # no error raised
  # @example Actual parameter does not contain expected entry supplied as +Hash+ entry.
  #
  #   object = mock()
  #   object.expects(:method_1).with(has_entry('key_1' => 1))
  #   object.method_1('key_1' => 2, 'key_2' => 1)
  #   # error raised, because method_1 was not called with Hash containing entry: 'key_1' => 1
  # @example Actual parameter does not contain expected entry supplied as key and value.
  #   object = mock()
  #   object.expects(:method_1).with(has_entry('key_1', 1))
  #   object.method_1('key_1' => 2, 'key_2' => 1)
  #   # error raised, because method_1 was not called with Hash containing entry: 'key_1' => 1
  # @overload has_entry
  # @overload has_entry
  # @return [HasEntry] parameter matcher.
  # @see Expectation#with
  #
  # source://mocha//lib/mocha/parameter_matchers/has_entry.rb#43
  def has_entry(*options); end

  # Matches +Hash+ containing +key+.
  #
  # @example Actual parameter contains entry with expected key.
  #   object = mock()
  #   object.expects(:method_1).with(has_key('key_1'))
  #   object.method_1('key_1' => 1, 'key_2' => 2)
  #   # no error raised
  # @example Actual parameter does not contain entry with expected key.
  #   object = mock()
  #   object.expects(:method_1).with(has_key('key_1'))
  #   object.method_1('key_2' => 2)
  #   # error raised, because method_1 was not called with Hash containing key: 'key_1'
  # @param key [Object] expected key.
  # @return [HasKey] parameter matcher.
  # @see Expectation#with
  #
  # source://mocha//lib/mocha/parameter_matchers/has_key.rb#24
  def has_key(key); end

  # Matches +Hash+ containing +keys+.
  #
  # @example Actual parameter contains entry with expected keys.
  #   object = mock()
  #   object.expects(:method_1).with(has_keys(:key_1, :key_2))
  #   object.method_1(:key_1 => 1, :key_2 => 2, :key_3 => 3)
  #   # no error raised
  # @example Actual parameter does not contain all expected keys.
  #   object = mock()
  #   object.expects(:method_1).with(has_keys(:key_1, :key_2))
  #   object.method_1(:key_2 => 2)
  #   # error raised, because method_1 was not called with Hash containing key: :key_1
  # @param keys [*Array<Object>] expected keys.
  # @return [HasKeys] parameter matcher.
  # @see Expectation#with
  #
  # source://mocha//lib/mocha/parameter_matchers/has_keys.rb#24
  def has_keys(*keys); end

  # Matches +Hash+ containing +value+.
  #
  # @example Actual parameter contains entry with expected value.
  #   object = mock()
  #   object.expects(:method_1).with(has_value(1))
  #   object.method_1('key_1' => 1, 'key_2' => 2)
  #   # no error raised
  # @example Actual parameter does not contain entry with expected value.
  #   object = mock()
  #   object.expects(:method_1).with(has_value(1))
  #   object.method_1('key_2' => 2)
  #   # error raised, because method_1 was not called with Hash containing value: 1
  # @param value [Object] expected value.
  # @return [HasValue] parameter matcher.
  # @see Expectation#with
  #
  # source://mocha//lib/mocha/parameter_matchers/has_value.rb#24
  def has_value(value); end

  # Matches any object that responds with +true+ to +include?(item)+
  # for all items.
  #
  # @example Actual parameter does not include all items.
  #   object.method_1(['foo', 'baz'])
  #   # error raised, because ['foo', 'baz'] does not include 'bar'.
  # @example Actual parameter does not include item matching nested matcher.
  #   object.method_1(['foo', 'bar', {:other_key => 'baz'}])
  #   # error raised, because no element matches `has_key(:key)` matcher
  # @example Actual parameter includes all items.
  #   object = mock()
  #   object.expects(:method_1).with(includes('foo', 'bar'))
  #   object.method_1(['foo', 'bar', 'baz'])
  #   # no error raised
  # @example Actual parameter includes item which matches nested matcher.
  #   object = mock()
  #   object.expects(:method_1).with(includes(has_key(:key)))
  #   object.method_1(['foo', 'bar', {key: 'baz'}])
  #   # no error raised
  # @example Actual parameter is a Hash including the given key.
  #   object = mock()
  #   object.expects(:method_1).with(includes(:bar))
  #   object.method_1({foo: 1, bar: 2})
  #   # no error raised
  # @example Actual parameter is a Hash no key matching the given matcher.
  #   object.method_1({'foo' => 1, 'baz' => 3})
  #   # error raised, because hash does not include a key matching /ar/
  # @example Actual parameter is a Hash with a key matching the given matcher.
  #   object = mock()
  #   object.expects(:method_1).with(includes(regexp_matches(/ar/)))
  #   object.method_1({'foo' => 1, 'bar' => 2})
  #   # no error raised
  # @example Actual parameter is a Hash without the given key.
  #   object.method_1({foo: 1, baz: 2})
  #   # error raised, because hash does not include key 'bar'
  # @example Actual parameter is a String including substring.
  #   object = mock()
  #   object.expects(:method_1).with(includes('bar'))
  #   object.method_1('foobarbaz')
  #   # no error raised
  # @example Actual parameter is a String not including substring.
  #   object.method_1('foobaz')
  #   # error raised, because 'foobaz' does not include 'bar'
  # @param items [*Array] expected items.
  # @return [Includes] parameter matcher.
  # @see Expectation#with
  #
  # source://mocha//lib/mocha/parameter_matchers/includes.rb#63
  def includes(*items); end

  # Matches any object that is an instance of +klass+
  #
  # @example Actual parameter is an instance of +String+.
  #   object = mock()
  #   object.expects(:method_1).with(instance_of(String))
  #   object.method_1('string')
  #   # no error raised
  # @example Actual parameter is not an instance of +String+.
  #   object = mock()
  #   object.expects(:method_1).with(instance_of(String))
  #   object.method_1(99)
  #   # error raised, because method_1 was not called with an instance of String
  # @param klass [Class] expected class.
  # @return [InstanceOf] parameter matcher.
  # @see Expectation#with
  # @see Kernel#instance_of?
  #
  # source://mocha//lib/mocha/parameter_matchers/instance_of.rb#24
  def instance_of(klass); end

  # Matches any object that is a +klass+.
  #
  # @example Actual parameter is a +Integer+.
  #   object = mock()
  #   object.expects(:method_1).with(is_a(Integer))
  #   object.method_1(99)
  #   # no error raised
  # @example Actual parameter is not a +Integer+.
  #   object = mock()
  #   object.expects(:method_1).with(is_a(Integer))
  #   object.method_1('string')
  #   # error raised, because method_1 was not called with an Integer
  # @param klass [Class] expected class.
  # @return [IsA] parameter matcher.
  # @see Expectation#with
  # @see Kernel#is_a?
  #
  # source://mocha//lib/mocha/parameter_matchers/is_a.rb#25
  def is_a(klass); end

  # Matches any +Object+ that is a kind of +klass+.
  #
  # @example Actual parameter is a kind of +Integer+.
  #   object = mock()
  #   object.expects(:method_1).with(kind_of(Integer))
  #   object.method_1(99)
  #   # no error raised
  # @example Actual parameter is not a kind of +Integer+.
  #   object = mock()
  #   object.expects(:method_1).with(kind_of(Integer))
  #   object.method_1('string')
  #   # error raised, because method_1 was not called with a kind of Integer
  # @param klass [Class] expected class.
  # @return [KindOf] parameter matcher.
  # @see Expectation#with
  # @see Kernel#kind_of?
  #
  # source://mocha//lib/mocha/parameter_matchers/kind_of.rb#24
  def kind_of(klass); end

  # Matches optional parameters if available.
  #
  # @example Both required parameters and both of the optional parameters are supplied and they all match their expected value.
  #   object = mock()
  #   object.expects(:method_1).with(1, 2, optionally(3, 4))
  #   object.method_1(1, 2, 3, 4)
  #   # no error raised
  # @example Both required parameters and one of the optional parameters are supplied and they all match their expected value.
  #   object = mock()
  #   object.expects(:method_1).with(1, 2, optionally(3, 4))
  #   object.method_1(1, 2, 3)
  #   # no error raised
  # @example One of the actual optional parameters does not match the expected value.
  #   object = mock()
  #   object.expects(:method_1).with(1, 2, optionally(3, 4))
  #   object.method_1(1, 2, 3, 5)
  #   # error raised, because optional parameters did not match
  # @example Only the two required parameters are supplied and they both match their expected value.
  #   object = mock()
  #   object.expects(:method_1).with(1, 2, optionally(3, 4))
  #   object.method_1(1, 2)
  #   # no error raised
  # @param matchers [*Array<Base>] matchers for optional parameters.
  # @return [Optionally] parameter matcher.
  # @see Expectation#with
  #
  # source://mocha//lib/mocha/parameter_matchers/optionally.rb#33
  def optionally(*matchers); end

  # Matches any object that matches +regexp+.
  #
  # @example Actual parameter is matched by specified regular expression.
  #   object = mock()
  #   object.expects(:method_1).with(regexp_matches(/e/))
  #   object.method_1('hello')
  #   # no error raised
  # @example Actual parameter is not matched by specified regular expression.
  #   object = mock()
  #   object.expects(:method_1).with(regexp_matches(/a/))
  #   object.method_1('hello')
  #   # error raised, because method_1 was not called with a parameter that matched the
  #   # regular expression
  # @param regexp [Regexp] regular expression to match.
  # @return [RegexpMatches] parameter matcher.
  # @see Expectation#with
  #
  # source://mocha//lib/mocha/parameter_matchers/regexp_matches.rb#24
  def regexp_matches(regexp); end

  # @example Actual parameter does not respond with "FOO" when :upcase is invoked.
  #   object = mock()
  #   object.expects(:method_1).with(responds_with(:upcase, "BAR"))
  #   object.method_1("foo")
  #   # error raised, because "foo".upcase != "BAR"
  # @example Actual parameter responds with "FOO" when :upcase is invoked and "oof" when :reverse is invoked.
  #   object = mock()
  #   object.expects(:method_1).with(responds_with(upcase: "FOO", reverse: "oof"))
  #   object.method_1("foo")
  #   # no error raised, because "foo".upcase == "FOO" and "foo".reverse == "oof"
  # @example Actual parameter responds with "FOO" when :upcase is invoked.
  #   object = mock()
  #   object.expects(:method_1).with(responds_with(:upcase, "FOO"))
  #   object.method_1("foo")
  #   # no error raised, because "foo".upcase == "FOO"
  # @overload responds_with
  # @overload responds_with
  # @return [RespondsWith] parameter matcher.
  # @see Expectation#with
  #
  # source://mocha//lib/mocha/parameter_matchers/responds_with.rb#37
  def responds_with(*options); end

  # Matches any YAML that represents the specified +object+
  #
  # @example Actual parameter is YAML equivalent of specified +object+.
  #   object = mock()
  #   object.expects(:method_1).with(yaml_equivalent(1, 2, 3))
  #   object.method_1("--- \n- 1\n- 2\n- 3\n")
  #   # no error raised
  # @example Actual parameter is not YAML equivalent of specified +object+.
  #   object = mock()
  #   object.expects(:method_1).with(yaml_equivalent(1, 2, 3))
  #   object.method_1("--- \n- 1\n- 2\n")
  #   # error raised, because method_1 was not called with YAML representing the specified Array
  # @param object [Object] object whose YAML to compare.
  # @return [YamlEquivalent] parameter matcher.
  # @see Expectation#with
  #
  # source://mocha//lib/mocha/parameter_matchers/yaml_equivalent.rb#24
  def yaml_equivalent(object); end

  private

  # @private
  #
  # source://mocha//lib/mocha/parameter_matchers/has_entry.rb#82
  def parse_option(option); end
end

# Parameter matcher which combines a number of other matchers using a logical AND.
#
# source://mocha//lib/mocha/parameter_matchers/all_of.rb#28
class Mocha::ParameterMatchers::AllOf < ::Mocha::ParameterMatchers::Base
  # @private
  # @return [AllOf] a new instance of AllOf
  #
  # source://mocha//lib/mocha/parameter_matchers/all_of.rb#30
  def initialize(*matchers); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameter_matchers/all_of.rb#35
  def matches?(available_parameters); end

  # @private
  #
  # source://mocha//lib/mocha/parameter_matchers/all_of.rb#41
  def mocha_inspect; end
end

# Parameter matcher which combines a number of other matchers using a logical OR.
#
# source://mocha//lib/mocha/parameter_matchers/any_of.rb#34
class Mocha::ParameterMatchers::AnyOf < ::Mocha::ParameterMatchers::Base
  # @private
  # @return [AnyOf] a new instance of AnyOf
  #
  # source://mocha//lib/mocha/parameter_matchers/any_of.rb#36
  def initialize(*matchers); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameter_matchers/any_of.rb#41
  def matches?(available_parameters); end

  # @private
  #
  # source://mocha//lib/mocha/parameter_matchers/any_of.rb#47
  def mocha_inspect; end
end

# Parameter matcher which always matches whatever the parameters.
#
# source://mocha//lib/mocha/parameter_matchers/any_parameters.rb#26
class Mocha::ParameterMatchers::AnyParameters < ::Mocha::ParameterMatchers::Base
  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameter_matchers/any_parameters.rb#28
  def matches?(available_parameters); end

  # @private
  #
  # source://mocha//lib/mocha/parameter_matchers/any_parameters.rb#36
  def mocha_inspect; end
end

# Parameter matcher which always matches a single parameter.
#
# source://mocha//lib/mocha/parameter_matchers/anything.rb#23
class Mocha::ParameterMatchers::Anything < ::Mocha::ParameterMatchers::Base
  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameter_matchers/anything.rb#25
  def matches?(available_parameters); end

  # @private
  #
  # source://mocha//lib/mocha/parameter_matchers/anything.rb#31
  def mocha_inspect; end
end

# @abstract Subclass and implement +#matches?+ and +#mocha_inspect+ to define a custom matcher. Also add a suitably named instance method to {ParameterMatchers} to build an instance of the new matcher c.f. {#equals}.
#
# source://mocha//lib/mocha/parameter_matchers/base.rb#4
class Mocha::ParameterMatchers::Base
  # A shorthand way of combining two matchers when both must match.
  #
  # Returns a new {AllOf} parameter matcher combining two matchers using a logical AND.
  #
  # This shorthand will not work with an implicit equals match. Instead, an explicit {Equals} matcher should be used.
  #
  # @example Alternative ways to combine matchers with a logical AND.
  #   object = mock()
  #   object.expects(:run).with(all_of(has_key(:foo), has_key(:bar)))
  #   object.run(foo: 'foovalue', bar: 'barvalue')
  #
  #   # is exactly equivalent to
  #
  #   object.expects(:run).with(has_key(:foo) & has_key(:bar))
  #   object.run(foo: 'foovalue', bar: 'barvalue)
  # @param other [Base] parameter matcher.
  # @return [AllOf] parameter matcher.
  # @see Expectation#with
  #
  # source://mocha//lib/mocha/parameter_matchers/base.rb#25
  def &(other); end

  # A shorthand way of combining two matchers when at least one must match.
  #
  # Returns a new +AnyOf+ parameter matcher combining two matchers using a logical OR.
  #
  # This shorthand will not work with an implicit equals match. Instead, an explicit {Equals} matcher should be used.
  #
  # @example Alternative ways to combine matchers with a logical OR.
  #   object = mock()
  #   object.expects(:run).with(any_of(has_key(:foo), has_key(:bar)))
  #   object.run(foo: 'foovalue')
  #
  #   # is exactly equivalent to
  #
  #   object.expects(:run).with(has_key(:foo) | has_key(:bar))
  #   object.run(foo: 'foovalue')
  # @example Using an explicit {Equals} matcher in combination with {#|}.
  #   object.expects(:run).with(equals(1) | equals(2))
  #   object.run(1) # passes
  #   object.run(2) # passes
  #   object.run(3) # fails
  # @param other [Base] parameter matcher.
  # @return [AnyOf] parameter matcher.
  # @see Expectation#with
  #
  # source://mocha//lib/mocha/parameter_matchers/base.rb#55
  def |(other); end
end

# Parameter matcher which matches when actual parameter equals expected value.
#
# source://mocha//lib/mocha/parameter_matchers/equals.rb#29
class Mocha::ParameterMatchers::Equals < ::Mocha::ParameterMatchers::Base
  # @private
  # @return [Equals] a new instance of Equals
  #
  # source://mocha//lib/mocha/parameter_matchers/equals.rb#31
  def initialize(value); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameter_matchers/equals.rb#36
  def matches?(available_parameters); end

  # @private
  #
  # source://mocha//lib/mocha/parameter_matchers/equals.rb#42
  def mocha_inspect; end
end

# Parameter matcher which matches URIs with equivalent query strings.
#
# source://mocha//lib/mocha/parameter_matchers/equivalent_uri.rb#30
class Mocha::ParameterMatchers::EquivalentUri < ::Mocha::ParameterMatchers::Base
  # @private
  # @return [EquivalentUri] a new instance of EquivalentUri
  #
  # source://mocha//lib/mocha/parameter_matchers/equivalent_uri.rb#32
  def initialize(uri); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameter_matchers/equivalent_uri.rb#37
  def matches?(available_parameters); end

  # @private
  #
  # source://mocha//lib/mocha/parameter_matchers/equivalent_uri.rb#44
  def mocha_inspect; end

  private

  # @private
  #
  # source://mocha//lib/mocha/parameter_matchers/equivalent_uri.rb#51
  def explode(uri); end
end

# Parameter matcher which matches when actual parameter contains all expected +Hash+ entries.
#
# source://mocha//lib/mocha/parameter_matchers/has_entries.rb#31
class Mocha::ParameterMatchers::HasEntries < ::Mocha::ParameterMatchers::Base
  # @private
  # @return [HasEntries] a new instance of HasEntries
  #
  # source://mocha//lib/mocha/parameter_matchers/has_entries.rb#33
  def initialize(entries, exact: T.unsafe(nil)); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameter_matchers/has_entries.rb#39
  def matches?(available_parameters); end

  # @private
  #
  # source://mocha//lib/mocha/parameter_matchers/has_entries.rb#50
  def mocha_inspect; end
end

# Parameter matcher which matches when actual parameter contains expected +Hash+ entry.
#
# source://mocha//lib/mocha/parameter_matchers/has_entry.rb#58
class Mocha::ParameterMatchers::HasEntry < ::Mocha::ParameterMatchers::Base
  # @private
  # @return [HasEntry] a new instance of HasEntry
  #
  # source://mocha//lib/mocha/parameter_matchers/has_entry.rb#60
  def initialize(key, value); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameter_matchers/has_entry.rb#66
  def matches?(available_parameters); end

  # @private
  #
  # source://mocha//lib/mocha/parameter_matchers/has_entry.rb#74
  def mocha_inspect; end
end

# Parameter matcher which matches when actual parameter contains +Hash+ entry with expected key.
#
# source://mocha//lib/mocha/parameter_matchers/has_key.rb#29
class Mocha::ParameterMatchers::HasKey < ::Mocha::ParameterMatchers::Base
  # @private
  # @return [HasKey] a new instance of HasKey
  #
  # source://mocha//lib/mocha/parameter_matchers/has_key.rb#31
  def initialize(key); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameter_matchers/has_key.rb#36
  def matches?(available_parameters); end

  # @private
  #
  # source://mocha//lib/mocha/parameter_matchers/has_key.rb#43
  def mocha_inspect; end
end

# Parameter matcher which matches when actual parameter contains +Hash+ with all expected keys.
#
# source://mocha//lib/mocha/parameter_matchers/has_keys.rb#29
class Mocha::ParameterMatchers::HasKeys < ::Mocha::ParameterMatchers::Base
  # @private
  # @raise [ArgumentError]
  # @return [HasKeys] a new instance of HasKeys
  #
  # source://mocha//lib/mocha/parameter_matchers/has_keys.rb#31
  def initialize(*keys); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameter_matchers/has_keys.rb#38
  def matches?(available_parameters); end

  # @private
  #
  # source://mocha//lib/mocha/parameter_matchers/has_keys.rb#48
  def mocha_inspect; end
end

# Parameter matcher which matches when actual parameter contains +Hash+ entry with expected value.
#
# source://mocha//lib/mocha/parameter_matchers/has_value.rb#29
class Mocha::ParameterMatchers::HasValue < ::Mocha::ParameterMatchers::Base
  # @private
  # @return [HasValue] a new instance of HasValue
  #
  # source://mocha//lib/mocha/parameter_matchers/has_value.rb#31
  def initialize(value); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameter_matchers/has_value.rb#36
  def matches?(available_parameters); end

  # @private
  #
  # source://mocha//lib/mocha/parameter_matchers/has_value.rb#43
  def mocha_inspect; end
end

# Parameter matcher which matches when actual parameter includes expected values.
#
# source://mocha//lib/mocha/parameter_matchers/includes.rb#68
class Mocha::ParameterMatchers::Includes < ::Mocha::ParameterMatchers::Base
  # @private
  # @return [Includes] a new instance of Includes
  #
  # source://mocha//lib/mocha/parameter_matchers/includes.rb#70
  def initialize(*items); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameter_matchers/includes.rb#76
  def matches?(available_parameters); end

  # @private
  #
  # source://mocha//lib/mocha/parameter_matchers/includes.rb#96
  def mocha_inspect; end
end

# @private
#
# source://mocha//lib/mocha/parameter_matchers/instance_methods.rb#8
module Mocha::ParameterMatchers::InstanceMethods
  # @private
  #
  # source://mocha//lib/mocha/parameter_matchers/instance_methods.rb#10
  def to_matcher(expectation: T.unsafe(nil), top_level: T.unsafe(nil)); end
end

# Parameter matcher which matches when actual parameter is an instance of the specified class.
#
# source://mocha//lib/mocha/parameter_matchers/instance_of.rb#29
class Mocha::ParameterMatchers::InstanceOf < ::Mocha::ParameterMatchers::Base
  # @private
  # @return [InstanceOf] a new instance of InstanceOf
  #
  # source://mocha//lib/mocha/parameter_matchers/instance_of.rb#31
  def initialize(klass); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameter_matchers/instance_of.rb#36
  def matches?(available_parameters); end

  # @private
  #
  # source://mocha//lib/mocha/parameter_matchers/instance_of.rb#42
  def mocha_inspect; end
end

# Parameter matcher which matches when actual parameter is a specific class.
#
# source://mocha//lib/mocha/parameter_matchers/is_a.rb#30
class Mocha::ParameterMatchers::IsA < ::Mocha::ParameterMatchers::Base
  # @private
  # @return [IsA] a new instance of IsA
  #
  # source://mocha//lib/mocha/parameter_matchers/is_a.rb#32
  def initialize(klass); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameter_matchers/is_a.rb#37
  def matches?(available_parameters); end

  # @private
  #
  # source://mocha//lib/mocha/parameter_matchers/is_a.rb#43
  def mocha_inspect; end
end

# Parameter matcher which matches when actual parameter is a kind of specified class.
#
# source://mocha//lib/mocha/parameter_matchers/kind_of.rb#29
class Mocha::ParameterMatchers::KindOf < ::Mocha::ParameterMatchers::Base
  # @private
  # @return [KindOf] a new instance of KindOf
  #
  # source://mocha//lib/mocha/parameter_matchers/kind_of.rb#31
  def initialize(klass); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameter_matchers/kind_of.rb#36
  def matches?(available_parameters); end

  # @private
  #
  # source://mocha//lib/mocha/parameter_matchers/kind_of.rb#44
  def mocha_inspect; end
end

# Parameter matcher which inverts the logic of the specified matcher using a logical NOT operation.
#
# source://mocha//lib/mocha/parameter_matchers/not.rb#29
class Mocha::ParameterMatchers::Not < ::Mocha::ParameterMatchers::Base
  # @private
  # @return [Not] a new instance of Not
  #
  # source://mocha//lib/mocha/parameter_matchers/not.rb#31
  def initialize(matcher); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameter_matchers/not.rb#36
  def matches?(available_parameters); end

  # @private
  #
  # source://mocha//lib/mocha/parameter_matchers/not.rb#42
  def mocha_inspect; end
end

# Parameter matcher which allows optional parameters to be specified.
#
# source://mocha//lib/mocha/parameter_matchers/optionally.rb#38
class Mocha::ParameterMatchers::Optionally < ::Mocha::ParameterMatchers::Base
  # @private
  # @return [Optionally] a new instance of Optionally
  #
  # source://mocha//lib/mocha/parameter_matchers/optionally.rb#40
  def initialize(*parameters); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameter_matchers/optionally.rb#45
  def matches?(available_parameters); end

  # @private
  #
  # source://mocha//lib/mocha/parameter_matchers/optionally.rb#56
  def mocha_inspect; end
end

# @private
#
# source://mocha//lib/mocha/parameter_matchers/positional_or_keyword_hash.rb#9
class Mocha::ParameterMatchers::PositionalOrKeywordHash < ::Mocha::ParameterMatchers::Base
  # @return [PositionalOrKeywordHash] a new instance of PositionalOrKeywordHash
  #
  # source://mocha//lib/mocha/parameter_matchers/positional_or_keyword_hash.rb#10
  def initialize(value, expectation); end

  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameter_matchers/positional_or_keyword_hash.rb#15
  def matches?(available_parameters); end

  # source://mocha//lib/mocha/parameter_matchers/positional_or_keyword_hash.rb#29
  def mocha_inspect; end

  private

  # source://mocha//lib/mocha/parameter_matchers/positional_or_keyword_hash.rb#43
  def deprecation_warning(actual, expected); end

  # source://mocha//lib/mocha/parameter_matchers/positional_or_keyword_hash.rb#59
  def expectation_definition; end

  # source://mocha//lib/mocha/parameter_matchers/positional_or_keyword_hash.rb#35
  def extract_parameter(available_parameters); end

  # source://mocha//lib/mocha/parameter_matchers/positional_or_keyword_hash.rb#51
  def hash_type(hash); end

  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameter_matchers/positional_or_keyword_hash.rb#55
  def ruby2_keywords_hash?(hash); end

  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameter_matchers/positional_or_keyword_hash.rb#39
  def same_type_of_hash?(actual, expected); end
end

# Parameter matcher which matches if specified regular expression matches actual paramter.
#
# source://mocha//lib/mocha/parameter_matchers/regexp_matches.rb#29
class Mocha::ParameterMatchers::RegexpMatches < ::Mocha::ParameterMatchers::Base
  # @private
  # @return [RegexpMatches] a new instance of RegexpMatches
  #
  # source://mocha//lib/mocha/parameter_matchers/regexp_matches.rb#31
  def initialize(regexp); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameter_matchers/regexp_matches.rb#36
  def matches?(available_parameters); end

  # @private
  #
  # source://mocha//lib/mocha/parameter_matchers/regexp_matches.rb#43
  def mocha_inspect; end
end

# Parameter matcher which matches if actual parameter returns expected result when specified method is invoked.
#
# source://mocha//lib/mocha/parameter_matchers/responds_with.rb#57
class Mocha::ParameterMatchers::RespondsWith < ::Mocha::ParameterMatchers::Base
  # @private
  # @return [RespondsWith] a new instance of RespondsWith
  #
  # source://mocha//lib/mocha/parameter_matchers/responds_with.rb#59
  def initialize(message, result); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameter_matchers/responds_with.rb#65
  def matches?(available_parameters); end

  # @private
  #
  # source://mocha//lib/mocha/parameter_matchers/responds_with.rb#71
  def mocha_inspect; end
end

# Parameter matcher which matches if actual parameter is YAML equivalent of specified object.
#
# source://mocha//lib/mocha/parameter_matchers/yaml_equivalent.rb#29
class Mocha::ParameterMatchers::YamlEquivalent < ::Mocha::ParameterMatchers::Base
  # @private
  # @return [YamlEquivalent] a new instance of YamlEquivalent
  #
  # source://mocha//lib/mocha/parameter_matchers/yaml_equivalent.rb#31
  def initialize(object); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameter_matchers/yaml_equivalent.rb#36
  def matches?(available_parameters); end

  # @private
  #
  # source://mocha//lib/mocha/parameter_matchers/yaml_equivalent.rb#44
  def mocha_inspect; end
end

# source://mocha//lib/mocha/parameters_matcher.rb#5
class Mocha::ParametersMatcher
  # @return [ParametersMatcher] a new instance of ParametersMatcher
  #
  # source://mocha//lib/mocha/parameters_matcher.rb#6
  def initialize(expected_parameters = T.unsafe(nil), expectation = T.unsafe(nil), &matching_block); end

  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameters_matcher.rb#12
  def match?(actual_parameters = T.unsafe(nil)); end

  # source://mocha//lib/mocha/parameters_matcher.rb#34
  def matchers; end

  # source://mocha//lib/mocha/parameters_matcher.rb#24
  def mocha_inspect; end

  # @return [Boolean]
  #
  # source://mocha//lib/mocha/parameters_matcher.rb#20
  def parameters_match?(actual_parameters); end
end

# source://mocha//lib/mocha/ruby_version.rb#2
Mocha::RUBY_V27_PLUS = T.let(T.unsafe(nil), TrueClass)

# source://mocha//lib/mocha/ruby_version.rb#3
Mocha::RUBY_V34_PLUS = T.let(T.unsafe(nil), TrueClass)

# source://mocha//lib/mocha/raised_exception.rb#2
class Mocha::RaisedException
  # @return [RaisedException] a new instance of RaisedException
  #
  # source://mocha//lib/mocha/raised_exception.rb#3
  def initialize(exception); end

  # source://mocha//lib/mocha/raised_exception.rb#7
  def mocha_inspect; end
end

# source://mocha//lib/mocha/return_values.rb#4
class Mocha::ReturnValues
  # @return [ReturnValues] a new instance of ReturnValues
  #
  # source://mocha//lib/mocha/return_values.rb#11
  def initialize(*values); end

  # source://mocha//lib/mocha/return_values.rb#23
  def +(other); end

  # source://mocha//lib/mocha/return_values.rb#15
  def next(invocation); end

  # Returns the value of attribute values.
  #
  # source://mocha//lib/mocha/return_values.rb#9
  def values; end

  # Sets the attribute values
  #
  # @param value the value to set the attribute values to.
  #
  # source://mocha//lib/mocha/return_values.rb#9
  def values=(_arg0); end

  class << self
    # source://mocha//lib/mocha/return_values.rb#5
    def build(*values); end
  end
end

# Used to constrain the order in which expectations can occur.
#
# @see API#sequence
# @see Expectation#in_sequence
#
# source://mocha//lib/mocha/sequence.rb#6
class Mocha::Sequence
  # @private
  # @return [Sequence] a new instance of Sequence
  #
  # source://mocha//lib/mocha/sequence.rb#24
  def initialize(name); end

  # @private
  #
  # source://mocha//lib/mocha/sequence.rb#30
  def constrain_as_next_in_sequence(expectation); end

  # @private
  #
  # source://mocha//lib/mocha/sequence.rb#42
  def mocha_inspect; end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/sequence.rb#37
  def satisfied_to_index?(index); end
end

# @private
#
# source://mocha//lib/mocha/sequence.rb#8
class Mocha::Sequence::InSequenceOrderingConstraint
  # @return [InSequenceOrderingConstraint] a new instance of InSequenceOrderingConstraint
  #
  # source://mocha//lib/mocha/sequence.rb#9
  def initialize(sequence, index); end

  # @return [Boolean]
  #
  # source://mocha//lib/mocha/sequence.rb#14
  def allows_invocation_now?; end

  # source://mocha//lib/mocha/sequence.rb#18
  def mocha_inspect; end
end

# source://mocha//lib/mocha/single_return_value.rb#4
class Mocha::SingleReturnValue
  # @return [SingleReturnValue] a new instance of SingleReturnValue
  #
  # source://mocha//lib/mocha/single_return_value.rb#5
  def initialize(value); end

  # source://mocha//lib/mocha/single_return_value.rb#9
  def evaluate(invocation); end
end

# A state machine that is used to constrain the order of invocations.
# An invocation can be constrained to occur when a state {#is}, or {#is_not}, active.
#
# source://mocha//lib/mocha/state_machine.rb#4
class Mocha::StateMachine
  # @private
  # @return [StateMachine] a new instance of StateMachine
  #
  # source://mocha//lib/mocha/state_machine.rb#41
  def initialize(name); end

  # Put the {StateMachine} into the +next_state_name+.
  #
  # @param next_state_name [String] name of new state
  #
  # source://mocha//lib/mocha/state_machine.rb#58
  def become(next_state_name); end

  # @private
  #
  # source://mocha//lib/mocha/state_machine.rb#38
  def current_state; end

  # @private
  #
  # source://mocha//lib/mocha/state_machine.rb#38
  def current_state=(_arg0); end

  # Provides mechanisms to (a) determine whether the {StateMachine} is in a given state; or (b) to change the {StateMachine} into the given state.
  #
  # @overload is
  # @overload is
  # @param state_name [String] name of expected/desired state.
  # @return [StatePredicate, State] (a) state predicate which, when queried, will indicate whether the {StateMachine} is in the given state; or (b) state which, when activated, will change the {StateMachine} into the given state.
  #
  # source://mocha//lib/mocha/state_machine.rb#76
  def is(state_name); end

  # Provides a mechanism to determine whether the {StateMachine} is *not* in the state specified by +unexpected_state_name+ at some point in the future.
  #
  # @param unexpected_state_name [String] name of unexpected state.
  # @return [StatePredicate] state predicate which, when queried, will indicate whether the {StateMachine} is *not* in the state specified by +unexpected_state_name+.
  #
  # source://mocha//lib/mocha/state_machine.rb#84
  def is_not(unexpected_state_name); end

  # @private
  #
  # source://mocha//lib/mocha/state_machine.rb#89
  def mocha_inspect; end

  # @private
  #
  # source://mocha//lib/mocha/state_machine.rb#35
  def name; end

  # Put the {StateMachine} into the state specified by +initial_state_name+.
  #
  # @param initial_state_name [String] name of initial state
  # @return [StateMachine] state machine, thereby allowing invocations of other {StateMachine} methods to be chained.
  #
  # source://mocha//lib/mocha/state_machine.rb#50
  def starts_as(initial_state_name); end
end

# Provides a mechanism to change the state of a {StateMachine} at some point in the future.
#
# source://mocha//lib/mocha/state_machine.rb#27
class Mocha::StateMachine::State < ::Mocha::StateMachine::StatePredicate
  # @private
  #
  # source://mocha//lib/mocha/state_machine.rb#29
  def activate; end
end

# Provides the ability to determine whether a {StateMachine} is in a specified state at some point in the future.
#
# source://mocha//lib/mocha/state_machine.rb#6
class Mocha::StateMachine::StatePredicate
  # @private
  # @return [StatePredicate] a new instance of StatePredicate
  #
  # source://mocha//lib/mocha/state_machine.rb#8
  def initialize(state_machine, state, description, &active_check); end

  # @private
  # @return [Boolean]
  #
  # source://mocha//lib/mocha/state_machine.rb#16
  def active?; end

  # @private
  #
  # source://mocha//lib/mocha/state_machine.rb#21
  def mocha_inspect; end
end

# source://mocha//lib/mocha/stubbed_method.rb#5
class Mocha::StubbedMethod
  # @return [StubbedMethod] a new instance of StubbedMethod
  #
  # source://mocha//lib/mocha/stubbed_method.rb#10
  def initialize(stubbee, method_name); end

  # source://mocha//lib/mocha/stubbed_method.rb#62
  def ==(_arg0); end

  # source://mocha//lib/mocha/stubbed_method.rb#43
  def define_new_method; end

  # source://mocha//lib/mocha/stubbed_method.rb#37
  def hide_original_method; end

  # @return [Boolean]
  #
  # source://mocha//lib/mocha/stubbed_method.rb#57
  def matches?(other); end

  # Returns the value of attribute method_name.
  #
  # source://mocha//lib/mocha/stubbed_method.rb#8
  def method_name; end

  # source://mocha//lib/mocha/stubbed_method.rb#29
  def mock; end

  # source://mocha//lib/mocha/stubbed_method.rb#53
  def remove_new_method; end

  # source://mocha//lib/mocha/stubbed_method.rb#33
  def reset_mocha; end

  # source://mocha//lib/mocha/stubbed_method.rb#17
  def stub; end

  # Returns the value of attribute stubbee.
  #
  # source://mocha//lib/mocha/stubbed_method.rb#8
  def stubbee; end

  # source://mocha//lib/mocha/stubbed_method.rb#64
  def to_s; end

  # source://mocha//lib/mocha/stubbed_method.rb#22
  def unstub; end

  private

  # source://mocha//lib/mocha/stubbed_method.rb#70
  def retain_original_visibility(method_owner); end

  # source://mocha//lib/mocha/stubbed_method.rb#75
  def store_original_method_visibility; end

  # source://mocha//lib/mocha/stubbed_method.rb#84
  def stub_method_owner; end

  # source://mocha//lib/mocha/stubbed_method.rb#79
  def use_prepended_module_for_stub_method; end
end

class Mocha::StubbedMethod::PrependedModule < ::Module; end

# Exception raised when stubbing a particular method is not allowed.
#
# @see Configuration.prevent
#
# source://mocha//lib/mocha/stubbing_error.rb#7
class Mocha::StubbingError < ::Mocha::ErrorWithFilteredBacktrace; end

# source://mocha//lib/mocha/thrower.rb#2
class Mocha::Thrower
  # @return [Thrower] a new instance of Thrower
  #
  # source://mocha//lib/mocha/thrower.rb#3
  def initialize(tag, object = T.unsafe(nil)); end

  # source://mocha//lib/mocha/thrower.rb#8
  def evaluate(invocation); end
end

# source://mocha//lib/mocha/thrown_object.rb#2
class Mocha::ThrownObject
  # @return [ThrownObject] a new instance of ThrownObject
  #
  # source://mocha//lib/mocha/thrown_object.rb#3
  def initialize(tag, value = T.unsafe(nil)); end

  # source://mocha//lib/mocha/thrown_object.rb#8
  def mocha_inspect; end
end

# source://mocha//lib/mocha/version.rb#2
Mocha::VERSION = T.let(T.unsafe(nil), String)

# source://mocha//lib/mocha/yield_parameters.rb#2
class Mocha::YieldParameters
  # @return [YieldParameters] a new instance of YieldParameters
  #
  # source://mocha//lib/mocha/yield_parameters.rb#3
  def initialize; end

  # source://mocha//lib/mocha/yield_parameters.rb#15
  def add(*parameter_groups); end

  # source://mocha//lib/mocha/yield_parameters.rb#7
  def next_invocation; end
end

# @private
#
# source://mocha//lib/mocha/parameter_matchers/instance_methods.rb#24
class Object < ::BasicObject
  include ::Kernel
  include ::PP::ObjectMixin
  include ::Mocha::ParameterMatchers::InstanceMethods
  include ::Mocha::Inspect::ObjectMethods
  include ::Mocha::ObjectMethods

  # :stopdoc:
  #
  # source://mocha//lib/mocha/is_a.rb#4
  def __is_a__(_arg0); end
end

# source://mocha//lib/mocha/inspect.rb#64
class Time
  include ::Comparable
  include ::Mocha::Inspect::TimeMethods
end
