## Version 1.4.5 [ETL] [core] [studio]
- [`5e0476b`](https://github.com/synfig/synfig/commit/5e0476bcc263b8906eb3855821a59f336d6be8ab) Fix distortions at the end of lines made with the drawing tool ([#2471](https://github.com/synfig/synfig/issues/2471)) [studio]
- [`015305a`](https://github.com/synfig/synfig/commit/015305ae9fd56ff23a7b0b25c27e7f159a555d3d) fix: crash on moving a layer following a bline reference ([#2971](https://github.com/synfig/synfig/issues/2971)) [core] [studio]
- [`feb62c5`](https://github.com/synfig/synfig/commit/feb62c586f9b8c5378ce724854c7180d674e8326) Replaced `abs` with `std::fabs` for float values and `std::abs` for templates and int values ([#2311](https://github.com/synfig/synfig/issues/2311)) [ETL] [core] [studio]
- [`4c3f97d`](https://github.com/synfig/synfig/commit/4c3f97dfd4340b74e72f0b2a033aeed70b6efc5a) fix importing into unsaved SIF file ([#2243](https://github.com/synfig/synfig/issues/2243)) [studio]
- [`db959bf`](https://github.com/synfig/synfig/commit/db959bf7d062bdb0eb658ddabb2735385a8872aa) Merge PR [#2505](https://github.com/synfig/synfig/issues/2505): Fixed issue with opening a file from a network folder on Windows [core]
- [`86d3434`](https://github.com/synfig/synfig/commit/86d3434b9356064015d4dfe4fffd57ef25a1f9c8) Fixed Synfig Studio crash on exit (MacOS) ([#2540](https://github.com/synfig/synfig/issues/2540)) [studio]
- [`3e130dc`](https://github.com/synfig/synfig/commit/3e130dc3de7161fa8385b8cd9f3a5920d3c20f18) fix: crash with a bline containing only 2 points that are too close ([#2855](https://github.com/synfig/synfig/issues/2855)) [studio]
- [`2f4b441`](https://github.com/synfig/synfig/commit/2f4b441d4b04f4e20cd1c0f40e18c7f4afe13903) chore: bump year to 2024 ([#3299](https://github.com/synfig/synfig/issues/3299)) [studio]
- [`784dbb1`](https://github.com/synfig/synfig/commit/784dbb1c773e9f1e6c145fa571b7083613106027) fix: crash occurs under Wayland when using tablet ([#2988](https://github.com/synfig/synfig/issues/2988)) [studio]
- [`d0dba5b`](https://github.com/synfig/synfig/commit/d0dba5bd7aaa2ec3008b26050a0f73565d986b04) fix: a crash on program exit if bones were used ([#3037](https://github.com/synfig/synfig/issues/3037)) [core]
- [`b5c8aa4`](https://github.com/synfig/synfig/commit/b5c8aa4dfc0546fe5a9b5c9ea64969f50ff1aaa0) fix: crash when clicking on rows of "Library Panel"  ([#3046](https://github.com/synfig/synfig/issues/3046)) [studio]
- [`0e662dd`](https://github.com/synfig/synfig/commit/0e662dd1a22c6d9ff87699546bb2ffb900e85f37) fix: button `Open With History` is enabled only for .sfg files ([#3101](https://github.com/synfig/synfig/issues/3101)) [studio]
- [`87e1315`](https://github.com/synfig/synfig/commit/87e131531c9f91be512650134227522fba756d72) fix: selecting a handle while the Graphs window tooltip is open crashes the GUI ([#3207](https://github.com/synfig/synfig/issues/3207)) [studio]
- [`04afca0`](https://github.com/synfig/synfig/commit/04afca0085ec08dafafd033cefc210ca45ae4781) fix: added ImageMagick 7.1 library initialization ([#2876](https://github.com/synfig/synfig/issues/2876)) [core]
- [`566fd7f`](https://github.com/synfig/synfig/commit/566fd7fa09f780caa7015196dc6c468944503c3b) perf: avoid canvas introspection when DockInfo is not shown ([#3328](https://github.com/synfig/synfig/issues/3328)) [studio]
- [`674888a`](https://github.com/synfig/synfig/commit/674888a710f46b2a3cb6a4126757f22139c0a09c) fix: prevent memory leak on importing PNG files ([#3144](https://github.com/synfig/synfig/issues/3144)) [core]

## Version 1.4.4 [ETL] [core] [studio]
- [`f6f153b`](https://github.com/synfig/synfig/commit/f6f153b5551f97cc6b50546ff53ca3c791d1c5cc) fix: missing last frame for ffmpeg target ([#2912](https://github.com/synfig/synfig/issues/2912)) [core]
- [`0ab9d69`](https://github.com/synfig/synfig/commit/0ab9d69e4ce0b923d22185b2f6508b71ea7162cd) Merge PR ([#2445](https://github.com/synfig/synfig/issues/2445)): Fixed crash when using Draw tool (Fedora/Flatpak) [studio]
- [`93d8f4c`](https://github.com/synfig/synfig/commit/93d8f4cb1b149dca8a6415f6f3cbfab0d22a4778) fix: Synfig CLI does not open file if path contains non-Latin characters (Windows) ([#2819](https://github.com/synfig/synfig/issues/2819)) [core]
- [`bb36171`](https://github.com/synfig/synfig/commit/bb361718bc6d061d010e5d6ab5bebeeaae59ad71) fix: Right-clicking a layer on a just opened file shows empty menu ([#2781](https://github.com/synfig/synfig/issues/2781)) [studio]
- [`e06c83f`](https://github.com/synfig/synfig/commit/e06c83fbdcf01e6c73d67321926a52cc92ebaa38) build(autotools): allow to compile release build with debug info ([#2838](https://github.com/synfig/synfig/issues/2838)) [ETL] [core] [studio]
- [`54ba18f`](https://github.com/synfig/synfig/commit/54ba18f2ff9a222b1bd8eb01f04cd88d4a54e188) Added support MLT++-7 in Autotools ([#2306](https://github.com/synfig/synfig/issues/2306)) [core]
- [`081d9ab`](https://github.com/synfig/synfig/commit/081d9ab94fee9e3083b6db3a9f7f4dd002847d57) Merge PR [#2722](https://github.com/synfig/synfig/issues/2722): fix: palette loading [core]
- [`8cc24b1`](https://github.com/synfig/synfig/commit/8cc24b13868072e54b3cfa70488102cb5864e69a) fix: Synfig hangs when importing palette ([#2730](https://github.com/synfig/synfig/issues/2730)) [core]
- [`091ac5c`](https://github.com/synfig/synfig/commit/091ac5c820f3bc6c9db773bfdd8669cc3ae23eb0) Fixed messed up translations for Russian language [core] [studio]

## Version 1.4.3 [ETL] [core] [studio]
- [`042c737`](https://github.com/synfig/synfig/commit/042c7378917c32af4354bac5d35283a63a7b828c) Fix bug with src offset in blur sw task ([#2570](https://github.com/synfig/synfig/issues/2570)) [core]
- [`249cee7`](https://github.com/synfig/synfig/commit/249cee7d22df2501b4413c46be7d284687d3659a) fix layer Clamp not rendering ([#2550](https://github.com/synfig/synfig/issues/2550)) [core]
- [`ac8b5e0`](https://github.com/synfig/synfig/commit/ac8b5e02e3ab36fd0f49708086837cc36be9de62) chore: Enabled some strings for translation ([#2768](https://github.com/synfig/synfig/issues/2768)) [studio]
- [`68d8a25`](https://github.com/synfig/synfig/commit/68d8a25c1e10905acd2b28ab23f255c08ed4615d) Fixed crash when deleting last waypoint ([#2587](https://github.com/synfig/synfig/issues/2587)) [studio]
- [`e23b229`](https://github.com/synfig/synfig/commit/e23b229208f2cc9e8b37c46857eeaf629b4d8e1a) perf: improved file opening speed in Windows ([#2826](https://github.com/synfig/synfig/issues/2826)) [core] [studio]
- [`3015a77`](https://github.com/synfig/synfig/commit/3015a77900d9aebb759dd907f5825c4d5e720903) fix: don't allow to Connect to exported value node if it has wrong type ([#2694](https://github.com/synfig/synfig/issues/2694)) [studio]
- [`3ea8fe6`](https://github.com/synfig/synfig/commit/3ea8fe60ec87a489a7dda3e0882222f339124dd2) Fixed issue with autosave not working when interval is set to 15 seconds. ([#2647](https://github.com/synfig/synfig/issues/2647)) [studio]
- [`2a11e92`](https://github.com/synfig/synfig/commit/2a11e920a6a8394184aaa3085d6150718657a451) fix regression: importing papagayo file didn't show the expected layers ([#2495](https://github.com/synfig/synfig/issues/2495)) [studio]
- [`34b9c43`](https://github.com/synfig/synfig/commit/34b9c43c5c5a69816543478f0e77acf3708f88aa) Fixed video render with ffmpeg 3.x ([#2628](https://github.com/synfig/synfig/issues/2628)) [core]
- [`61c6f49`](https://github.com/synfig/synfig/commit/61c6f49d79f1cc562e1171fe3638664d846508e0) Bumped year ([#2623](https://github.com/synfig/synfig/issues/2623)) [studio]
- [`9ef1c59`](https://github.com/synfig/synfig/commit/9ef1c59fc345350461dfa3fef8f45d0dc091a177) Fix module search path for Lottie Exporter ([#2621](https://github.com/synfig/synfig/issues/2621)) [studio]
- [`590560f`](https://github.com/synfig/synfig/commit/6732c6cc6c689176eaa2fa8dfa7aaaa20f3f9340) prevent ambiguity of 'abs(synfig::Real&)' on Plant ([#2617](https://github.com/synfig/synfig/issues/2617))
- [`590560f`](https://github.com/synfig/synfig/commit/71775e696d32388b0f04a267c02a3785732f4bdc) Update contributor name list ([#2601](https://github.com/synfig/synfig/issues/2601))
- [`590560f`](https://github.com/synfig/synfig/commit/590560fe1c4c6e63e794cd762d91ae1eece4937c) Switched Ubuntu version on Github Workflows to 18.04 ([#2322](https://github.com/synfig/synfig/issues/2322))
- [`b3b88c9`](https://github.com/synfig/synfig/commit/b3b88c9ad03d51ef2cf82b323eadd121429a9f33) ETL test: avoid clash between ETL::hermite and std::hermite ([#2547](https://github.com/synfig/synfig/issues/2547)) [ETL]
- [`1f202d3`](https://github.com/synfig/synfig/commit/1f202d3cb9bc0149f8e28b555dc6d384fb4bc533) Merge PR ([#2399](https://github.com/synfig/synfig/issues/2399)): ETL cleanup: remove unused files and deprecated functions [ETL] [core]
- [`7c8878b`](https://github.com/synfig/synfig/commit/7c8878b7cd735b72b637a794ddb7cbdda7ba3462) Removed tests for `fixed` class ([#2521](https://github.com/synfig/synfig/issues/2521)) [ETL]
- [`b4d1f62`](https://github.com/synfig/synfig/commit/b4d1f62778ea1c62215f7296509458ef67bc96ce) loadcanvas: fix loading of some non-value nodes lists ([#2482](https://github.com/synfig/synfig/issues/2482)) [core]
- [`65303bc`](https://github.com/synfig/synfig/commit/65303bc518cef3381bb537b0e29d61d1f3849e31) fix crash when using Width Tool on Skeleton Layer ([#2500](https://github.com/synfig/synfig/issues/2500)) [studio]
- [`2943fdc`](https://github.com/synfig/synfig/commit/2943fdc0191b081c90d2ce6cd34c226ef76719cf) BoneLink: Ask if user wants to link transformation instead of origin ([#2468](https://github.com/synfig/synfig/issues/2468)) [studio]
- [`7fe4274`](https://github.com/synfig/synfig/commit/7fe42741fa7282a448368d7b30e54ef61eebeca1) Fix exported file with audio being smaller than it should ([#2477](https://github.com/synfig/synfig/issues/2477)) [core]
- [`3d47605`](https://github.com/synfig/synfig/commit/3d47605f69b0758397c0a2f69c2fd0c08089b2de) Make sure flags are correctly updated when setting renddesc or toggling ([#2463](https://github.com/synfig/synfig/issues/2463)) [studio]
- [`33cc306`](https://github.com/synfig/synfig/commit/33cc30613bf0586a5abe74decf787bbbf786a37a) Parameters and Timeline panels show the same row selected ([#2422](https://github.com/synfig/synfig/issues/2422)) [studio]
- [`83828f0`](https://github.com/synfig/synfig/commit/83828f0da7b5e6a72976eb298fa0eae9eab7f4e2) Revert changes for Panel Tabs made in [#2189](https://github.com/synfig/synfig/issues/2189) ([#2436](https://github.com/synfig/synfig/issues/2436)) [studio]
- [`27ea632`](https://github.com/synfig/synfig/commit/27ea632ec8b214ccdbc37034dcda563672010a1d) Usability tweaks ([#2189](https://github.com/synfig/synfig/issues/2189)) [studio]
- [`e932a39`](https://github.com/synfig/synfig/commit/e932a39ca8e6aca097a77622b5a7df91c2b0abe8) Allow Bones parameters to be connected to exported value nodes ([#2433](https://github.com/synfig/synfig/issues/2433)) [core]
- [`326ee01`](https://github.com/synfig/synfig/commit/326ee01f2f07b95af83ad6b52435baa42015247d) Fixed crash when rendering to gif target ([#2389](https://github.com/synfig/synfig/issues/2389)) [core]
- [`7b8f9c7`](https://github.com/synfig/synfig/commit/7b8f9c76bc569a3095ff130093bd0e719874070f) Fixed issue with Text Tool not working on MacOS because of missing "fonts.conf" file ([#2380](https://github.com/synfig/synfig/issues/2380))
- [`19a88f4`](https://github.com/synfig/synfig/commit/19a88f4400a727b0080c26f9ba833647369181c3) Added `seekpos` method for FileSystemNative::ReadStream ([#2224](https://github.com/synfig/synfig/issues/2224)) [core]
- [`5e19882`](https://github.com/synfig/synfig/commit/5e19882b8cf3a0ea67de5c394e9f350b96d81a39) Enable "Link width and height" by default in Render Settings ([#2351](https://github.com/synfig/synfig/issues/2351)) [studio]
- [`87cc5d2`](https://github.com/synfig/synfig/commit/87cc5d28090b172eabdf7f92baaded3bd20cd01e) Apply action to all selected layers from pop-over menu ([#2352](https://github.com/synfig/synfig/issues/2352)) [studio]
- [`e6ae677`](https://github.com/synfig/synfig/commit/e6ae677cbea5a9e81b7ef9764576381625da4629) Dock widget shortcuts have priority over App Accels - fix [#1820](https://github.com/synfig/synfig/issues/1820) ([#1827](https://github.com/synfig/synfig/issues/1827)) [studio]
- [`21e1a3e`](https://github.com/synfig/synfig/commit/21e1a3e0e7e42dafc8c959d54ac461d325f680d2) Fix regression on Link To Spline: Vertex should be linkable ([#2345](https://github.com/synfig/synfig/issues/2345)). Closes [#2344](https://github.com/synfig/synfig/issues/2344). [studio]
- [`798bfbf`](https://github.com/synfig/synfig/commit/798bfbf95983ff6c01ca019ac72b390fbc259eab) Fixed a crash when trying to import a file into yourself ([#2239](https://github.com/synfig/synfig/issues/2239)) [studio]
- [`c0bebf6`](https://github.com/synfig/synfig/commit/c0bebf68b97fbc0b5451da07b9291234a9197793) Fix possible crash on get_local_name() of Layer_PasteCanvas ([#2300](https://github.com/synfig/synfig/issues/2300)) [core]
- [`dda0317`](https://github.com/synfig/synfig/commit/dda03175bad54c445fdf671636335c6cd59380ec) Fix regression: importing image making it upside-down ([#2333](https://github.com/synfig/synfig/issues/2333)) [studio]
- [`5c930dc`](https://github.com/synfig/synfig/commit/5c930dc8a3d71f7bcba9d4b71deed297642baf74) Fix image size when importing onto canvas with non-standard size ([#2252](https://github.com/synfig/synfig/issues/2252)) [studio]
- [`576c349`](https://github.com/synfig/synfig/commit/576c349ae84f2490f4997581f3b4cc0750e0a61b) Autotools: Remove @MAGICKPP_LIBS@ variable from LDFLAGS([#2326](https://github.com/synfig/synfig/issues/2326)) [core]
- [`391f8a1`](https://github.com/synfig/synfig/commit/391f8a1540b4c9339bb1141f4067221f6cc87b8b) Fix magick++ target missing in AppImage (issue [#2320](https://github.com/synfig/synfig/issues/2320)) ([#2324](https://github.com/synfig/synfig/issues/2324)) [core]
- [`b0d439b`](https://github.com/morevnaproject/morevna-builds/commit/b0d439ba0668a185512e1c49cae6caba25fe917a) Python updated to version 3.8.10 in Windows build.
- [`ef1f618`](https://github.com/morevnaproject/morevna-builds/commit/ef1f618802ce1dc9a302017da4b7b225ffde6222) Use 64bit Python build in 64bit packages for Windows.
- [`2e3aefb`](https://github.com/morevnaproject/morevna-builds/commit/2e3aefbb94cf5c7dc831a7f9c487ddae7568f889) Appimage: Fix fontconfig compatibility for recent linux distros.

## Version 1.4.2 [ETL] [core] [studio]
- [`b7305a9`](https://github.com/synfig/synfig/commit/b7305a9a3893caefffc1c36118e67f2f0610a1d5) Merge pull request [#1173](https://github.com/synfig/synfig/issues/1173) from rodolforg/fix-sound-dock-scroll
- [`ba211ba`](https://github.com/synfig/synfig/commit/ba211bafbe5963bc863ad4e99d38e73a3d96fe92) remove some unneeded headers ([#1963](https://github.com/synfig/synfig/issues/1963)) [studio]
- [`dbd27fb`](https://github.com/synfig/synfig/commit/dbd27fb50fedf129a7ea05a87297505ae13da55a) Remove old commented-out code (gui/layertree) ([#1429](https://github.com/synfig/synfig/issues/1429)) [studio]
- [`28696ba`](https://github.com/synfig/synfig/commit/28696ba976cbf6dfab33cf75da4a4b8aab31e44f) Merge PR [#1325](https://github.com/synfig/synfig/issues/1325): Allow enum parameter be edited with a double click instead of triple click
- [`29d8878`](https://github.com/synfig/synfig/commit/29d887824118dc8372994fdf27f73a3a9074a459) Merge PR [#1337](https://github.com/synfig/synfig/issues/1337): Single click for parameter editing [studio]
- [`2df3379`](https://github.com/synfig/synfig/commit/2df33799b30f777b6ff3818578ed376111094b49) Merge PR [#1351](https://github.com/synfig/synfig/issues/1351): Canvas, bone & sublayer parameters now pops up in one single click [studio]
- [`c2371f7`](https://github.com/synfig/synfig/commit/c2371f7955abb21edd716da45f5552ab9b5a0e38) Merge PR [#1979](https://github.com/synfig/synfig/issues/1979): [Synfig Studio] Minor cleanup on LayerTree (Improve LayerTree speed) [studio]
- [`6b0d418`](https://github.com/synfig/synfig/commit/6b0d4185255cc534940709c9001227d1ef52ba68) [Autotools] Fixed problem with missing \*.glsl files in distribution ([#1982](https://github.com/synfig/synfig/issues/1982)) [core]
- [`4ddd22d`](https://github.com/synfig/synfig/commit/4ddd22d8de1f4729c83fe0b0e8cde5b46fd84e87) Merge PR [#1995](https://github.com/synfig/synfig/issues/1995): [Core] create stringhelper [core] [studio]
- [`885f3ac`](https://github.com/synfig/synfig/commit/885f3ac6ebb87252439df7bbb2eec2eb8b29e2c4) [Core] Fix missing is_distance hint for vertex coordinates ([#2000](https://github.com/synfig/synfig/issues/2000)) [core]
- [`ab8cd14`](https://github.com/synfig/synfig/commit/ab8cd14891a389142695c47e0f9be68adbbca1a9) Merge PR [#2059](https://github.com/synfig/synfig/issues/2059): [Synfig Studio] fix action LayerDuplicate for skeleton and its bone links [studio]
- [`bbdd853`](https://github.com/synfig/synfig/commit/bbdd8536c7512d47724c8c166257ab416facf103) Merge PR [#2046](https://github.com/synfig/synfig/issues/2046): [Synfig Studio] some cleanup on synfigapp::ValueDescSet [studio]
- [`b660807`](https://github.com/synfig/synfig/commit/b6608075a87fe17e3615947b08a73ad91be05726) [Core/Studio] Fix missing const qualifier for some relational operators overrides ([#2001](https://github.com/synfig/synfig/issues/2001)) [core] [studio]
- [`0f7fb39`](https://github.com/synfig/synfig/commit/0f7fb391fb4c682515aaa94098ae85c180a92dbb) [Core] LinkableValueNode now provides methods for inverse manipulation ([#2057](https://github.com/synfig/synfig/issues/2057)) [core] [studio]
- [`b1468c7`](https://github.com/synfig/synfig/commit/b1468c7dead6f12e0882ac4cd364c445074d4cf7) [Synfig Studio] make TimeLoop valuenode editable via workspace ([#2066](https://github.com/synfig/synfig/issues/2066)) [core] [studio]
- [`65f50eb`](https://github.com/synfig/synfig/commit/65f50eb4e4c180243b58425620a0905ae0f7c01b) [Synfig Studio] fix skeleton deformation duplication ([#2071](https://github.com/synfig/synfig/issues/2071)) [core]
- [`6b5a3c8`](https://github.com/synfig/synfig/commit/6b5a3c8900916fe0a092ba37b9743333c7aa0906) [Synfig Studio] fix format string for synfigapp exception guard ([#2084](https://github.com/synfig/synfig/issues/2084)) [studio]
- [`61bd68a`](https://github.com/synfig/synfig/commit/61bd68a78fbe0912b226b24217085c8ef35a52b4) Exported canvas can be reopened again after closing ([#2092](https://github.com/synfig/synfig/issues/2092)) [studio]
- [`fd1e5ec`](https://github.com/synfig/synfig/commit/fd1e5ecdc3cf2cf9cb2ee642ca7f7b89aa04b40b) sometimes Widget_Vector didn't use locale for decimal separator ([#2102](https://github.com/synfig/synfig/issues/2102)) [core] [studio]
- [`3c0f04d`](https://github.com/synfig/synfig/commit/3c0f04d55e54459e36b7872812a07772989e74d0) Fixed 'locale::facet::_S_create_c_locale name not valid' error when compiling with MinGW compiler ([#2157](https://github.com/synfig/synfig/issues/2157)) [core]
- [`48959a9`](https://github.com/synfig/synfig/commit/48959a99ad979ff72fc07280e814d87ef2932690) Merge PR [#1929](https://github.com/synfig/synfig/issues/1929): [Synfig Studio] Added ability to undock panel using the context menu command [studio]
- [`8fdfae6`](https://github.com/synfig/synfig/commit/8fdfae6877260c265ffb8a60567740441f77d413) [Synfig Studio] fix 'Undock Panel' menu item always showing ([#2109](https://github.com/synfig/synfig/issues/2109)) [studio]
- [`81b13a4`](https://github.com/synfig/synfig/commit/81b13a488b9d958d53a2bd910a47ac896d0071eb) Close tabs with middle mouse click ([#2107](https://github.com/synfig/synfig/issues/2107)) [studio]
- [`b2b4b91`](https://github.com/synfig/synfig/commit/b2b4b918511463cbd50813366e9e73b9003341de) Fixed an issue due to which menus were not displayed on all panels except the canvas ([#2120](https://github.com/synfig/synfig/issues/2120)) [studio]
- [`926d5e2`](https://github.com/synfig/synfig/commit/926d5e2ea8a70c1fde86e4949bcba9302a7fdece) Fixed crash when user drags a group to a child group ([#2116](https://github.com/synfig/synfig/issues/2116)) [studio]
- [`9b580c6`](https://github.com/synfig/synfig/commit/9b580c65825c73c9fcce8bcf58b12c0403b06b19) Merge PR[#1890](https://github.com/synfig/synfig/issues/1890): Fix crash in Spline Width and return of improper type in Spline converters
- [`9a2187c`](https://github.com/synfig/synfig/commit/9a2187cdb250c958f46c9d9357b53d6606bccf1d) Merge PR [#1260](https://github.com/synfig/synfig/issues/1260): Fixed exception throwing by mistake in dot-product valuenode creation [core]
- [`4789a5b`](https://github.com/synfig/synfig/commit/4789a5b864a290caf1d3081c84c17b79869f7a4c) [Core] A little refactoring of loadcanvas.cpp ([#1956](https://github.com/synfig/synfig/issues/1956)) [core]
- [`d76d77f`](https://github.com/synfig/synfig/commit/d76d77fc4d58a847e5883915ecca0c362b62a648) Fixed issue with saving `loop` flag in some dynamic lists ([#2165](https://github.com/synfig/synfig/issues/2165)) [core]
- [`d40c745`](https://github.com/synfig/synfig/commit/d40c74522e701d866abd4b1f2209a562c9fb169a) Merge PR [#1769](https://github.com/synfig/synfig/issues/1769): Improve Canvas Zoom Keyboard Shortcut UX [studio]
- [`fa4021d`](https://github.com/synfig/synfig/commit/fa4021de0c7df32af1420880a23aa95bff27bffd) improved navigation hotkeys - partially backported ([#1776](https://github.com/synfig/synfig/issues/1776)) [studio]
- [`207f7d7`](https://github.com/synfig/synfig/commit/207f7d7814df7d56bfffa6e4436b890b51c44647) Changed redo shortcut to Ctr+Y (Win)/Shift+Ctrl+Z (Linux) ([#1811](https://github.com/synfig/synfig/issues/1811)) [studio]
- [`2d4d8b0`](https://github.com/synfig/synfig/commit/2d4d8b01dd59912587b2b1f0a59c4908553f7306) Improving Keyboard Shortcuts for the toolbox items ([#1823](https://github.com/synfig/synfig/issues/1823)) [studio]
- [`9343c01`](https://github.com/synfig/synfig/commit/9343c01913e9617dfb672d490151f28b59006fb8) Implementing Canvas Zoom Legacy Keyboard shortcuts ([#1848](https://github.com/synfig/synfig/issues/1848)) [studio]
- [`3c71750`](https://github.com/synfig/synfig/commit/3c71750e8b0f6ade2f7bf0fea71e0a3e3f8d144f) Add accelerator key for Cutout tool ([#1855](https://github.com/synfig/synfig/issues/1855)) [studio]
- [`86cb9ce`](https://github.com/synfig/synfig/commit/86cb9ce0e412a2e58750516e63370ed1f0cfb86b) Merge PR [#1953](https://github.com/synfig/synfig/issues/1953): [Synfig Studio] Clean default accel map implementation [studio]
- [`505d8c5`](https://github.com/synfig/synfig/commit/505d8c55081d9c50b9c318a728b2fd35c7ddf678) [Synfig Studio] Implemented toggle animate hotkey ([#2033](https://github.com/synfig/synfig/issues/2033)) [studio]
- [`2b7587d`](https://github.com/synfig/synfig/commit/2b7587d24bbcf797bcbb3397fc3a132394c3e8d5) Improved error reporting [studio] ([#2156](https://github.com/synfig/synfig/issues/2156)) [studio]
- [`41d6ac0`](https://github.com/synfig/synfig/commit/41d6ac086e2bfc1ffed6bdd3d8bffd6e8326780c) Basic implementation of Keyboard Shortcut Editor ([#2160](https://github.com/synfig/synfig/issues/2160)) [studio]
- [`cad2917`](https://github.com/synfig/synfig/commit/cad291722c6d41ce46bfdbdc48db15552a332fec) Merge PR [#2172](https://github.com/synfig/synfig/issues/2172): Fix some shortcuts/accels - for item deletion and animation stop [studio]
- [`833307f`](https://github.com/synfig/synfig/commit/833307fe6c88d6db75502b187b1c6f7ba620b1ba) Merge PR [#2173](https://github.com/synfig/synfig/issues/2173): Shortcut editor more organized and asks for user confirmation [studio]
- [`93365c5`](https://github.com/synfig/synfig/commit/93365c51a509d6d013d7c0f76c7be64693c8fd75) Merge PR [#2137](https://github.com/synfig/synfig/issues/2137): Fix memory leaks on SVG parser/importer [core]
- [`d3906ca`](https://github.com/synfig/synfig/commit/d3906ca969de15df00776353d13387317e08ca38) Merge PR [#1853](https://github.com/synfig/synfig/issues/1853): `etl::clock` refactored to use `std::chrono` [ETL] [core]
- [`8091554`](https://github.com/synfig/synfig/commit/8091554d4ac86edc960083a93e267540b915d90a) Middle click on a tab now closes the root canvas only when all child canvases are closed ([#2210](https://github.com/synfig/synfig/issues/2210)) [studio]
- [`4f6e09c`](https://github.com/synfig/synfig/commit/4f6e09c576477df12dc2726efbcaee25f1914288) Merge PR [#1195](https://github.com/synfig/synfig/issues/1195): [Lottie exporter] Convert methods working with radius of simple circle layer [studio]
- [`afe6dc8`](https://github.com/synfig/synfig/commit/afe6dc83a4b30a59c5b93ad81c37c29e865fcfc1) [Lottie exporter] Add variable gamma correction (PR [#1179](https://github.com/synfig/synfig/issues/1179)) [studio]
- [`5e800fa`](https://github.com/synfig/synfig/commit/5e800fa9325f6558ed96882c2071741b69869148) Changes made to offsetKeyFrame file ([#1233](https://github.com/synfig/synfig/issues/1233)) [studio]
- [`786f25f`](https://github.com/synfig/synfig/commit/786f25f7f3985f14005d48cb7b0956f4435092d3) Merge PR [#1236](https://github.com/synfig/synfig/issues/1236): [Lottie Exporter] Add support for Sine convert method [studio]
- [`3b66367`](https://github.com/synfig/synfig/commit/3b66367e6217013c2b21377bf4ce64c4534a4a66) Add support for Cos convert and Integer convert method ([#1254](https://github.com/synfig/synfig/issues/1254)) [studio]
- [`eede90c`](https://github.com/synfig/synfig/commit/eede90c6a874eced59b77b3855a5f04a033813ed) [Lottie exporter] Add support for linear gradient ([#1286](https://github.com/synfig/synfig/issues/1286)) [studio]
- [`14667dd`](https://github.com/synfig/synfig/commit/14667ddf6f9b495b76517b276cb26f4b09aece17) [Lottie Exporter] Add support for aTan2 convert method ([#1363](https://github.com/synfig/synfig/issues/1363)) [studio]
- [`c9e9d2f`](https://github.com/synfig/synfig/commit/c9e9d2f0d3021779ea351f37ddf0665a4a1d76bb) [Lottie Exporter] Add support for Vector Angle convert method ([#1409](https://github.com/synfig/synfig/issues/1409)) [studio]
- [`9fc95fe`](https://github.com/synfig/synfig/commit/9fc95fe147179dac8f779881236d18fb76fa604c) [Lottie exporter] Refactor radial_composite convert method ([#1447](https://github.com/synfig/synfig/issues/1447)) [studio]
- [`c51cef4`](https://github.com/synfig/synfig/commit/c51cef4a4381edc249884c2ff4fd2efdb94b69c4) [Lottie Exporter] Add support for radial gradient layer ([#1446](https://github.com/synfig/synfig/issues/1446)) [studio]
- [`5102d5e`](https://github.com/synfig/synfig/commit/5102d5e149811ec9832736e5f3851f82ebe0f9cb) [Lottie Exporter] Added support for Vector X and Vector Y convert method ([#1516](https://github.com/synfig/synfig/issues/1516)) [studio]
- [`d2083d6`](https://github.com/synfig/synfig/commit/d2083d656aaa17490b7b8278be5686dd9a22cb22) [Lottie Exporter] Added support for Power Convert method ([#1515](https://github.com/synfig/synfig/issues/1515)) [studio]
- [`faad4ab`](https://github.com/synfig/synfig/commit/faad4ab5abc79d23fb189a99ee6d18cedf37b4d1) [Lottie Exporter] Add support for dot product convert method ([#1593](https://github.com/synfig/synfig/issues/1593)) [studio]
- [`6269d8f`](https://github.com/synfig/synfig/commit/6269d8f98ea130c9ad657aef12c09609226f125f) [Lottie Exporter] Add support for Logarithm convert method ([#1586](https://github.com/synfig/synfig/issues/1586)) [studio]
- [`7cd80d2`](https://github.com/synfig/synfig/commit/7cd80d2166ce088ccf25c39ca9ad8621d3ea83bc) [Lottie Exporter] Added support for reciprocal convert method ([#1619](https://github.com/synfig/synfig/issues/1619)) [studio]
- [`905994a`](https://github.com/synfig/synfig/commit/905994a7fb626cf53174c9365fa04b7b5ec428ee) [Lottie Exporter] Add support for range convert method ([#1606](https://github.com/synfig/synfig/issues/1606)) [studio]
- [`43ced7b`](https://github.com/synfig/synfig/commit/43ced7b9c8851a262a7c0a517fcec1c277698559) [Lottie Exporter] Add support for vectorlength convert method ([#1650](https://github.com/synfig/synfig/issues/1650)) [studio]
- [`d31d62d`](https://github.com/synfig/synfig/commit/d31d62da1a288798cb9423226be3c2a0c3c6f1bd) [Lottie Exporter] Add support for not convert method ([#1587](https://github.com/synfig/synfig/issues/1587)) [studio]
- [`ee4e533`](https://github.com/synfig/synfig/commit/ee4e533ed85f704e2f2f7ef4efbb08410424bc82) Merge PR [#1505](https://github.com/synfig/synfig/issues/1505): [Lottie Exporter] Add support for blur layers [studio]
- [`fd00d1c`](https://github.com/synfig/synfig/commit/fd00d1c9e559d79ce5fb43c3b60caf55f0a634ec) [Lottie exporter] Implement use-defs ([#2182](https://github.com/synfig/synfig/issues/2182)) [studio]
- [`7d83a44`](https://github.com/synfig/synfig/commit/7d83a445870fecc20a10851fbd99b822930735e6) Merge PR [#1199](https://github.com/synfig/synfig/issues/1199): [Lottie Exporter] Code cleanup for Lottie exporter plugin [studio]
- [`eaafbcb`](https://github.com/synfig/synfig/commit/eaafbcbd2a9afc17c88ff0c888a5ee21eb70be29) [Lottie exporter] Important comments regarding effects/fill.py ([#1213](https://github.com/synfig/synfig/issues/1213)) [studio]
- [`5d8a08b`](https://github.com/synfig/synfig/commit/5d8a08be5c8a257b8c32dcb23764487681cf7442) [Lottie Exporter] Code cleanup for Lottie exporter plugin ([#1226](https://github.com/synfig/synfig/issues/1226)) [studio]
- [`8943867`](https://github.com/synfig/synfig/commit/894386769881efe2702ff18b71054e6b1e9224fa) [Lottie exporter] Refactor lottie modules/Added named constants ([#1456](https://github.com/synfig/synfig/issues/1456)) [studio]
- [`71de9ff`](https://github.com/synfig/synfig/commit/71de9ff60b337c952abd983563cc7736a00ad714) Fix various typos ([#2061](https://github.com/synfig/synfig/issues/2061)) [core] [studio]
- [`1c1c429`](https://github.com/synfig/synfig/commit/1c1c4292ca82c8387adf92b4192c1da7e424ba16) [Lottie exporter] Add support for export of Advanced outline ([#2199](https://github.com/synfig/synfig/issues/2199)) [studio]
- [`3573345`](https://github.com/synfig/synfig/commit/35733456a5744e0392a7dd556618760ad9753264) Fixed crash in rare cases caused by race condition when rebuilding LayerTreeStore ([#2209](https://github.com/synfig/synfig/issues/2209)) [studio]
- [`5718557`](https://github.com/synfig/synfig/commit/571855713add1c0bf6ac5a1df357a4f47e7f53c3) Fixed incorrect background redrawing on animated GIFs with transparent background ([#2134](https://github.com/synfig/synfig/issues/2134)) [core]
- [`2c2062c`](https://github.com/synfig/synfig/commit/2c2062c5d11551394126a995b7107d0c85c3cc1b) Add non-minified bodymovin.js ([#2202](https://github.com/synfig/synfig/issues/2202)) [studio]
- [`223026f`](https://github.com/synfig/synfig/commit/223026f67509dab082509842a215366e2ebe1abf) Resolved 'nan' exception ([#2227](https://github.com/synfig/synfig/issues/2227)) [studio]
- [`541a5ca`](https://github.com/synfig/synfig/commit/541a5ca1e380622496d5dd9f11557db2fd9cc89f) [Lottie exporter] Remove minor error ([#2229](https://github.com/synfig/synfig/issues/2229)) [studio]

## Version 1.4.1 [ETL] [core] [studio]
- [`74a9f4b`](https://github.com/synfig/synfig/commit/74a9f4b707585387bd0f04e07fcfebd910f85871) Change order of Waypoint Editor buttons to match other dialogs ([#1880](https://github.com/synfig/synfig/issues/1880)) [studio]
- [`ef2da51`](https://github.com/synfig/synfig/commit/ef2da51e6eaa456d8806735a04432f443efc57e5) Merge PR ([#1182](https://github.com/synfig/synfig/issues/1182)): Improved dialog waypoint UX [studio]
- [`b555b22`](https://github.com/synfig/synfig/commit/b555b228a6a574babad9a6aeebc46353795313b2) Waypoint Editor didn't properly support enums ([#1968](https://github.com/synfig/synfig/issues/1968)) [studio]
- [`ca04f3d`](https://github.com/synfig/synfig/commit/ca04f3dfa23ea14d53ea281dd1ff832750ab5fce) fix mainwindow not showing when is offscreen ([#1973](https://github.com/synfig/synfig/issues/1973)) [studio]
- [`39807ad`](https://github.com/synfig/synfig/commit/39807ad99f89c0f626c98006e40e855c62a26a32) Bumped year in About dialog ([#1977](https://github.com/synfig/synfig/issues/1977)) [studio]
- [`c526bf2`](https://github.com/synfig/synfig/commit/c526bf2186871d5b4133f3527b3da54390e44f78) don't let inner layer be duplicated twice ([#2050](https://github.com/synfig/synfig/issues/2050)) [studio]
- [`d8e1837`](https://github.com/synfig/synfig/commit/d8e183799995c5ade40bfac4a031e3d9c25266ea) Merge PR[#1971](https://github.com/synfig/synfig/issues/1971): Fix action LayerDuplicate with layers "duplicate" [studio]
- [`03fd60f`](https://github.com/synfig/synfig/commit/03fd60fe879f9be0619f68cd9fbffec5ba243830) fix "Link to Spline" showing when a vertex of spline itself is selected ([#1988](https://github.com/synfig/synfig/issues/1988)) [studio]
- [`06d71c5`](https://github.com/synfig/synfig/commit/06d71c59856fb40951235a478f7d996191404e91) exception-guard now lists SynfigApp exception too ([#2028](https://github.com/synfig/synfig/issues/2028)) [studio]
- [`2f18910`](https://github.com/synfig/synfig/commit/2f18910f4dc1657300574cec93db60a429755d9b) assure uniqueness for new node guid ([#2029](https://github.com/synfig/synfig/issues/2029)) [core]
- [`ba9149a`](https://github.com/synfig/synfig/commit/ba9149aaf3839cd205560fad2630daa23131554e) avoid dereference of invalid TreeIter on Layer TreeView ([#2043](https://github.com/synfig/synfig/issues/2043)) [studio]
- [`94c0805`](https://github.com/synfig/synfig/commit/94c0805673d4888665cf0179062226f01acf6f00)current_working_directory() function now works correctly with non-Latin filenames ([#2011](https://github.com/synfig/synfig/issues/2011)) [ETL]
- [`349810e`](https://github.com/synfig/synfig/commit/349810e2f9a25af3297b776ee88c6c035abdb717) Fixed issue with rendering to file when using non-Latin filenames ([#1940](https://github.com/synfig/synfig/issues/1940)) [core] [studio]
- [`8809482`](https://github.com/synfig/synfig/commit/8809482a2f4485155324b6b49481fb8303094bb9) Added support for loading `average` values ([#1955](https://github.com/synfig/synfig/issues/1955)) [core]
- [`f47d674`](https://github.com/synfig/synfig/commit/f47d6740bacae90b52019aee338c272cef02f49a) Merge PR [#1861](https://github.com/synfig/synfig/issues/1861): Fixed crash when frame rendering throws exception while animating [studio]
- [`7d68380`](https://github.com/synfig/synfig/commit/7d683807d8141e1269f8acb40454d62d1c5c254a) Fixed incorrect import of `lst` files when path contains non-Latin characters ([#1924](https://github.com/synfig/synfig/issues/1924)) [core]
- [`9653378`](https://github.com/synfig/synfig/commit/9653378d5f91f1539a8ab5d4d6c4b17dff2578ce) Fixed crash when right-clicking on group in the Sets panel ([#1920](https://github.com/synfig/synfig/issues/1920)) [studio]
- [`9f9a09e`](https://github.com/synfig/synfig/commit/9f9a09e67711728ccbdb54028f2a22a0f952bed5) Fixed non-working command "Edit image editing in external tool..." ([#1912](https://github.com/synfig/synfig/issues/1912)) [studio]
- [`0bd6fd5`](https://github.com/synfig/synfig/commit/0bd6fd5bde72abe358f841c8a06cc56f3c1f8f86) Merge PR [#1889](https://github.com/synfig/synfig/issues/1889): [Synfig Studio/Windows] Fixed load/save operations for Palette editor [core] [studio]
- [`f7e71c9`](https://github.com/synfig/synfig/commit/f7e71c95d4aa0b2fd63e40fdc43fc5e1b2168f63) Fixed problem with non-working plugins when using paths containing non-Latin characters ([#1882](https://github.com/synfig/synfig/issues/1882)) [studio]
- [`f8de319`](https://github.com/synfig/synfig/commit/f8de31931c1de367f70f46c839a518ea8d4012d2) Fix crash in Spline Tangent converter ([#1836](https://github.com/synfig/synfig/issues/1836)) [core]
- [`5ad6ac5`](https://github.com/synfig/synfig/commit/5ad6ac576c900574e29f3ae4145b622143168173) [MacOS] Fixed SynfigStudio.app won't start if renamed (or contain spaces in name) ([#1834](https://github.com/synfig/synfig/issues/1834))
- [`03ab84d`](https://github.com/synfig/synfig/commit/03ab84debd51a23d430c8e214ed799ab6ef4a59f) Fixed error when output to MPEG-1 format with audio ([#1830](https://github.com/synfig/synfig/issues/1830)) [core]
- [`23bf66a`](https://github.com/synfig/synfig/commit/23bf66ab53aa7bd3ef3a70fb4488a97b005da3da) Fix animation interpolation for boolean values ([#1826](https://github.com/synfig/synfig/issues/1826)) [core]
- [`985afc4`](https://github.com/synfig/synfig/commit/985afc44935778396406150c130b9653b977def3) fix Duplicate layer ignoring all layers but the first one ([#1829](https://github.com/synfig/synfig/issues/1829)) [core]
- [`7deb121`](https://github.com/synfig/synfig/commit/7deb121deaf940c269f71b11c15fdf11e23e6b7e) Restore ctrl-c ctrl+v ctrl+a in Color and Gradient Dialogs ([#1821](https://github.com/synfig/synfig/issues/1821)) [studio]
- [`a583e73`](https://github.com/synfig/synfig/commit/a583e73d4c47914284b15f4a8d7719eafddfe1b4) autotools: pango and imagemagick c++ flags and libs have been moved to their respective modules ([#1688](https://github.com/synfig/synfig/issues/1688)) [core]
- [`bbd7a85`](https://github.com/synfig/synfig/commit/bbd7a85b1f65d2ac02397853b79c19d0f8b672e0) Return true only if id=1 (accept) is clicked ([#1573](https://github.com/synfig/synfig/issues/1573)) [studio]
- [`9ad7d22`](https://github.com/synfig/synfig/commit/9ad7d22d857c42b49bde109af298c77d661a68b4) Merge PR [#1386](https://github.com/synfig/synfig/issues/1386): Toolbar menu [studio]
- [`053841b`](https://github.com/synfig/synfig/commit/053841be1bb8b6c75a1dd098c40948d74c22bd46) Year is fixed in About dialog ([#1238](https://github.com/synfig/synfig/issues/1238)) [studio]
- [`383fcf8`](https://github.com/synfig/synfig/commit/383fcf8) [Autotools] remove support for broken OpenGL rendering ([#2055](https://github.com/synfig/synfig/issues/2055)) [core]
- [`19112f1`](https://github.com/synfig/synfig/commit/19112f10adf3b25aad93057d7a0ed03d35b0b2de) Fix crash in Spline Vertex converter ([#1802](https://github.com/synfig/synfig/issues/1802)) [core]
- [`fb03700`](https://github.com/synfig/synfig/commit/fb037008607153b239cbe7d56fa378cc50655330) Fix crash on unsuccessful action with a clean undo history ([#1643](https://github.com/synfig/synfig/issues/1643)) [studio]
- [`99a1cde`](https://github.com/synfig/synfig/commit/99a1cde2b1e54540857925e6899deb708e17f305) Export video files with sound ([#1623](https://github.com/synfig/synfig/issues/1623)) [core]
