# This Python scron generates a Javascript file which will display the link of
# a randomly chosen page amongst all the pages
import glob

# We list the paths of all the source files and convert them into the paths of
# all the corresponding HTML target files
pages = glob.glob('source/**/*.md', recursive=True)
pages=[s.replace('source/', '/') for s in pages]
pages=[s.replace('.md', '.html') for s in pages]

# We create the template of the Javascript code
template = """var pages = {pages}
var selected_page = pages[Math.floor(Math.random() * pages.length)]
var script_tag = document.getElementById('random_page_js')
var link_text = script_tag.getAttribute("link_text")
var card_link = script_tag.getAttribute("card_link")
var relative_path = script_tag.getAttribute("relative_path")
var random_page_div_or_span = document.getElementById("random-page")
let random_page_anchor = document.createElement("a")
random_page_div_or_span.append(random_page_anchor)
random_page_anchor.setAttribute("href",relative_path + selected_page)
random_page_anchor.setAttribute("class",card_link)
random_page_anchor.innerHTML=link_text
"""
context = {
    "pages":pages,
}

# We write the Javascript code into a dedicated file in the _static directory
with  open('source/_static/js/random_page.js','w') as myfile:
    myfile.write(template.format(**context))
