---
myst:
  html_meta:
    keywords: LaTeX, composition, flottants, légendes, légende non numérotée
---

# Comment obtenir une figure avec une légende non numérotée ?

## Avec l'extension <ctanpkg:ccaption>

L'extension <ctanpkg:ccaption> fournit une commande, nommée `\legend`, 
qui permet d'obtenir le résultat souhaité. Cette commande peut, par ailleurs,
être utilisée en plus de la commande `\caption`, par exemple pour mettre 
une légende (numérotée) au-dessus et une autre, non-numérotée, au-dessous.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{mwe}            % Pour inclure des images factices
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{ccaption}

\begin{document}
En typographie, le terme glyphe désigne la représentation graphique 
d'un caractère typographique, aussi nommé caractère d'imprimerie.
Il peut s’agir d’un caractère alphabétique ou numérique, d’un signe 
de ponctuation, d'un accent ou d'une ligature.
\begin{figure}[ht]
  \centering
  \includegraphics[width=.3\linewidth]{example-image-a}
  \legend{Un glyphe de la lettre A}
\end{figure}
\end{document}
```


## Avec les commandes de base

Une autre solution consiste à placer les commandes suivantes dans le préambule
du document (ou dans un fichier `sty`, auquel cas on enlèvera les commandes
`\makeatletter` et `\makeatother` en début et fin de la redéfinition 
ci-dessous). Ces quelques lignes définissent une commande `\unnumberedcaption`
basée sur la définition de la commande `\caption` :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{mwe}            % Pour inclure des images factices
  \pagestyle{empty}           % N'affiche pas de numéro de page

  % Code qui crée notre nouvelle commande
  \makeatletter
  \newcommand{\unnumberedcaption}%
  {\@dblarg{\@unnumberedcaption\@captype}}

  \newcommand{\@unnumberedcaption}{}%
  \long\def\@unnumberedcaption#1[#2]#3{\par
    \addcontentsline{\csname ext@#1\endcsname}{#1}{%
      % à l'origine : \protect\numberline{\csname the#1\endcsname}%
      % {\ignorespaces #2}
      \protect\numberline{}{\ignorespaces #2}%
      }%
    \begingroup
      \@parboxrestore
      \normalsize
      % à l'origine : \@makecaption{\csname fnum@#1\endcsname}%
      % {\ignorespaces #3}\par
      \@makeunnumberedcaption{\ignorespaces #3}\par
    \endgroup}

  % redéfinit \@makeunnumberedcaption (comme \@makecaption)
  % pour votre propre mise en forme
  \newcommand{\@makeunnumberedcaption}[1]{%
    \vskip\abovecaptionskip
    \sbox\@tempboxa{#1}%
    \ifdim \wd\@tempboxa >\hsize
      #1\par
    \else
      \global \@minipagefalse
      \hbox to\hsize{\hfil\box\@tempboxa\hfil}%
    \fi
    \vskip\belowcaptionskip}

  % pour compatibilité avec LaTeX 2.09 (point historique)
  % définit \abovecaptionskip et \belowcaptionskip
  \@ifundefined{abovecaptionskip}{%
    \newlength{\abovecaptionskip}%
    \setlength{\abovecaptionskip}{10pt}%
  }{}
  \@ifundefined{belowcaptionskip}{%
    \newlength{\belowcaptionskip}%
    \setlength{\belowcaptionskip}{0pt}%
  }{}
  \makeatother
  % Fin du code

\begin{document}
En typographie, le terme glyphe désigne la représentation graphique 
d'un caractère typographique, aussi nommé caractère d'imprimerie.
Il peut s’agir d’un caractère alphabétique ou numérique, d’un signe 
de ponctuation, d'un accent ou d'une ligature.
\begin{figure}[ht]
  \centering
  \includegraphics[width=.3\linewidth]{example-image-a}
  \unnumberedcaption{Un glyphe de la lettre A}
\end{figure}
\end{document}
```

Il faut noter que cette commande ne sera pas modifiée 
par les différentes extensions susceptibles de redéfinir la commande
`\caption`, comme par exemple <ctanpkg:caption>.