# What is modularize
Modularize is a tool named after clang's
[modularize](https://clang.llvm.org/extra/modularize.html) tool to allow you to
modularize a platform.

# How do I use it?
If you want to create a new platform, you will want to do the following. If you
want to update an existing platform, you can either follow the instructions
below, or replace the `-C <directory>` with `--all` to update all platforms
(strongly recommended to do this at least once before submitting).

1) Create a gn output directory for said platform with the following values set:
   * `target_os = "<platform's os>"`
   * `target_cpu = "<platform's cpu>"`
   * `use_clang_modules = true` (required because of libcxx's generated
     directories)
2) Run `modularize.py -C out/<directory> --cache` (`--cache` is strongly
   recommended, `--no-cache` should only be used if you've modified
   `compiler.py` or `modulemap.py`. Caching reduces the runtime from minutes to
   ~1 second).
3) Check if it works (don't forget to set `use_autogenerated_modules = true` in
   your `args.gn`)
4) If it doesn't work, you can modify `config.py` to add any customization, then
   go back to step 2.

For example, if you want to create a linux-arm64 configuration, you would create
or reuse an output directory with the following args.gn:
```
target_os = "linux"
target_cpu = "arm64"
use_clang_modules = true
```
